/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.tree;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JGraphRadialTreeLayout
implements JGraphLayout {
    private static final double TWO_PI = Math.PI * 2;
    protected Object virtualRootCell = new Object();
    protected boolean moveRoots = false;
    protected double angleOffset = 0.5;
    protected boolean autoRadius = false;
    protected double minradiusx = 80.0;
    protected double minradiusy = 80.0;
    protected double maxradiusx = 1000.0;
    protected double maxradiusy = 1000.0;
    protected double radiusx = 100.0;
    protected double radiusy = 100.0;
    protected double rootx;
    protected double rooty;
    protected transient Map nodes = new Hashtable();

    public void run(JGraphFacade jGraphFacade) {
        if (jGraphFacade.getRootCount() == 0) {
            jGraphFacade.findTreeRoots();
        }
        this.nodes.clear();
        for (int i = 0; i < jGraphFacade.getRootCount(); ++i) {
            jGraphFacade.dfs(jGraphFacade.getRootAt(i), new JGraphFacade.CellVisitor(){

                public void visit(Object object, Object object2, Object object3, int n, int n2) {
                    if (!JGraphRadialTreeLayout.this.nodes.keySet().contains(object2)) {
                        TreeNode treeNode = JGraphRadialTreeLayout.this.getTreeNode(object);
                        TreeNode treeNode2 = JGraphRadialTreeLayout.this.getTreeNode(object2);
                        if (treeNode != null) {
                            treeNode.children.add(treeNode2);
                        }
                    }
                }
            });
        }
        Object object = jGraphFacade.getRootCount() == 1 ? jGraphFacade.getRootAt(0) : null;
        TreeNode treeNode = this.getTreeNode(object);
        if (null == treeNode) {
            return;
        }
        double d = treeNode.getDepth();
        if (jGraphFacade.getRootCount() == 1) {
            Point2D point2D = jGraphFacade.getLocation(jGraphFacade.getRootAt(0));
            this.rootx = (int)point2D.getX();
            this.rooty = (int)point2D.getY();
        } else {
            Rectangle2D rectangle2D = jGraphFacade.getGraphBounds();
            if (rectangle2D != null) {
                this.rootx = (double)((int)rectangle2D.getX()) + rectangle2D.getWidth() / 2.0;
                this.rooty = (double)((int)rectangle2D.getY()) + rectangle2D.getHeight() / 2.0;
            }
        }
        if (this.autoRadius) {
            this.radiusx = Math.min(this.maxradiusx, Math.max(this.minradiusx, this.rootx / d));
            this.radiusy = Math.min(this.maxradiusx, Math.max(this.minradiusy, this.rooty / d));
        }
        this.layoutTree0(jGraphFacade, treeNode);
    }

    public TreeNode getTreeNode(Object object) {
        if (object == null) {
            object = this.virtualRootCell;
        }
        if (object != null) {
            TreeNode treeNode = (TreeNode)this.nodes.get(object);
            if (treeNode == null) {
                treeNode = new TreeNode(object);
                this.nodes.put(object, treeNode);
            }
            return treeNode;
        }
        return null;
    }

    private void layoutTree0(JGraphFacade jGraphFacade, TreeNode treeNode) {
        treeNode.angle = 0.0;
        treeNode.x = this.rootx;
        treeNode.y = this.rooty;
        treeNode.rightBisector = 0.0;
        treeNode.rightTangent = 0.0;
        treeNode.leftBisector = Math.PI * 2;
        treeNode.leftTangent = Math.PI * 2;
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(1);
        arrayList.add(treeNode);
        this.layoutTreeN(jGraphFacade, 1, arrayList);
    }

    private void layoutTreeN(JGraphFacade jGraphFacade, int n, List list) {
        int n2 = jGraphFacade.getRootCount() > 1 ? 1 : 0;
        double d = 0.0;
        TreeNode treeNode = null;
        TreeNode treeNode2 = null;
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            List list2 = treeNode3.getChildren();
            double d2 = treeNode3.rightLimit();
            double d3 = (treeNode3.leftLimit() - d2) / (double)list2.size();
            Iterator iterator2 = list2.iterator();
            double d4 = this.angleOffset;
            while (iterator2.hasNext()) {
                TreeNode treeNode4 = (TreeNode)iterator2.next();
                Object object = treeNode4.getCell();
                treeNode4.angle = d2 + d4 * d3;
                if (this.moveRoots || n > n2) {
                    treeNode4.x = this.rootx + (double)n * this.radiusx * Math.cos(treeNode4.angle);
                    treeNode4.y = this.rooty + (double)n * this.radiusy * Math.sin(treeNode4.angle);
                    jGraphFacade.setLocation(object, treeNode4.x, treeNode4.y);
                }
                if (treeNode4.hasChildren()) {
                    arrayList.add(treeNode4);
                    if (null == treeNode) {
                        treeNode = treeNode4;
                    }
                    double d5 = treeNode4.angle - d;
                    treeNode4.rightBisector = treeNode4.angle - d5 / 2.0;
                    if (null != treeNode2) {
                        treeNode2.leftBisector = treeNode4.rightBisector;
                    }
                    double d6 = (double)n / ((double)n + 1.0);
                    double d7 = 2.0 * Math.asin(d6);
                    treeNode4.leftTangent = treeNode4.angle + d7;
                    treeNode4.rightTangent = treeNode4.angle - d7;
                    d = treeNode4.angle;
                    treeNode2 = treeNode4;
                }
                d4 += 1.0;
            }
        }
        if (null != treeNode) {
            double d8 = Math.PI * 2 - treeNode2.angle;
            treeNode.rightBisector = (treeNode.angle - d8) / 2.0;
            treeNode2.leftBisector = treeNode.rightBisector < 0.0 ? treeNode.rightBisector + Math.PI * 2 + Math.PI * 2 : treeNode.rightBisector + Math.PI * 2;
        }
        if (arrayList.size() > 0) {
            this.layoutTreeN(jGraphFacade, n + 1, arrayList);
        }
    }

    public double getRadiusx() {
        return this.radiusx;
    }

    public void setRadiusx(double d) {
        this.radiusx = d;
    }

    public double getRadiusy() {
        return this.radiusy;
    }

    public void setRadiusy(double d) {
        this.radiusy = d;
    }

    public double getAngleOffset() {
        return this.angleOffset;
    }

    public void setAngleOffset(double d) {
        this.angleOffset = d;
    }

    public boolean isAutoRadius() {
        return this.autoRadius;
    }

    public void setAutoRadius(boolean bl) {
        this.autoRadius = bl;
    }

    public boolean isMoveRoots() {
        return this.moveRoots;
    }

    public void setMoveRoots(boolean bl) {
        this.moveRoots = bl;
    }

    public double getMaxradiusx() {
        return this.maxradiusx;
    }

    public void setMaxradiusx(double d) {
        this.maxradiusx = d;
    }

    public double getMaxradiusy() {
        return this.maxradiusy;
    }

    public void setMaxradiusy(double d) {
        this.maxradiusy = d;
    }

    public double getMinradiusx() {
        return this.minradiusx;
    }

    public void setMinradiusx(double d) {
        this.minradiusx = d;
    }

    public double getMinradiusy() {
        return this.minradiusy;
    }

    public void setMinradiusy(double d) {
        this.minradiusy = d;
    }

    public String toString() {
        return "Radialtree";
    }

    private static class TreeNode {
        private Object cell;
        private List children = new ArrayList();
        public double angle;
        public double x;
        public double y;
        public double rightBisector;
        public double leftBisector;
        public double rightTangent;
        public double leftTangent;

        TreeNode(Object object) {
            this.cell = object;
        }

        public int getDepth() {
            int n = 1;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                TreeNode treeNode = (TreeNode)iterator.next();
                int n2 = treeNode.getDepth();
                if (n2 < n) continue;
                n = n2 + 1;
            }
            return n;
        }

        public Object getCell() {
            return this.cell;
        }

        public void addChild(TreeNode treeNode) {
            this.children.add(treeNode);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public double leftLimit() {
            return Math.min(this.normalize(this.leftBisector), this.leftTangent);
        }

        public double rightLimit() {
            return Math.max(this.normalize(this.rightBisector), this.rightTangent);
        }

        private double normalize(double d) {
            return d;
        }
    }
}

