/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.event;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.event.CayenneEvent;

public class SnapshotEvent
extends CayenneEvent {
    protected long timestamp = System.currentTimeMillis();
    protected Collection<ObjectId> deletedIds;
    protected Collection<ObjectId> invalidatedIds;
    protected Map<ObjectId, DataRow> modifiedDiffs;
    protected Collection<ObjectId> indirectlyModifiedIds;

    public SnapshotEvent(Object source, Object postedBy, Map<ObjectId, DataRow> modifiedDiffs, Collection<ObjectId> deletedIds, Collection<ObjectId> invalidatedIds, Collection<ObjectId> indirectlyModifiedIds) {
        super(source, postedBy, null);
        this.modifiedDiffs = modifiedDiffs;
        this.deletedIds = deletedIds;
        this.invalidatedIds = invalidatedIds;
        this.indirectlyModifiedIds = indirectlyModifiedIds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<ObjectId, DataRow> getModifiedDiffs() {
        return this.modifiedDiffs != null ? this.modifiedDiffs : Collections.emptyMap();
    }

    public Collection<ObjectId> getDeletedIds() {
        return this.deletedIds != null ? this.deletedIds : Collections.emptyList();
    }

    public Collection<ObjectId> getInvalidatedIds() {
        return this.invalidatedIds != null ? this.invalidatedIds : Collections.emptyList();
    }

    public Collection<ObjectId> getIndirectlyModifiedIds() {
        return this.indirectlyModifiedIds != null ? this.indirectlyModifiedIds : Collections.emptyList();
    }

    @Override
    public String toString() {
        Collection<ObjectId> related;
        Collection<ObjectId> invalidated;
        Collection<ObjectId> deleted;
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SnapshotEvent] source: ").append(this.getSource());
        Map<ObjectId, DataRow> modified = this.getModifiedDiffs();
        if (!modified.isEmpty()) {
            buffer.append(", modified ").append(modified.size()).append(" id(s)");
        }
        if (!(deleted = this.getDeletedIds()).isEmpty()) {
            buffer.append(", deleted ").append(deleted.size()).append(" id(s)");
        }
        if (!(invalidated = this.getInvalidatedIds()).isEmpty()) {
            buffer.append(", invalidated ").append(invalidated.size()).append(" id(s)");
        }
        if (!(related = this.getIndirectlyModifiedIds()).isEmpty()) {
            buffer.append(", indirectly modified ").append(related.size()).append(" id(s)");
        }
        return buffer.toString();
    }
}

