/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.FaultCode;
import org.apache.sandesha2.wsrm.RMHeaderPart;

public class SequenceFault
implements RMHeaderPart {
    private FaultCode faultCode;
    private String namespaceValue = null;
    private OMNamespace omNamespace = null;

    public SequenceFault(String namespaceValue) {
        this.namespaceValue = namespaceValue;
        this.omNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceValue) ? Sandesha2Constants.SPEC_2005_02.OM_NS_URI : Sandesha2Constants.SPEC_2007_02.OM_NS_URI;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromHeaderBlock(SOAPHeaderBlock sequenceFaultPart) throws OMException, SandeshaException {
        if (sequenceFaultPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noSeqFaultInElement", null));
        }
        OMElement faultCodePart = sequenceFaultPart.getFirstChildWithName(new QName(this.namespaceValue, "FaultCode"));
        if (faultCodePart != null) {
            this.faultCode = new FaultCode(this.namespaceValue);
            this.faultCode.fromOMElement((OMElement)sequenceFaultPart);
        }
        sequenceFaultPart.setProcessed();
        return this;
    }

    public void setFaultCode(FaultCode faultCode) {
        this.faultCode = faultCode;
    }

    public FaultCode getFaultCode() {
        return this.faultCode;
    }

    public void toHeader(SOAPHeader header) {
        SOAPHeaderBlock sequenceFaultElement = header.addHeaderBlock("SequenceFault", this.omNamespace);
        if (this.faultCode != null) {
            this.faultCode.toOMElement((OMElement)sequenceFaultElement);
        }
    }
}

