/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.javax.tools;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openjdk.javax.tools.JavaFileManager;

public enum StandardLocation implements JavaFileManager.Location
{
    CLASS_OUTPUT,
    SOURCE_OUTPUT,
    CLASS_PATH,
    SOURCE_PATH,
    ANNOTATION_PROCESSOR_PATH,
    ANNOTATION_PROCESSOR_MODULE_PATH,
    PLATFORM_CLASS_PATH,
    NATIVE_HEADER_OUTPUT,
    MODULE_SOURCE_PATH,
    UPGRADE_MODULE_PATH,
    SYSTEM_MODULES,
    MODULE_PATH,
    PATCH_MODULE_PATH;

    private static final ConcurrentMap<String, JavaFileManager.Location> locations;

    public static JavaFileManager.Location locationFor(final String string) {
        if (locations.isEmpty()) {
            for (StandardLocation standardLocation : StandardLocation.values()) {
                locations.putIfAbsent(standardLocation.getName(), standardLocation);
            }
        }
        string.getClass();
        locations.putIfAbsent(string, new JavaFileManager.Location(){

            @Override
            public String getName() {
                return string;
            }

            @Override
            public boolean isOutputLocation() {
                return string.endsWith("_OUTPUT");
            }
        });
        return (JavaFileManager.Location)locations.get(string);
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isOutputLocation() {
        switch (this) {
            case CLASS_OUTPUT: 
            case SOURCE_OUTPUT: 
            case NATIVE_HEADER_OUTPUT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isModuleOrientedLocation() {
        switch (this) {
            case MODULE_SOURCE_PATH: 
            case ANNOTATION_PROCESSOR_MODULE_PATH: 
            case UPGRADE_MODULE_PATH: 
            case SYSTEM_MODULES: 
            case MODULE_PATH: 
            case PATCH_MODULE_PATH: {
                return true;
            }
        }
        return false;
    }

    static {
        locations = new ConcurrentHashMap<String, JavaFileManager.Location>();
    }
}

