/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.activation;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.util.activation.SizeLimitExceededException;

final class SizeLimitedOutputStream
extends OutputStream {
    private final long maxSize;
    private long size;

    SizeLimitedOutputStream(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.size += (long)len;
        this.checkSize();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.size += (long)b.length;
        this.checkSize();
    }

    @Override
    public void write(int b) throws IOException {
        ++this.size;
        this.checkSize();
    }

    private void checkSize() throws SizeLimitExceededException {
        if (this.size > this.maxSize) {
            throw SizeLimitExceededException.INSTANCE;
        }
    }
}

