/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.codegen.extension.ModulePolicyExtension;
import org.apache.axis2.wsdl.codegen.extension.PolicyExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PolicyEvaluator
implements CodeGenExtension {
    private static final Log log = LogFactory.getLog(PolicyEvaluator.class);
    private CodeGenConfiguration configuration;

    private void init(CodeGenConfiguration configuration, Map namespace2ExtsMap) {
        AxisConfiguration axisConfiguration;
        this.configuration = configuration;
        namespace2ExtsMap.put("http://schemas.xmlsoap.org/ws/2004/09/policy/optimizedmimeserialization", new MTOMPolicyExtension(configuration));
        namespace2ExtsMap.put("http://schemas.xmlsoap.org/ws/2004/09/policy/encoding", new EncodePolicyExtension());
        String repository = configuration.getRepositoryPath();
        if (repository == null) {
            return;
        }
        try {
            ConfigurationContext configurationCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository, null);
            axisConfiguration = configurationCtx.getAxisConfiguration();
        }
        catch (Exception e) {
            log.error((Object)"Cannot create repository : policy will not be supported", (Throwable)e);
            return;
        }
        for (AxisModule axisModule : axisConfiguration.getModules().values()) {
            try {
                Module module;
                String[] namespaces = axisModule.getSupportedPolicyNamespaces();
                if (namespaces == null || !((module = axisModule.getModule()) instanceof ModulePolicyExtension)) continue;
                PolicyExtension ext = ((ModulePolicyExtension)module).getPolicyExtension();
                for (int i = 0; i < namespaces.length; ++i) {
                    namespace2ExtsMap.put(namespaces[i], ext);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error loading policy extension from module " + axisModule.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void engage(CodeGenConfiguration configuration) {
        HashMap namespace2ExtMap = new HashMap();
        this.init(configuration, namespace2ExtMap);
        Document document = this.getEmptyDocument();
        Element rootElement = document.createElement("module-codegen-policy-extensions");
        List<AxisService> axisServices = configuration.getAxisServices();
        for (AxisService axisService : axisServices) {
            Iterator iterator = axisService.getOperations();
            while (iterator.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)iterator.next();
                QName opName = axisOperation.getName();
                PolicyInclude policyInclude = axisOperation.getPolicyInclude();
                Policy policy = policyInclude.getEffectivePolicy();
                if (policy == null) continue;
                this.processPolicies(document, rootElement, policy, opName, namespace2ExtMap);
            }
        }
        configuration.putProperty("module-codegen-policy-extensions", rootElement);
    }

    private void processPolicies(Document document, Element rootElement, Policy policy, QName opName, Map ns2Exts) {
        HashMap map = new HashMap();
        Iterator iterator = policy.getAlternatives();
        if (iterator.hasNext()) {
            String targetNamesapce = null;
            Iterator assertions = ((List)iterator.next()).iterator();
            while (assertions.hasNext()) {
                Assertion assertion = (Assertion)assertions.next();
                targetNamesapce = assertion.getName().getNamespaceURI();
                ArrayList assertionList = (ArrayList)map.get(targetNamesapce);
                if (assertionList == null) {
                    assertionList = new ArrayList();
                    map.put(targetNamesapce, assertionList);
                }
                assertionList.add(assertions);
            }
        }
        for (String targetNamespace : map.keySet()) {
            PolicyExtension policyExtension = (PolicyExtension)ns2Exts.get(targetNamespace);
            if (policyExtension == null) {
                log.warn((Object)("Cannot find a PolicyExtension to process " + targetNamespace + " type assertions"));
                continue;
            }
            policyExtension.init(this.configuration);
            policyExtension.addMethodsToStub(document, rootElement, opName, (List)map.get(targetNamespace));
        }
    }

    private Document getEmptyDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    class EncodePolicyExtension
    implements PolicyExtension {
        EncodePolicyExtension() {
        }

        @Override
        public void init(CodeGenConfiguration configuration) {
        }

        @Override
        public void addMethodsToStub(Document document, Element element, QName operationName, List assertions) {
        }
    }

    class MTOMPolicyExtension
    implements PolicyExtension {
        private boolean setOnce = false;
        private CodeGenConfiguration configuration;

        @Override
        public void init(CodeGenConfiguration configuration) {
        }

        public MTOMPolicyExtension(CodeGenConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void addMethodsToStub(Document document, Element element, QName operationName, List assertions) {
        }
    }
}

