/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerContextAware;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.JmsFrameTranslator;
import org.apache.activemq.transport.stomp.LegacyFrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.ResponseHandler;
import org.apache.activemq.transport.stomp.StompAckEntry;
import org.apache.activemq.transport.stomp.StompCodec;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompFrameError;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompQueueBrowserSubscription;
import org.apache.activemq.transport.stomp.StompSubscription;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolConverter {
    private static final Logger LOG;
    private static final IdGenerator CONNECTION_ID_GENERATOR;
    private static final String BROKER_VERSION;
    private static final StompFrame ping;
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator transactionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationGenerator = new LongSequenceGenerator();
    private final ConcurrentMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap<Integer, ResponseHandler>();
    private final ConcurrentMap<ConsumerId, StompSubscription> subscriptionsByConsumerId = new ConcurrentHashMap<ConsumerId, StompSubscription>();
    private final ConcurrentMap<String, StompSubscription> subscriptions = new ConcurrentHashMap<String, StompSubscription>();
    private final ConcurrentMap<String, ActiveMQDestination> tempDestinations = new ConcurrentHashMap<String, ActiveMQDestination>();
    private final ConcurrentMap<String, String> tempDestinationAmqToStompMap = new ConcurrentHashMap<String, String>();
    private final Map<String, LocalTransactionId> transactions = new ConcurrentHashMap<String, LocalTransactionId>();
    private final StompTransport stompTransport;
    private final ConcurrentMap<String, StompAckEntry> pendingAcksTracker = new ConcurrentHashMap<String, StompAckEntry>();
    private final Map<String, StompAckEntry> pendingAcks = Collections.unmodifiableMap(this.pendingAcksTracker);
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final FrameTranslator frameTranslator = new LegacyFrameTranslator();
    private ConcurrentMap<String, FrameTranslator> jmsFrameTranslators = new ConcurrentHashMap<String, FrameTranslator>();
    private final FactoryFinder FRAME_TRANSLATOR_FINDER = new FactoryFinder("META-INF/services/org/apache/activemq/transport/frametranslator/");
    private final BrokerContext brokerContext;
    private String version = "1.0";
    private long hbReadInterval;
    private long hbWriteInterval;
    private float hbGracePeriodMultiplier = 1.0f;
    private String defaultHeartBeat = "0,0";
    ConnectionInfo connectionInfo = new ConnectionInfo();

    public ProtocolConverter(StompTransport stompTransport, BrokerContext brokerContext) {
        this.stompTransport = stompTransport;
        this.brokerContext = brokerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    protected ResponseHandler createResponseHandler(final StompFrame command) {
        final String receiptId = command.getHeaders().get("receipt");
        if (receiptId != null) {
            return new ResponseHandler(){

                @Override
                public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable exception = ((ExceptionResponse)response).getException();
                        ProtocolConverter.this.handleException(exception, command);
                    } else {
                        StompFrame sc = new StompFrame();
                        sc.setAction("RECEIPT");
                        sc.setHeaders(new HashMap<String, String>(1));
                        sc.getHeaders().put("receipt-id", receiptId);
                        ProtocolConverter.this.stompTransport.sendToStomp(sc);
                    }
                }
            };
        }
        return null;
    }

    protected void sendToActiveMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.stompTransport.sendToActiveMQ(command);
    }

    protected void sendToStomp(StompFrame command) throws IOException {
        this.stompTransport.sendToStomp(command);
    }

    protected FrameTranslator findTranslator(String header) {
        return this.findTranslator(header, null, false);
    }

    protected FrameTranslator findTranslator(String header, ActiveMQDestination destination, boolean advisory) {
        FrameTranslator translator = this.frameTranslator;
        try {
            if (header != null) {
                translator = (FrameTranslator)this.jmsFrameTranslators.get(header);
                if (translator == null) {
                    LOG.info("Creating a new FrameTranslator to convert " + header);
                    translator = (FrameTranslator)this.FRAME_TRANSLATOR_FINDER.newInstance(header);
                    if (translator != null) {
                        LOG.info("Created a new FrameTranslator to convert " + header);
                        this.jmsFrameTranslators.put(header, translator);
                    } else {
                        LOG.error("Failed in creating FrameTranslator to convert " + header);
                    }
                }
            } else if (destination != null && (advisory || AdvisorySupport.isAdvisoryTopic(destination))) {
                translator = new JmsFrameTranslator();
            }
        }
        catch (Exception ignore) {
            LOG.debug("Failed in getting a FrameTranslator to convert ", ignore);
            translator = this.frameTranslator;
        }
        if (translator instanceof BrokerContextAware) {
            ((BrokerContextAware)((Object)translator)).setBrokerContext(this.brokerContext);
        }
        return translator;
    }

    public void onStompCommand(StompFrame command) throws IOException, JMSException {
        block13: {
            try {
                if (command.getClass() == StompFrameError.class) {
                    throw ((StompFrameError)command).getException();
                }
                String action = command.getAction();
                if (action.startsWith("SEND")) {
                    this.onStompSend(command);
                    break block13;
                }
                if (action.startsWith("ACK")) {
                    this.onStompAck(command);
                    break block13;
                }
                if (action.startsWith("NACK")) {
                    this.onStompNack(command);
                    break block13;
                }
                if (action.startsWith("BEGIN")) {
                    this.onStompBegin(command);
                    break block13;
                }
                if (action.startsWith("COMMIT")) {
                    this.onStompCommit(command);
                    break block13;
                }
                if (action.startsWith("ABORT")) {
                    this.onStompAbort(command);
                    break block13;
                }
                if (action.startsWith("SUB")) {
                    this.onStompSubscribe(command);
                    break block13;
                }
                if (action.startsWith("UNSUB")) {
                    this.onStompUnsubscribe(command);
                    break block13;
                }
                if (action.startsWith("CONNECT") || action.startsWith("STOMP")) {
                    this.onStompConnect(command);
                    break block13;
                }
                if (action.startsWith("DISCONNECT")) {
                    this.onStompDisconnect(command);
                    break block13;
                }
                throw new ProtocolException("Unknown STOMP action: " + action, true);
            }
            catch (ProtocolException e) {
                this.handleException(e, command);
                if (!e.isFatal()) break block13;
                this.getStompTransport().onException(e);
            }
        }
    }

    protected void handleException(Throwable exception, StompFrame command) throws IOException {
        String receiptId;
        if (command == null) {
            LOG.warn("Exception occurred while processing a command: {}", (Object)exception.toString());
        } else if (exception instanceof JMSException) {
            JMSException jmsException = (JMSException)exception;
            if (jmsException.getLinkedException() != null) {
                LOG.warn("Exception occurred for client {} ({}) processing: {} -> {} ({})", this.connectionInfo.getClientId(), this.connectionInfo.getClientIp(), this.safeGetAction(command), exception.toString(), jmsException.getLinkedException().toString());
            } else {
                LOG.warn("Exception occurred for client {} ({}) processing: {} -> {}", this.connectionInfo.getClientId(), this.connectionInfo.getClientIp(), this.safeGetAction(command), exception.toString());
            }
        } else {
            LOG.warn("Exception occurred for client {} ({}) processing: {} -> {}", this.connectionInfo.getClientId(), this.connectionInfo.getClientIp(), this.safeGetAction(command), exception.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception detail", exception);
        }
        if (command != null && LOG.isTraceEnabled()) {
            LOG.trace("Command that caused the error: {}", (Object)command);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter stream = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        if (exception instanceof SecurityException || exception.getCause() instanceof SecurityException) {
            stream.write(exception.getLocalizedMessage());
        } else {
            exception.printStackTrace(stream);
        }
        stream.close();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("message", exception.getMessage());
        headers.put("content-type", "text/plain");
        if (command != null && (receiptId = command.getHeaders().get("receipt")) != null) {
            headers.put("receipt-id", receiptId);
        }
        StompFrame errorMessage = new StompFrame("ERROR", headers, baos.toByteArray());
        this.sendToStomp(errorMessage);
    }

    protected void onStompSend(StompFrame command) throws IOException, JMSException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String destination = headers.get("destination");
        if (destination == null) {
            throw new ProtocolException("SEND received without a Destination specified!");
        }
        String stompTx = headers.get("transaction");
        headers.remove("transaction");
        ActiveMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId());
        message.setMessageId(id);
        if (stompTx != null) {
            TransactionId activemqTx = this.transactions.get(stompTx);
            if (activemqTx == null) {
                throw new ProtocolException("Invalid transaction id: " + stompTx);
            }
            message.setTransactionId(activemqTx);
        }
        message.onSend();
        message.beforeMarshall(null);
        this.sendToActiveMQ(message, this.createResponseHandler(command));
    }

    protected void onStompNack(StompFrame command) throws ProtocolException {
        MessageAck ack;
        StompSubscription sub;
        this.checkConnected();
        if (this.version.equals("1.0")) {
            throw new ProtocolException("NACK received but connection is in v1.0 mode.");
        }
        Map<String, String> headers = command.getHeaders();
        String subscriptionId = headers.get("subscription");
        if (subscriptionId == null && !this.version.equals("1.2")) {
            throw new ProtocolException("NACK received without a subscription id for acknowledge!");
        }
        String messageId = headers.get("message-id");
        if (messageId == null && !this.version.equals("1.2")) {
            throw new ProtocolException("NACK received without a message-id to acknowledge!");
        }
        String ackId = headers.get("id");
        if (ackId == null && this.version.equals("1.2")) {
            throw new ProtocolException("NACK received without an ack header to acknowledge!");
        }
        TransactionId activemqTx = null;
        String stompTx = headers.get("transaction");
        if (stompTx != null && (activemqTx = (TransactionId)this.transactions.get(stompTx)) == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        boolean nacked = false;
        if (ackId != null) {
            StompAckEntry pendingAck = this.pendingAcks.get(ackId);
            if (pendingAck != null) {
                messageId = pendingAck.getMessageId().toString();
                MessageAck ack2 = pendingAck.onMessageNack(activemqTx);
                if (ack2 != null) {
                    this.sendToActiveMQ(ack2, this.createResponseHandler(command));
                    nacked = true;
                }
            }
        } else if (subscriptionId != null && (sub = (StompSubscription)this.subscriptions.get(subscriptionId)) != null && (ack = sub.onStompMessageNack(messageId, activemqTx)) != null) {
            this.sendToActiveMQ(ack, this.createResponseHandler(command));
            nacked = true;
        }
        if (!nacked) {
            throw new ProtocolException("Unexpected NACK received for message-id [" + messageId + "]");
        }
    }

    protected void onStompAck(StompFrame command) throws ProtocolException {
        boolean acked;
        String messageId;
        block8: {
            TransactionId activemqTx;
            block9: {
                MessageAck ack;
                String subscriptionId;
                block7: {
                    this.checkConnected();
                    Map<String, String> headers = command.getHeaders();
                    messageId = headers.get("message-id");
                    if (messageId == null && !this.version.equals("1.2")) {
                        throw new ProtocolException("ACK received without a message-id to acknowledge!");
                    }
                    subscriptionId = headers.get("subscription");
                    if (subscriptionId == null && this.version.equals("1.1")) {
                        throw new ProtocolException("ACK received without a subscription id for acknowledge!");
                    }
                    String ackId = headers.get("id");
                    if (ackId == null && this.version.equals("1.2")) {
                        throw new ProtocolException("ACK received without a ack id for acknowledge!");
                    }
                    activemqTx = null;
                    String stompTx = headers.get("transaction");
                    if (stompTx != null && (activemqTx = (TransactionId)this.transactions.get(stompTx)) == null) {
                        throw new ProtocolException("Invalid transaction id: " + stompTx);
                    }
                    acked = false;
                    if (ackId == null) break block7;
                    StompAckEntry pendingAck = this.pendingAcks.get(ackId);
                    if (pendingAck == null) break block8;
                    messageId = pendingAck.getMessageId().toString();
                    MessageAck ack2 = pendingAck.onMessageAck(activemqTx);
                    if (ack2 != null) {
                        this.sendToActiveMQ(ack2, this.createResponseHandler(command));
                        acked = true;
                    }
                    break block8;
                }
                if (subscriptionId == null) break block9;
                StompSubscription sub = (StompSubscription)this.subscriptions.get(subscriptionId);
                if (sub == null || (ack = sub.onStompMessageAck(messageId, activemqTx)) == null) break block8;
                this.sendToActiveMQ(ack, this.createResponseHandler(command));
                acked = true;
                break block8;
            }
            for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
                MessageAck ack = sub.onStompMessageAck(messageId, activemqTx);
                if (ack == null) continue;
                this.sendToActiveMQ(ack, this.createResponseHandler(command));
                acked = true;
                break;
            }
        }
        if (!acked) {
            throw new ProtocolException("Unexpected ACK received for message-id [" + messageId + "]");
        }
    }

    protected void onStompBegin(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (!headers.containsKey("transaction")) {
            throw new ProtocolException("Must specify the transaction you are beginning");
        }
        if (this.transactions.get(stompTx) != null) {
            throw new ProtocolException("The transaction was already started: " + stompTx);
        }
        LocalTransactionId activemqTx = new LocalTransactionId(this.connectionId, this.transactionIdGenerator.getNextSequenceId());
        this.transactions.put(stompTx, activemqTx);
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)0);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompCommit(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId activemqTx = this.transactions.remove(stompTx);
        if (activemqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            sub.onStompCommit(activemqTx);
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)2);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompAbort(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId activemqTx = this.transactions.remove(stompTx);
        if (activemqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            try {
                sub.onStompAbort(activemqTx);
            }
            catch (Exception e) {
                throw new ProtocolException("Transaction abort failed", false, e);
            }
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)4);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompSubscribe(StompFrame command) throws ProtocolException {
        String receiptId;
        String selector;
        this.checkConnected();
        FrameTranslator translator = this.findTranslator(command.getHeaders().get("transformation"));
        Map<String, String> headers = command.getHeaders();
        String subscriptionId = headers.get("id");
        String destination = headers.get("destination");
        if (!this.version.equals("1.0") && subscriptionId == null) {
            throw new ProtocolException("SUBSCRIBE received without a subscription id!");
        }
        if (destination == null || "".equals(destination)) {
            throw new ProtocolException("Invalid empty or 'null' Destination header");
        }
        final ActiveMQDestination actualDest = translator.convertDestination(this, destination, true);
        if (actualDest == null) {
            throw new ProtocolException("Invalid 'null' Destination.");
        }
        final ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setPrefetchSize(actualDest.isQueue() ? 1000 : (headers.containsKey("activemq.subscriptionName") ? 100 : Short.MAX_VALUE));
        consumerInfo.setDispatchAsync(true);
        String browser = headers.get("browser");
        if (browser != null && browser.equals("true")) {
            if (this.version.equals("1.0")) {
                throw new ProtocolException("Queue Browser feature only valid for Stomp v1.1+ clients!");
            }
            consumerInfo.setBrowser(true);
            consumerInfo.setPrefetchSize(500);
        }
        if ((selector = headers.remove("selector")) != null) {
            consumerInfo.setSelector("convert_string_expressions:" + selector);
        }
        IntrospectionSupport.setProperties((Object)consumerInfo, headers, "activemq.");
        if (actualDest.isQueue() && consumerInfo.getSubscriptionName() != null) {
            throw new ProtocolException("Invalid Subscription: cannot durably subscribe to a Queue destination!");
        }
        consumerInfo.setDestination(actualDest);
        consumerInfo.setDispatchAsync(true);
        StompSubscription stompSubscription = !consumerInfo.isBrowser() ? new StompSubscription(this, subscriptionId, consumerInfo, headers.get("transformation"), this.pendingAcksTracker) : new StompQueueBrowserSubscription(this, subscriptionId, consumerInfo, headers.get("transformation"), this.pendingAcksTracker);
        stompSubscription.setDestination(actualDest);
        String ackMode = headers.get("ack");
        if ("client".equals(ackMode)) {
            stompSubscription.setAckMode("client");
        } else if ("client-individual".equals(ackMode)) {
            stompSubscription.setAckMode("client-individual");
        } else {
            stompSubscription.setAckMode("auto");
        }
        this.subscriptionsByConsumerId.put(id, stompSubscription);
        if (subscriptionId != null) {
            this.subscriptions.put(subscriptionId, stompSubscription);
        }
        if ((receiptId = command.getHeaders().get("receipt")) != null && consumerInfo.getPrefetchSize() > 0) {
            final StompFrame cmd = command;
            final int prefetch = consumerInfo.getPrefetchSize();
            consumerInfo.setPrefetchSize(0);
            ResponseHandler handler = new ResponseHandler(){

                @Override
                public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable exception = ((ExceptionResponse)response).getException();
                        ProtocolConverter.this.handleException(exception, cmd);
                    } else {
                        StompFrame sc = new StompFrame();
                        sc.setAction("RECEIPT");
                        sc.setHeaders(new HashMap<String, String>(1));
                        sc.getHeaders().put("receipt-id", receiptId);
                        ProtocolConverter.this.stompTransport.sendToStomp(sc);
                        ConsumerControl control = new ConsumerControl();
                        control.setPrefetch(prefetch);
                        control.setDestination(actualDest);
                        control.setConsumerId(id);
                        ProtocolConverter.this.sendToActiveMQ(control, null);
                    }
                }
            };
            this.sendToActiveMQ(consumerInfo, handler);
        } else {
            this.sendToActiveMQ(consumerInfo, this.createResponseHandler(command));
        }
    }

    protected void onStompUnsubscribe(StompFrame command) throws ProtocolException {
        String durable;
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        ActiveMQDestination destination = null;
        String o = headers.get("destination");
        if (o != null) {
            destination = this.findTranslator(command.getHeaders().get("transformation")).convertDestination(this, o, true);
        }
        String subscriptionId = headers.get("id");
        if (!this.version.equals("1.0") && subscriptionId == null) {
            throw new ProtocolException("UNSUBSCRIBE received without a subscription id!");
        }
        if (subscriptionId == null && destination == null) {
            throw new ProtocolException("Must specify the subscriptionId or the destination you are unsubscribing from");
        }
        String clientId = durable = command.getHeaders().get("activemq.subscriptionName");
        if (!this.version.equals("1.0")) {
            clientId = this.connectionInfo.getClientId();
        }
        if (durable != null) {
            RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
            info.setClientId(clientId);
            info.setSubscriptionName(durable);
            info.setConnectionId(this.connectionId);
            this.sendToActiveMQ(info, this.createResponseHandler(command));
            return;
        }
        if (subscriptionId != null) {
            StompSubscription sub = (StompSubscription)this.subscriptions.remove(subscriptionId);
            if (sub != null) {
                this.subscriptionsByConsumerId.remove(sub.getConsumerInfo().getConsumerId());
                this.sendToActiveMQ(sub.getConsumerInfo().createRemoveCommand(), this.createResponseHandler(command));
                return;
            }
        } else {
            Iterator iter = this.subscriptionsByConsumerId.values().iterator();
            while (iter.hasNext()) {
                StompSubscription sub = (StompSubscription)iter.next();
                if (destination == null || !destination.equals(sub.getDestination())) continue;
                this.sendToActiveMQ(sub.getConsumerInfo().createRemoveCommand(), this.createResponseHandler(command));
                iter.remove();
                return;
            }
        }
        throw new ProtocolException("No subscription matched.");
    }

    protected void onStompConnect(final StompFrame command) throws ProtocolException {
        if (this.connected.get()) {
            throw new ProtocolException("Already connected.");
        }
        final Map<String, String> headers = command.getHeaders();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientId = headers.get("client-id");
        String heartBeat = headers.get("heart-beat");
        String host = headers.get("host");
        if (heartBeat == null) {
            heartBeat = this.defaultHeartBeat;
        }
        this.version = StompCodec.detectVersion(headers);
        this.configureInactivityMonitor(heartBeat.trim());
        IntrospectionSupport.setProperties((Object)this.connectionInfo, headers, "activemq.");
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null) {
            this.connectionInfo.setClientId(clientId);
        } else {
            this.connectionInfo.setClientId(this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setClientIp(host);
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(login);
        this.connectionInfo.setPassword(passcode);
        this.connectionInfo.setTransportContext(command.getTransportContext());
        this.sendToActiveMQ(this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    ProtocolConverter.this.handleException(exception, command);
                    ProtocolConverter.this.getStompTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(ProtocolConverter.this.sessionId);
                ProtocolConverter.this.sendToActiveMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(ProtocolConverter.this.producerId);
                ProtocolConverter.this.sendToActiveMQ(producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            ProtocolConverter.this.handleException(exception, command);
                            ProtocolConverter.this.getStompTransport().onException(IOExceptionSupport.create(exception));
                        }
                        ProtocolConverter.this.connected.set(true);
                        HashMap<String, String> responseHeaders = new HashMap<String, String>();
                        responseHeaders.put("session", ProtocolConverter.this.connectionInfo.getClientId());
                        String requestId = (String)headers.get("request-id");
                        if (requestId == null) {
                            requestId = (String)headers.get("receipt");
                        }
                        if (requestId != null) {
                            responseHeaders.put("response-id", requestId);
                            responseHeaders.put("receipt-id", requestId);
                        }
                        responseHeaders.put("version", ProtocolConverter.this.version);
                        responseHeaders.put("heart-beat", String.format("%d,%d", ProtocolConverter.this.hbWriteInterval, ProtocolConverter.this.hbReadInterval));
                        responseHeaders.put("server", "ActiveMQ/" + BROKER_VERSION);
                        StompFrame sc = new StompFrame();
                        sc.setAction("CONNECTED");
                        sc.setHeaders(responseHeaders);
                        ProtocolConverter.this.sendToStomp(sc);
                        StompWireFormat format = ProtocolConverter.this.stompTransport.getWireFormat();
                        if (format != null) {
                            format.setStompVersion(ProtocolConverter.this.version);
                        }
                    }
                });
            }
        });
    }

    protected void onStompDisconnect(StompFrame command) throws ProtocolException {
        if (this.connected.get()) {
            LOG.trace("Connection closed with {} pending ACKs still being tracked.", (Object)this.pendingAcks.size());
            this.sendToActiveMQ(this.connectionInfo.createRemoveCommand(), this.createResponseHandler(command));
            this.sendToActiveMQ(new ShutdownInfo(), this.createResponseHandler(command));
            this.connected.set(false);
        }
    }

    protected void checkConnected() throws ProtocolException {
        if (!this.connected.get()) {
            throw new ProtocolException("Not connected.");
        }
    }

    public void onActiveMQCommand(Command command) throws IOException, JMSException {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = (ResponseHandler)this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            StompSubscription sub = (StompSubscription)this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                sub.onMessageDispatch(md);
            }
        } else if (command.getDataStructureType() == 10) {
            this.stompTransport.sendToStomp(ping);
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        }
    }

    public ActiveMQMessage convertMessage(StompFrame command) throws IOException, JMSException {
        ActiveMQMessage msg = this.findTranslator(command.getHeaders().get("transformation")).convertFrame(this, command);
        return msg;
    }

    public StompFrame convertMessage(ActiveMQMessage message, boolean ignoreTransformation) throws IOException, JMSException {
        if (ignoreTransformation) {
            return this.frameTranslator.convertMessage(this, message);
        }
        FrameTranslator translator = this.findTranslator(message.getStringProperty("transformation"), message.getDestination(), message.isAdvisory());
        return translator.convertMessage(this, message);
    }

    public StompTransport getStompTransport() {
        return this.stompTransport;
    }

    public ActiveMQDestination createTempDestination(String name, boolean topic) {
        ActiveMQDestination rc = (ActiveMQDestination)this.tempDestinations.get(name);
        if (rc == null) {
            rc = topic ? new ActiveMQTempTopic(this.connectionId, this.tempDestinationGenerator.getNextSequenceId()) : new ActiveMQTempQueue(this.connectionId, this.tempDestinationGenerator.getNextSequenceId());
            this.sendToActiveMQ(new DestinationInfo(this.connectionId, 0, rc), null);
            this.tempDestinations.put(name, rc);
            this.tempDestinationAmqToStompMap.put(rc.getQualifiedName(), name);
        }
        return rc;
    }

    public String getCreatedTempDestinationName(ActiveMQDestination destination) {
        return (String)this.tempDestinationAmqToStompMap.get(destination.getQualifiedName());
    }

    public String getDefaultHeartBeat() {
        return this.defaultHeartBeat;
    }

    public void setDefaultHeartBeat(String defaultHeartBeat) {
        this.defaultHeartBeat = defaultHeartBeat;
    }

    public float getHbGracePeriodMultiplier() {
        return this.hbGracePeriodMultiplier;
    }

    public void setHbGracePeriodMultiplier(float hbGracePeriodMultiplier) {
        this.hbGracePeriodMultiplier = hbGracePeriodMultiplier;
    }

    protected void configureInactivityMonitor(String heartBeatConfig) throws ProtocolException {
        String[] keepAliveOpts = heartBeatConfig.split(",");
        if (keepAliveOpts == null || keepAliveOpts.length != 2) {
            throw new ProtocolException("Invalid heart-beat header:" + heartBeatConfig, true);
        }
        try {
            this.hbReadInterval = Long.parseLong(keepAliveOpts[0]);
            this.hbWriteInterval = Long.parseLong(keepAliveOpts[1]);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid heart-beat header:" + heartBeatConfig, true);
        }
        try {
            StompInactivityMonitor monitor = this.stompTransport.getInactivityMonitor();
            monitor.setReadCheckTime((long)((float)this.hbReadInterval * this.hbGracePeriodMultiplier));
            monitor.setInitialDelayTime(Math.min(this.hbReadInterval, this.hbWriteInterval));
            monitor.setWriteCheckTime(this.hbWriteInterval);
            monitor.startMonitoring();
        }
        catch (Exception ex) {
            this.hbReadInterval = 0L;
            this.hbWriteInterval = 0L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stomp Connect heartbeat conf RW[{},{}]", (Object)this.hbReadInterval, (Object)this.hbWriteInterval);
        }
    }

    protected void sendReceipt(StompFrame command) {
        String receiptId = command.getHeaders().get("receipt");
        if (receiptId != null) {
            StompFrame sc = new StompFrame();
            sc.setAction("RECEIPT");
            sc.setHeaders(new HashMap<String, String>(1));
            sc.getHeaders().put("receipt-id", receiptId);
            try {
                this.sendToStomp(sc);
            }
            catch (IOException e) {
                LOG.warn("Could not send a receipt for {}", (Object)command, (Object)e);
            }
        }
    }

    protected Object safeGetAction(StompFrame command) {
        String action;
        String result = "<Unknown>";
        if (command != null && command.getAction() != null && (action = command.getAction().trim()) != null) {
            switch (action) {
                case "SEND": 
                case "ACK": 
                case "NACK": 
                case "BEGIN": 
                case "COMMIT": 
                case "ABORT": 
                case "SUBSCRIBE": 
                case "UNSUBSCRIBE": 
                case "CONNECT": 
                case "STOMP": 
                case "DISCONNECT": {
                    result = action;
                    break;
                }
                case "SUB": {
                    result = "SUBSCRIBE";
                }
                case "UNSUB": {
                    result = "UNSUBSCRIBE";
                }
            }
        }
        return result;
    }

    boolean isStomp10() {
        return this.version.equals("1.0");
    }

    boolean isStomp11() {
        return this.version.equals("1.1");
    }

    boolean isStomp12() {
        return this.version.equals("1.2");
    }

    static {
        String version;
        block18: {
            LOG = LoggerFactory.getLogger(ProtocolConverter.class);
            CONNECTION_ID_GENERATOR = new IdGenerator();
            ping = new StompFrame("KEEPALIVE");
            version = "5.6.0";
            try (InputStream in = ProtocolConverter.class.getResourceAsStream("/org/apache/activemq/version.txt");){
                if (in == null) break block18;
                try (InputStreamReader isr = new InputStreamReader(in);
                     BufferedReader reader = new BufferedReader(isr);){
                    version = reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BROKER_VERSION = version;
    }
}

