.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP AGGREGATE" "" "2010-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP AGGREGATE \- remove an aggregate function

.SH SYNOPSIS
.sp
.nf
DROP AGGREGATE \fIname\fR ( \fItype\fR ) [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP AGGREGATE\fR will delete an existing
aggregate function. To execute this command the current
user must be the owner of the aggregate function.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing aggregate function.
.TP
\fB\fItype\fB\fR
The argument data type of the aggregate function, or
* if the function accepts any data type.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the aggregate function.
.TP
\fBRESTRICT\fR
Refuse to drop the aggregate function if any objects depend on
it. This is the default.
.SH "EXAMPLES"
.PP
To remove the aggregate function myavg for type
\fBinteger\fR:
.sp
.nf
DROP AGGREGATE myavg(integer);
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBDROP AGGREGATE\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER AGGREGATE [\fBalter_aggregate\fR(l)], CREATE AGGREGATE [\fBcreate_aggregate\fR(l)]
