.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER DATABASE" "" "2008-10-31" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER DATABASE \- change a database

.SH SYNOPSIS
.sp
.nf
ALTER DATABASE \fIname\fR SET \fIparameter\fR { TO | = } { \fIvalue\fR | DEFAULT }
ALTER DATABASE \fIname\fR RESET \fIparameter\fR

ALTER DATABASE \fIname\fR RENAME TO \fInewname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER DATABASE\fR is used to change the attributes
of a database.
.PP
The first two forms change the session default of a run-time
configuration variable for a PostgreSQL
database. Whenever a new session is subsequently started in that
database, the specified value becomes the session default value.
The database-specific default overrides whatever setting is present
in \fIpostgresql.conf\fR or has been received from the
\fBpostmaster\fR command line. Only the database
owner or a superuser can change the session defaults for a
database.
.PP
The third form changes the name of the database. Only the database
owner can rename a database, and only if he has the
CREATEDB privilege. The current database cannot
be renamed. (Connect to a different database if you need to do
that.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the database whose session defaults are to be altered.
.TP
\fB\fIparameter\fB\fR
.TP
\fB\fIvalue\fB\fR
Set the session default for this database of the specified
configuration parameter to the given value. If
\fIvalue\fR is DEFAULT
or, equivalently, RESET is used, the
database-specific variable setting is removed and the system-wide
default
setting will be inherited in new sessions. Use RESET
ALL to clear all settings.

See SET [\fBset\fR(l)] and [XRef to RUNTIME-CONFIG]
for more information about allowed parameter names
and values.
.TP
\fB\fInewname\fB\fR
The new name of the database.
.SH "NOTES"
.PP
Using ALTER USER [\fBalter_user\fR(l)],
it is also possible to tie a session default to a specific user
rather than a database. User-specific settings override database-specific
ones if there is a conflict.
.SH "EXAMPLES"
.PP
To disable index scans by default in the database
test:
.sp
.nf
ALTER DATABASE test SET enable_indexscan TO off;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER DATABASE\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
ALTER USER [\fBalter_user\fR(l)], CREATE DATABASE [\fBcreate_database\fR(l)], DROP DATABASE [\fBdrop_database\fR(l)], SET [\fBset\fR(l)]
