.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SELECT INTO" "l" "2002-03-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
SELECT INTO \- create a new table from the results of a query
.SH SYNOPSIS
.sp
.nf
SELECT [ ALL | DISTINCT [ ON ( \fIexpression\fR [, ...] ) ] ]
    * | \fIexpression\fR [ AS \fIoutput_name\fR ] [, ...]
    INTO [ TEMPORARY | TEMP ] [ TABLE ] \fInew_table\fR
    [ FROM \fIfrom_item\fR [, ...] ]
    [ WHERE \fIcondition\fR ]
    [ GROUP BY \fIexpression\fR [, ...] ]
    [ HAVING \fIcondition\fR [, ...] ]
    [ { UNION | INTERSECT | EXCEPT } [ ALL ] \fIselect\fR ]
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ FOR UPDATE [ OF \fItablename\fR [, ...] ] ]
    [ LIMIT [ \fIstart\fR , ] { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]

where \fIfrom_item\fR can be:

[ ONLY ] \fItable_name\fR [ * ]
    [ [ AS ] \fIalias\fR [ ( \fIcolumn_alias_list\fR ) ] ]
|
( \fIselect\fR )
    [ AS ] \fIalias\fR [ ( \fIcolumn_alias_list\fR ) ]
|
\fIfrom_item\fR [ NATURAL ] \fIjoin_type\fR \fIfrom_item\fR
    [ ON \fIjoin_condition\fR | USING ( \fIjoin_column_list\fR ) ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTEMPORARY\fR
.TP
\fBTEMP\fR
If TEMPORARY or TEMP is specified,
the output table is created only within this session, and is
automatically dropped on session exit.
Existing permanent tables with the same name are not visible
(in this session) while the temporary table exists.
Any indexes created on a temporary table are automatically
temporary as well.
.TP
\fB\fInew_table\fB\fR
The name of the new table to be created.
This table must not already exist. However, a temporary table
can be created that has the same name as an existing permanent
table.
.PP
.PP
All other inputs are described in detail for
\fBselect\fR(l).
.SS "OUTPUTS"
.PP
Refer to
\fBcreate_table\fR(l)
and
\fBselect\fR(l)
for a summary of possible output messages.
.SH "DESCRIPTION"
.PP
\fBSELECT INTO\fR creates a new table and fills it
with data computed by a query. The data is not returned to the
client, as it is with a normal \fBSELECT\fR. The new
table's columns have the names and data types associated with the
output columns of the \fBSELECT\fR.
.sp
.RS
.B "Note:"
\fBcreate_table_as\fR(l)
is functionally equivalent to \fBSELECT INTO\fR.
\fBCREATE TABLE AS\fR is the recommended syntax, since
\fBSELECT INTO\fR is not standard. In fact, this form of
\fBSELECT INTO\fR is not available in \fBPL/pgSQL\fR or \fBecpg\fR(1),
because they interpret the INTO clause differently.
.RE
.sp
.SH "COMPATIBILITY"
.PP
SQL92 uses \fBSELECT ... INTO\fR to represent selecting
values into scalar variables of a host program, rather than creating
a new table. This indeed is the usage found in \fBPL/pgSQL\fR and \fBecpg\fR(1).
The PostgreSQL usage of \fBSELECT
INTO\fR to represent table creation is historical. It's best
to use \fBCREATE TABLE AS\fR for this purpose in new code.
(\fBCREATE TABLE AS\fR isn't standard either, but it's
less likely to cause confusion.)
