.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP VIEW" "l" "2002-03-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP VIEW \- remove a view
.SH SYNOPSIS
.sp
.nf
DROP VIEW \fIname\fR [, ...]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing view.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command is successful.
.TP
\fBERROR: view \fIname\fB does not exist\fR
This message occurs if the specified view does not exist in
the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP VIEW\fR drops an existing view from the database.
To execute this command you must be the owner of the
view.
.SS "NOTES"
.PP
Refer to \fBCREATE VIEW\fR
for information on how to create views.
.SH "USAGE"
.PP
This command will remove the view called kinds:
.sp
.nf
DROP VIEW kinds;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 specifies some additional capabilities for
\fBDROP VIEW\fR:
.sp
.nf
DROP VIEW \fIview\fR { RESTRICT | CASCADE }
    
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBRESTRICT\fR
Ensures that only a view with no dependent views or
integrity constraints can be destroyed.
.TP
\fBCASCADE\fR
Any referencing views and integrity constraints
will be dropped as well.
.PP
.SS "NOTES"
.PP
At present, to remove a referenced view from a
PostgreSQL database, 
you must drop it explicitly.
