/* $Id: geometric.h,v 1.2 2005/12/04 22:36:53 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Interface to Postgres geometric types
 */
#ifndef PyPg_type_geometric_H
#define PyPg_type_geometric_H 0
#ifdef __cplusplus
extern "C" {
#endif

IF_PGTYPE_POINT(extern PyPgTypeObject PyPg_point_Type;)
IF_PGTYPE_LSEG(extern PyPgTypeObject PyPg_lseg_Type;)
IF_PGTYPE_PATH(extern PyPgTypeObject PyPg_path_Type;)
IF_PGTYPE_BOX(extern PyPgTypeObject PyPg_box_Type;)
IF_PGTYPE_LINE(extern PyPgTypeObject PyPg_line_Type;)
IF_PGTYPE_CIRCLE(extern PyPgTypeObject PyPg_circle_Type;)

PyObj PyPg_point_FromPySequence(PyTypeObject *, PyObj);
PyObj PyPg_point_FromPyObject(PyTypeObject *, PyObj);

#define PyPg_point_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_point_Type))
#define PyPg_point_CheckExact(SELF) ((SELF)->ob_type == &PyPg_point_Type)

#define PyPg_lseg_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_lseg_Type))
#define PyPg_lseg_CheckExact(SELF) ((SELF)->ob_type == &PyPg_point_Type)

#define PyPg_path_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_path_Type))
#define PyPg_path_CheckExact(SELF) ((SELF)->ob_type == &PyPg_point_Type)

#define PyPg_box_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_box_Type))
#define PyPg_box_CheckExact(SELF) ((SELF)->ob_type == &PyPg_point_Type)

#define PyPg_line_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_line_Type))
#define PyPg_line_CheckExact(SELF) ((SELF)->ob_type == &PyPg_point_Type)

#define PyPg_circle_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_circle_Type))
#define PyPg_circle_CheckExact(SELF) ((SELF)->ob_type == &PyPg_point_Type)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_geometric_H */
/*
 * vim: ts=3:sw=3:noet:
 */
