/* $Id: array.h,v 1.1 2005/10/21 21:54:55 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Python interface to the Postgres ArrayType. [Abtract Type]
 */
#ifndef PyPg_type_array_H
#define PyPg_type_array_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgArray {
	PyPgObject_HEAD
	PyObject *arr_element_type;
} * PyPgArray;

#ifndef PyPg_ci_H
extern PyPgTypeObject PyPgArray_Type;
PyObj PyPgArray_Initialize(PyObj, ArrayType *);
#else
#define PyPgArray_Type (*(PyPgCI._PyPgArray_Type))
#endif

#define PyPgArray_NEW() \
	(PyObj) PyPgArray_Type.tp_alloc(&PyPgArray_Type, 0)
#define PyPgArray_New(R) \
	PyPgArray_Initialize(PyPgArray_NEW(), R)

#define PyPgArray(SELF) ((PyPgArray) SELF)

#define PyPgArray_Check(SELF) (PyObject_TypeCheck(SELF, &PyPgArray_Type))
#define PyPgArray_CheckExact(SELF) (SELF->ob_type == &PyPgArray_Type)

#define PyPgArray_FetchArrayType(SELF) \
	((ArrayType *) (DatumGetPointer(PyPgObject_FetchDatum(SELF))))

#define PyPgArray_FixArrayType(SELF, R) \
	PyPgObject_FixDatum(SELF, PointerGetDatum(R))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_array_H */
/*
 * vim: ts=3:sw=3:noet:
 */
