/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.HashMap;
import java.util.Iterator;
import sun.jvm.hotspot.HotSpotTypeDataBase;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.InstanceConstructor;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class VirtualBaseConstructor<T>
extends InstanceConstructor {
    private TypeDataBase db;
    private HashMap map;
    private Type baseType;
    private Class unknownTypeHandler;

    public VirtualBaseConstructor(TypeDataBase db, Type baseType, String packageName, Class unknownTypeHandler) {
        this.db = (HotSpotTypeDataBase)db;
        this.map = new HashMap();
        this.baseType = baseType;
        this.unknownTypeHandler = unknownTypeHandler;
        Iterator iter = db.getTypes();
        while (iter.hasNext()) {
            Type t;
            Type superType;
            for (superType = t = (Type)iter.next(); superType != null && superType != baseType; superType = superType.getSuperclass()) {
            }
            if (superType != baseType) continue;
            superType = t;
            Class<?> c = null;
            while (c == null && superType != null) {
                try {
                    c = Class.forName(packageName + "." + superType.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (c != null) continue;
                superType = superType.getSuperclass();
            }
            if (c == null) {
                c = unknownTypeHandler;
            }
            this.map.put(t.getName(), c);
        }
    }

    public VMObject instantiateWrapperFor(Address addr) throws WrongTypeException {
        if (addr == null) {
            return null;
        }
        Type type = this.db.findDynamicTypeForAddress(addr, this.baseType);
        if (type != null) {
            return (VMObject)VMObjectFactory.newObject((Class)this.map.get(type.getName()), addr);
        }
        if (this.unknownTypeHandler != null) {
            return (VMObject)VMObjectFactory.newObject(this.unknownTypeHandler, addr);
        }
        throw this.newWrongTypeException(addr);
    }
}

