/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeJmp;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeJsrW
extends BytecodeJmp {
    BytecodeJsrW(Method method, int bci) {
        super(method, bci);
    }

    @Override
    public int getTargetBCI() {
        return this.bci() + this.javaSignedWordAt(1);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check jsr_w");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 201;
    }

    public static BytecodeJsrW at(Method method, int bci) {
        BytecodeJsrW b = new BytecodeJsrW(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeJsrW atCheck(Method method, int bci) {
        BytecodeJsrW b = new BytecodeJsrW(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeJsrW at(BytecodeStream bcs) {
        return new BytecodeJsrW(bcs.method(), bcs.bci());
    }
}

