/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.TrimSpacesOption;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.ELFunctionMapper;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.NewlineReductionServletWriter;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TextOptimizer;
import org.apache.jasper.compiler.Validator;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.scan.JarFactory;

public abstract class Compiler {
    private final Log log = LogFactory.getLog(Compiler.class);
    protected JspCompilationContext ctxt;
    protected ErrorDispatcher errDispatcher;
    protected PageInfo pageInfo;
    protected JspServletWrapper jsw;
    protected TagFileProcessor tfp;
    protected Options options;
    protected Node.Nodes pageNodes;

    public void init(JspCompilationContext jspCompilationContext, JspServletWrapper jspServletWrapper) {
        this.jsw = jspServletWrapper;
        this.ctxt = jspCompilationContext;
        this.options = jspCompilationContext.getOptions();
    }

    public SmapStratum getSmap(String string) {
        Map<String, SmapStratum> map = this.ctxt.getRuntimeContext().getSmaps();
        SmapStratum smapStratum = map.get(string);
        if (smapStratum == null && !this.options.isSmapSuppressed() && (smapStratum = SmapUtil.loadSmap(string, this.ctxt.getJspLoader())) != null) {
            map.put(string, smapStratum);
        }
        return smapStratum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, SmapStratum> generateJava() throws Exception {
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (this.log.isDebugEnabled()) {
            l4 = System.currentTimeMillis();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher), this.ctxt);
        JspConfig jspConfig = this.options.getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        if (jspProperty.isELIgnored() != null) {
            this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        }
        if (jspProperty.getErrorOnELNotFound() != null) {
            this.pageInfo.setErrorOnELNotFound(JspUtil.booleanValue(jspProperty.getErrorOnELNotFound()));
        }
        if (jspProperty.isScriptingInvalid() != null) {
            this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        }
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        if (jspProperty.isDeferedSyntaxAllowedAsLiteral() != null) {
            this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.isDeferedSyntaxAllowedAsLiteral()));
        }
        if (jspProperty.isTrimDirectiveWhitespaces() != null) {
            this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.isTrimDirectiveWhitespaces()));
        }
        if (jspProperty.getBuffer() != null) {
            this.pageInfo.setBufferValue(jspProperty.getBuffer(), null, this.errDispatcher);
        }
        if (jspProperty.isErrorOnUndeclaredNamespace() != null) {
            this.pageInfo.setErrorOnUndeclaredNamespace(JspUtil.booleanValue(jspProperty.isErrorOnUndeclaredNamespace()));
        }
        if (this.ctxt.isTagFile()) {
            try {
                double d = Double.parseDouble(this.ctxt.getTagInfo().getTagLibrary().getRequiredVersion());
                if (d < 2.0) {
                    this.pageInfo.setIsELIgnored("true", null, this.errDispatcher, true);
                }
                if (d < 2.1) {
                    this.pageInfo.setDeferredSyntaxAllowedAsLiteral("true", null, this.errDispatcher, true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errDispatcher.jspError(numberFormatException);
            }
        }
        this.ctxt.checkOutputDir();
        String string = this.ctxt.getServletJavaFileName();
        try {
            object = new ParserController(this.ctxt, this);
            Node.Nodes nodes = ((ParserController)object).parseDirectives(this.ctxt.getJspFile());
            Validator.validateDirectives(this, nodes);
            this.pageNodes = ((ParserController)object).parse(this.ctxt.getJspFile());
            if (this.pageInfo.getContentType() == null && jspProperty.getDefaultContentType() != null) {
                this.pageInfo.setContentType(jspProperty.getDefaultContentType());
            }
            if (this.ctxt.isPrototypeMode()) {
                try (ServletWriter servletWriter = this.setupContextWriter(string);){
                    Generator.generate(servletWriter, this, this.pageNodes);
                    Map<String, SmapStratum> map = null;
                    return map;
                }
            }
            Validator.validateExDirectives(this, this.pageNodes);
            if (this.log.isDebugEnabled()) {
                l3 = System.currentTimeMillis();
            }
            Collector.collect(this, this.pageNodes);
            this.tfp = new TagFileProcessor();
            this.tfp.loadTagFiles(this, this.pageNodes);
            if (this.log.isDebugEnabled()) {
                l2 = System.currentTimeMillis();
            }
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this.pageNodes);
            try (ServletWriter servletWriter = this.setupContextWriter(string);){
                Generator.generate(servletWriter, this, this.pageNodes);
            }
            this.ctxt.setWriter(null);
            if (this.log.isTraceEnabled()) {
                l = System.currentTimeMillis();
                this.log.trace((Object)("Generated " + string + " total=" + (l - l4) + " generate=" + (l - l2) + " validate=" + (l3 - l4)));
            }
        }
        catch (RuntimeException runtimeException) {
            File file = new File(string);
            if (!file.exists()) throw runtimeException;
            if (file.delete()) throw runtimeException;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.compiler.javafile.delete.fail", file.getAbsolutePath()));
            throw runtimeException;
        }
        object = null;
        if (!this.options.isSmapSuppressed()) {
            object = SmapUtil.generateSmap(this.ctxt, this.pageNodes);
            this.ctxt.getRuntimeContext().getSmaps().putAll((Map<String, SmapStratum>)object);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
        return object;
    }

    private ServletWriter setupContextWriter(String string) throws FileNotFoundException, JasperException {
        String string2 = this.ctxt.getOptions().getJavaEncoding();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", string2);
        }
        ServletWriter servletWriter = this.ctxt.getOptions().getTrimSpaces().equals((Object)TrimSpacesOption.EXTENDED) ? new NewlineReductionServletWriter(new PrintWriter(outputStreamWriter)) : new ServletWriter(new PrintWriter(outputStreamWriter));
        this.ctxt.setWriter(servletWriter);
        return servletWriter;
    }

    protected abstract void generateClass(Map<String, SmapStratum> var1) throws FileNotFoundException, JasperException, Exception;

    public void compile() throws FileNotFoundException, JasperException, Exception {
        this.compile(true);
    }

    public void compile(boolean bl) throws FileNotFoundException, JasperException, Exception {
        this.compile(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(boolean bl, boolean bl2) throws FileNotFoundException, JasperException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher(bl2);
        }
        try {
            Long l = this.ctxt.getLastModified(this.ctxt.getJspFile());
            Map<String, SmapStratum> map = this.generateJava();
            File file = new File(this.ctxt.getServletJavaFileName());
            if (!file.setLastModified(l)) {
                throw new JasperException(Localizer.getMessage("jsp.error.setLastModified", file));
            }
            if (bl) {
                this.generateClass(map);
                File file2 = new File(this.ctxt.getClassFileName());
                if (file2.exists()) {
                    if (!file2.setLastModified(l)) {
                        throw new JasperException(Localizer.getMessage("jsp.error.setLastModified", file2));
                    }
                    if (this.jsw != null) {
                        this.jsw.setServletClassLastModifiedTime(l);
                    }
                }
            }
        }
        finally {
            if (this.tfp != null && this.ctxt.isPrototypeMode()) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() != null) {
                this.ctxt.getWriter().close();
                this.ctxt.setWriter(null);
            }
        }
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean bl) {
        Long l;
        File file;
        if (this.jsw != null && this.ctxt.getOptions().getModificationTestInterval() > 0) {
            if (this.jsw.getLastModificationTest() + (long)(this.ctxt.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.jsw.setLastModificationTest(System.currentTimeMillis());
        }
        if (!(file = bl ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName())).exists()) {
            return true;
        }
        long l2 = file.lastModified();
        if (bl && this.jsw != null) {
            this.jsw.setServletClassLastModifiedTime(l2);
        }
        if ((l = this.ctxt.getLastModified(this.ctxt.getJspFile())) < 0L) {
            return true;
        }
        if (l2 != l) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Compiler: outdated: " + file + " " + l2));
            }
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        Map<String, Long> map = this.jsw.getDependants();
        if (map == null) {
            return false;
        }
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            try {
                String string = entry.getKey();
                long l3 = 0L;
                if (string.startsWith("jar:jar:")) {
                    int n = string.lastIndexOf("!/");
                    String string2 = string.substring(n + 2);
                    try (Jar jar = JarFactory.newInstance((URL)new URI(string.substring(4, n)).toURL());){
                        l3 = jar.getLastModified(string2);
                    }
                } else {
                    URL uRL = string.startsWith("jar:") || string.startsWith("file:") ? new URI(string).toURL() : this.ctxt.getResource(entry.getKey());
                    if (uRL == null) {
                        return true;
                    }
                    URLConnection uRLConnection = uRL.openConnection();
                    l3 = uRLConnection instanceof JarURLConnection ? ((JarURLConnection)uRLConnection).getJarEntry().getTime() : uRLConnection.getLastModified();
                    uRLConnection.getInputStream().close();
                }
                if (l3 == entry.getValue()) continue;
                return true;
            }
            catch (Exception exception) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)Localizer.getMessage("jsp.error.compiler.missingResource"), (Throwable)exception);
                }
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        this.removeGeneratedClassFiles();
        try {
            File file = new File(this.ctxt.getServletJavaFileName());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Deleting " + file));
            }
            if (file.exists() && !file.delete()) {
                this.log.warn((Object)Localizer.getMessage("jsp.warning.compiler.javafile.delete.fail", file.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            this.log.warn((Object)Localizer.getMessage("jsp.warning.compiler.classfile.delete.fail.unknown"), (Throwable)exception);
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            File file = new File(this.ctxt.getClassFileName());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Deleting " + file));
            }
            if (file.exists() && !file.delete()) {
                this.log.warn((Object)Localizer.getMessage("jsp.warning.compiler.classfile.delete.fail", file.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            this.log.warn((Object)Localizer.getMessage("jsp.warning.compiler.classfile.delete.fail.unknown"), (Throwable)exception);
        }
    }
}

