/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMethod;
import sun.jvm.hotspot.ci.ciObjectFactory;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.opto.MachCallNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class MachCallJavaNode
extends MachCallNode {
    private static AddressField methodField;
    private static CIntField bciField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("MachCallJavaNode");
        methodField = type.getAddressField("_method");
        bciField = new CIntField(type.getCIntegerField("_bci"), 0L);
    }

    public ciMethod method() {
        return (ciMethod)ciObjectFactory.get(methodField.getValue(this.getAddress()));
    }

    public MachCallJavaNode(Address addr) {
        super(addr);
    }

    @Override
    public void dumpSpec(PrintStream st) {
        ciMethod m = this.method();
        if (m != null) {
            m.printShortName(st);
            st.print(" ");
        }
        super.dumpSpec(st);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MachCallJavaNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

