/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;

public abstract class AbstractDict
extends PyObject {
    public AbstractDict(PyType type) {
        super(type);
    }

    public abstract void clear();

    public abstract AbstractDict copy();

    public abstract PyObject get(PyObject var1);

    public abstract PyObject get(PyObject var1, PyObject var2);

    public abstract ConcurrentMap<? extends Object, PyObject> getMap();

    public abstract boolean has_key(PyObject var1);

    public abstract PyList items();

    public abstract PyObject iteritems();

    public abstract PyObject iterkeys();

    public abstract PyObject itervalues();

    public abstract PyList keys();

    public abstract void merge(PyObject var1, boolean var2);

    public abstract void mergeFromKeys(PyObject var1, PyObject var2, boolean var3);

    public abstract void mergeFromSeq(PyObject var1, boolean var2);

    public abstract PyObject pop(PyObject var1);

    public abstract PyObject pop(PyObject var1, PyObject var2);

    public abstract PyObject popitem();

    public abstract PyObject setdefault(PyObject var1);

    public abstract PyObject setdefault(PyObject var1, PyObject var2);

    public abstract void update(PyObject var1);

    public abstract Collection<? extends Object> values();

    public abstract Set<PyObject> pyKeySet();

    public abstract Set entrySet();

    public PyObject viewkeys() {
        return new PyDictionary.PyDictionaryViewKeys(this);
    }

    public PyObject viewitems() {
        return new PyDictionary.PyDictionaryViewItems(this);
    }

    public PyObject viewvalues() {
        return new PyDictionary.PyDictionaryViewValues(this);
    }

    static Object tojava(Object val) {
        return val == null ? null : ((PyObject)val).__tojava__(Object.class);
    }

    static class ItemsIter<T>
    extends AbstractDictIter<Map.Entry<T, PyObject>> {
        public ItemsIter(Set<Map.Entry<T, PyObject>> items) {
            super(items);
        }

        @Override
        public PyObject __iternext__() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue());
        }
    }

    static class KeysIter<T>
    extends AbstractDictIter<T> {
        public KeysIter(Collection<T> keys) {
            super(keys);
        }
    }

    static class ValuesIter
    extends AbstractDictIter<PyObject> {
        public ValuesIter(Collection<PyObject> values) {
            super(values);
        }
    }

    static abstract class AbstractDictIter<T>
    extends PyIterator {
        protected final Iterator<T> iterator;
        protected final int size;

        public AbstractDictIter(Collection<T> values) {
            this.iterator = values.iterator();
            this.size = values.size();
        }

        protected void check(int size) {
            if (size != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
        }

        @Override
        public PyObject __iternext__() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return (PyObject)this.iterator.next();
        }
    }
}

