/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jsampler.CC;
import org.jsampler.MidiInstrument;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.view.std.JSEditMidiInstrumentDlg;
import org.jsampler.view.std.JSMidiInstrumentTree;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.MidiInstrumentInfo;

public class JSMidiInstrumentsPane
extends JPanel
implements TreeSelectionListener {
    protected final JSMidiInstrumentTree midiInstrumentTree = new JSMidiInstrumentTree();
    protected final Action actionAddInstrument = new AddInstrumentAction();
    protected final Action actionEditInstrument = new EditInstrumentAction();
    protected final Action actionRemove = new RemoveAction();

    public JSMidiInstrumentsPane() {
        this((MidiInstrumentMap)null);
    }

    public JSMidiInstrumentsPane(MidiInstrumentMap midiInstrumentMap) {
        this.setMidiInstrumentMap(midiInstrumentMap);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.midiInstrumentTree);
        this.add(jScrollPane);
        this.midiInstrumentTree.addTreeSelectionListener(this);
    }

    public void setMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        this.midiInstrumentTree.setMidiInstrumentMap(midiInstrumentMap);
        this.actionAddInstrument.setEnabled(midiInstrumentMap != null);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.actionRemove.setEnabled(this.midiInstrumentTree.getSelectionCount() > 0);
        boolean bl = this.midiInstrumentTree.getSelectedInstrument() != null;
        this.actionEditInstrument.setEnabled(bl);
    }

    public void addInstrument() {
    }

    public void editInstrument(MidiInstrument midiInstrument) {
        JSEditMidiInstrumentDlg jSEditMidiInstrumentDlg = new JSEditMidiInstrumentDlg(midiInstrument.getInfo());
        jSEditMidiInstrumentDlg.setVisible(true);
        if (jSEditMidiInstrumentDlg.isCancelled()) {
            return;
        }
        MidiInstrumentInfo midiInstrumentInfo = jSEditMidiInstrumentDlg.getInstrument();
        CC.getSamplerModel().mapBackendMidiInstrument(midiInstrumentInfo.getMapId(), midiInstrumentInfo.getMidiBank(), midiInstrumentInfo.getMidiProgram(), midiInstrumentInfo);
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            String string = StdI18n.i18n.getLabel("JSMidiInstrumentsPane.remove.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSMidiInstrumentsPane.this.midiInstrumentTree.removeSelectedInstrumentOrBank();
        }
    }

    private class EditInstrumentAction
    extends AbstractAction {
        EditInstrumentAction() {
            super(StdI18n.i18n.getLabel("JSMidiInstrumentsPane.editInstrument"));
            String string = StdI18n.i18n.getLabel("JSMidiInstrumentsPane.editInstrument.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSMidiInstrumentsPane.this.editInstrument(JSMidiInstrumentsPane.this.midiInstrumentTree.getSelectedInstrument());
        }
    }

    private class AddInstrumentAction
    extends AbstractAction {
        AddInstrumentAction() {
            super(StdI18n.i18n.getLabel("JSMidiInstrumentsPane.addInstrument"));
            String string = "JSMidiInstrumentsPane.addInstrument.tt";
            this.putValue("ShortDescription", StdI18n.i18n.getLabel(string));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSMidiInstrumentsPane.this.addInstrument();
        }
    }
}

