/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia.basic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.FantasiaTabbedPane;

public class FantasiaTabButton
extends JToggleButton {
    private FantasiaTabbedPane tabbedPane;
    int index = 0;
    private Color color3 = new Color(0x5E5E5E);
    private Color color4 = new Color(0x6E6E6E);
    private Color color5 = new Color(0x7A7A7A);
    private Color color6 = new Color(0x8A8A8A);

    public FantasiaTabButton(FantasiaTabbedPane fantasiaTabbedPane) {
        this(fantasiaTabbedPane, "");
    }

    public FantasiaTabButton(FantasiaTabbedPane fantasiaTabbedPane, String string) {
        super(string);
        this.tabbedPane = fantasiaTabbedPane;
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this.setRolloverEnabled(true);
        this.setForeground(new Color(0xCCCCCC));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public FantasiaTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.isSelected()) {
            this.paintSelectedButton(graphics2D);
        } else {
            this.paintUnselectedButton(graphics2D);
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
    }

    private void paintSelectedButton(Graphics2D graphics2D) {
        double d = this.getSize().getHeight();
        double d2 = this.getSize().getWidth();
        double d3 = 0.0;
        double d4 = this.getModel().isSelected() ? d : d - 3.0;
        double d5 = this.isLastButton() ? d2 : d2 - 1.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, 0.0, d5, d4);
        GradientPaint gradientPaint = new GradientPaint((float)d3, 0.0f, this.color6, (float)d3, (float)d4, this.color5);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(double_);
        this.paintSelectedBorder(graphics2D, d3, 0.0, d5 - 1.0, d - 1.0);
    }

    private void paintUnselectedButton(Graphics2D graphics2D) {
        double d = this.getSize().getHeight();
        double d2 = this.getSize().getWidth();
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = d - 2.0;
        double d6 = this.isLastButton() ? d2 : d2 - 1.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d6, d5);
        Color color = this.getModel().isRollover() ? this.color4 : this.color3;
        Color color2 = this.getModel().isRollover() ? this.color6 : this.color5;
        GradientPaint gradientPaint = new GradientPaint((float)d3, (float)d4, color, (float)d3, (float)d5, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(double_);
        double_ = new Rectangle2D.Double(0.0, d - 2.0, d2, d5);
        graphics2D.setPaint(this.color5);
        graphics2D.fill(double_);
        this.paintUnselectedBorder(graphics2D, d3, d4, d6 - 1.0, d);
    }

    private void paintSelectedBorder(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        FantasiaPainter.paintTopBoldOuterBorder(graphics2D, d + 2.0, d2, d3 - 2.0, d2);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
        FantasiaPainter.paintTopBoldRoundCorners(graphics2D, d, d2, d3, d4);
        graphics2D.setComposite(alphaComposite.derive(0.255f));
        double d5 = this.getIndex() == 0 ? d4 + 1.0 : (d4 -= 1.0);
        Line2D.Double double_ = new Line2D.Double(d, d2 + 2.0, d, d5);
        graphics2D.draw(double_);
        if (this.getIndex() == 0) {
            graphics2D.setComposite(alphaComposite.derive(0.07f));
            double_ = new Line2D.Double(d + 1.0, d2 + 3.0, d + 1.0, d5);
            graphics2D.draw(double_);
        }
        graphics2D.setComposite(alphaComposite.derive(0.4f));
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        d5 = this.getIndex() == this.getTabbedPane().getTabCount() - 1 ? d4 + 1.0 : d4;
        double_ = new Line2D.Double(d3, d2 + 2.0, d3, d5);
        graphics2D.draw(double_);
        if (this.getIndex() == this.getTabbedPane().getTabCount() - 1) {
            graphics2D.setComposite(alphaComposite.derive(0.07f));
            double_ = new Line2D.Double(d3 - 1.0, d2 + 3.0, d3 - 1.0, d5);
            graphics2D.draw(double_);
        }
        if (this.getIndex() != this.getTabbedPane().getTabCount() - 1) {
            graphics2D.setPaint(this.color5);
            graphics2D.setComposite(alphaComposite.derive(1.0f));
            double_ = new Line2D.Double(d3 + 1.0, d4, d3 + 1.0, d4 + 1.0);
            graphics2D.draw(double_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.setComposite(alphaComposite.derive(0.1f));
            double_ = new Line2D.Double(d3, d4, d3, d4);
            graphics2D.draw(double_);
            graphics2D.setComposite(alphaComposite.derive(0.2f));
            double_ = new Line2D.Double(d3 + 1.0, d4, d3 + 1.0, d4);
            graphics2D.draw(double_);
            graphics2D.setComposite(alphaComposite.derive(0.1f));
            double_ = new Line2D.Double(d3 + 1.0, d4 + 1.0, d3 + 1.0, d4 + 1.0);
            graphics2D.draw(double_);
        }
    }

    public boolean isLastButton() {
        return this.getIndex() == this.getTabbedPane().getTabCount() - 1;
    }

    private void paintUnselectedBorder(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setPaint(Color.WHITE);
        Line2D.Double double_ = new Line2D.Double(d + 2.0, d2, d3 - 3.0, d2);
        graphics2D.draw(double_);
        double d5 = this.getSize().getHeight();
        double d6 = this.getIndex() == 0 ? 2.0 : 0.0;
        double d7 = this.isLastButton() ? d3 - 3.0 : d3 + 1.0;
        double_ = new Line2D.Double(d6, d5 - 2.0, d7, d5 - 2.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d, d2 + 1.0, d3 - 2.0, d2 + 1.0);
        graphics2D.draw(double_);
        double_ = new Line2D.Double(d6, d5 - 1.0, d7, d5 - 1.0);
        graphics2D.draw(double_);
        this.paintRoundCorners(graphics2D, d, d2, d3, d4);
        if (this.getIndex() == 0) {
            FantasiaPainter.paintTopLeftBoldRoundCorner(graphics2D, 0.0, d5 - 2.0);
        } else if (this.isLastButton()) {
            FantasiaPainter.paintTopRightBoldRoundCorner(graphics2D, d4 - 2.0, d3);
        }
        graphics2D.setComposite(alphaComposite.derive(0.255f));
        double_ = new Line2D.Double(d, d2 + 2.0, d, d4 -= 3.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.3f));
        graphics2D.setPaint(Color.BLACK);
        double_ = new Line2D.Double(d, d4, d3, d4);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d3, d2 + 2.0, d3, d4);
        graphics2D.draw(double_);
    }

    private void paintRoundCorners(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.WHITE);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.1f);
        graphics2D.setComposite(alphaComposite);
        Line2D.Double double_ = new Line2D.Double(d, d2, d, d2);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.setComposite(alphaComposite.derive(0.37f));
        double_ = new Line2D.Double(d + 1.0, d2, d + 1.0, d2);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.15f));
        double_ = new Line2D.Double(d, d2 + 1.0, d, d2 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d + 1.0, d2 + 1.0, d + 1.0, d2 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.1f));
        double_ = new Line2D.Double(d, d2 + 2.0, d + 1.0, d2 + 2.0);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.setComposite(alphaComposite.derive(0.3f));
        double_ = new Line2D.Double(d3 - 2.0, d2, d3 - 2.0, d2);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d3 - 1.0, d2, d3 - 1.0, d2);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.1f));
        double_ = new Line2D.Double(d3, d2, d3, d2);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.WHITE);
        double_ = new Line2D.Double(d3 - 1.0, d2 + 1.0, d3 - 1.0, d2 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.05f));
        double_ = new Line2D.Double(d3, d2 + 1.0, d3, d2 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setPaint(paint);
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicButtonUI());
    }
}

