/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.jsampler.CC;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.FantasiaUtils;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ToolbarButton;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.FantasiaSubPanel;
import org.jsampler.view.fantasia.basic.FantasiaTaskPane;
import org.jsampler.view.std.JSManageMidiMapsPane;
import org.jsampler.view.std.JSMidiInstrumentsPane;
import org.jsampler.view.std.JSNewMidiInstrumentWizard;

public class MidiInstrumentsPane
extends JPanel {
    private final JPanel taskPaneContainer = new JPanel();
    private final FantasiaTaskPane mapsTaskPane = new FantasiaTaskPane();
    private ManageMapsPane manageMapsPane = new ManageMapsPane();
    private final InstrumentsPane instrumentsPane = new InstrumentsPane();
    private final JComboBox cbMaps = new JComboBox();
    private final Handler eventHandler = new Handler();

    public MidiInstrumentsPane() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.mapsTaskPane.setTitle(FantasiaI18n.i18n.getLabel("MidiInstrumentsPane.mapsTaskPane"));
        FantasiaSubPanel fantasiaSubPanel = new FantasiaSubPanel(false, true, false);
        fantasiaSubPanel.add(this.manageMapsPane);
        this.mapsTaskPane.add(fantasiaSubPanel);
        this.mapsTaskPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
        boolean bl = FantasiaPrefs.preferences().getBoolProperty("MidiInstrumentsPane.mapsTaskPane.expanded");
        this.mapsTaskPane.setCollapsed(!bl);
        FantasiaPrefs.preferences().addPropertyChangeListener("animated", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MidiInstrumentsPane.this.mapsTaskPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
            }
        });
        this.taskPaneContainer.setOpaque(false);
        this.taskPaneContainer.setLayout(new BorderLayout());
        this.taskPaneContainer.add(this.mapsTaskPane);
        this.taskPaneContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.taskPaneContainer, "North");
        this.add(new MapsPane());
        this.cbMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiInstrumentsPane.this.mapChanged();
            }
        });
        for (MidiInstrumentMap midiInstrumentMap : CC.getSamplerModel().getMidiInstrumentMaps()) {
            this.cbMaps.addItem(midiInstrumentMap);
        }
        CC.getSamplerModel().addMidiInstrumentMapListListener(this.getHandler());
        this.cbMaps.setEnabled(this.cbMaps.getItemCount() != 0);
    }

    private void mapChanged() {
        MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)this.cbMaps.getSelectedItem();
        this.instrumentsPane.setMidiInstrumentMap(midiInstrumentMap);
    }

    public void savePreferences() {
        boolean bl = !this.mapsTaskPane.isCollapsed();
        FantasiaPrefs.preferences().setBoolProperty("MidiInstrumentsPane.mapsTaskPane.expanded", bl);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements ListListener<MidiInstrumentMap> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
            if (MidiInstrumentsPane.this.cbMaps.getItemCount() == 0) {
                MidiInstrumentsPane.this.cbMaps.setEnabled(true);
            }
            MidiInstrumentsPane.this.cbMaps.addItem(listEvent.getEntry());
        }

        @Override
        public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
            MidiInstrumentsPane.this.cbMaps.removeItem(listEvent.getEntry());
            if (MidiInstrumentsPane.this.cbMaps.getItemCount() == 0) {
                MidiInstrumentsPane.this.cbMaps.setEnabled(false);
            }
        }
    }

    class InstrumentsPane
    extends JSMidiInstrumentsPane {
        InstrumentsPane() {
            this.actionAddInstrument.putValue("SmallIcon", Res.iconNew16);
            this.actionEditInstrument.putValue("SmallIcon", Res.iconEdit16);
            this.actionRemove.putValue("SmallIcon", Res.iconDelete16);
            this.removeAll();
            JToolBar jToolBar = FantasiaUtils.createSubToolBar();
            jToolBar.add(new ToolbarButton(this.actionAddInstrument));
            jToolBar.add(new ToolbarButton(this.actionEditInstrument));
            jToolBar.add(new ToolbarButton(this.actionRemove));
            this.add((Component)jToolBar, "North");
            JScrollPane jScrollPane = new JScrollPane(this.midiInstrumentTree);
            Dimension dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
            jScrollPane.setPreferredSize(dimension);
            JPanel jPanel = FantasiaUtils.createBottomSubPane();
            jPanel.add(jScrollPane);
            this.add(jPanel);
        }

        @Override
        public void addInstrument() {
            MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)MidiInstrumentsPane.this.cbMaps.getSelectedItem();
            JSNewMidiInstrumentWizard jSNewMidiInstrumentWizard = new JSNewMidiInstrumentWizard(Res.iconBrowse16, midiInstrumentMap);
            jSNewMidiInstrumentWizard.getWizardDialog().setResizable(false);
            jSNewMidiInstrumentWizard.putClientProperty("Wizard.backButtonIcon", Res.iconBack16);
            jSNewMidiInstrumentWizard.putClientProperty("Wizard.nextButtonIcon", Res.iconNext16);
            Color color = new Color(0x626262);
            jSNewMidiInstrumentWizard.putClientProperty("Wizard.leftPaneBackgroundColor", color);
            if (FantasiaPrefs.preferences().getBoolProperty("NewMidiInstrumentWizard.skip1")) {
                if (jSNewMidiInstrumentWizard.getModel().getCurrentPage() == null) {
                    jSNewMidiInstrumentWizard.getModel().next();
                }
                jSNewMidiInstrumentWizard.getModel().next();
            }
            jSNewMidiInstrumentWizard.showWizard();
        }
    }

    class MapsPane
    extends JPanel {
        MapsPane() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            FantasiaSubPanel fantasiaSubPanel = new FantasiaSubPanel(true, false);
            fantasiaSubPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            fantasiaSubPanel.setLayout(new BoxLayout(fantasiaSubPanel, 1));
            FantasiaPanel fantasiaPanel = new FantasiaPanel();
            fantasiaPanel.setOpaque(false);
            fantasiaPanel.setLayout(new BoxLayout(fantasiaPanel, 0));
            fantasiaPanel.add(MidiInstrumentsPane.this.cbMaps);
            fantasiaPanel.setBorder(BorderFactory.createEmptyBorder(3, 1, 5, 1));
            fantasiaSubPanel.add(fantasiaPanel);
            FantasiaSubPanel fantasiaSubPanel2 = new FantasiaSubPanel(false, true, false);
            fantasiaSubPanel2.add(MidiInstrumentsPane.this.instrumentsPane);
            fantasiaSubPanel.add(fantasiaSubPanel2);
            this.add(fantasiaSubPanel);
        }
    }

    class ManageMapsPane
    extends JSManageMidiMapsPane {
        ManageMapsPane() {
            this.actionAddMap.putValue("SmallIcon", Res.iconNew16);
            this.actionEditMap.putValue("SmallIcon", Res.iconEdit16);
            this.actionRemoveMap.putValue("SmallIcon", Res.iconDelete16);
            this.removeAll();
            JToolBar jToolBar = FantasiaUtils.createSubToolBar();
            jToolBar.add(new ToolbarButton(this.actionAddMap));
            jToolBar.add(new ToolbarButton(this.actionEditMap));
            jToolBar.add(new ToolbarButton(this.actionRemoveMap));
            this.add((Component)jToolBar, "North");
            JScrollPane jScrollPane = new JScrollPane(this.midiMapTable);
            jScrollPane.setPreferredSize(new Dimension(120, 130));
            JPanel jPanel = FantasiaUtils.createBottomSubPane();
            jPanel.add(jScrollPane);
            this.add(jPanel);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            double d = this.getSize().getHeight();
            double d2 = this.getSize().getWidth();
            FantasiaPainter.paintGradient((Graphics2D)graphics, 0.0, 0.0, d2 - 1.0, d - 1.0);
            FantasiaPainter.RoundCorners roundCorners = new FantasiaPainter.RoundCorners(true, false, false, true);
            FantasiaPainter.paintOuterBorder((Graphics2D)graphics, 0.0, 0.0, d2 - 1.0, d - 1.0, roundCorners);
        }
    }
}

