/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.sf.juife.DefaultNavigationHistoryModel;
import net.sf.juife.NavigationHistoryModel;
import net.sf.juife.NavigationPage;
import net.sf.juife.plaf.NavigationPaneUI;

public class NavigationPane
extends JPanel {
    private static final String uiClassID = "NavigationPaneUI";
    private NavigationHistoryModel model;
    private NavigationPage[] pages = new NavigationPage[0];
    private Color titleBackground;

    public NavigationPane() {
        this(new DefaultNavigationHistoryModel());
    }

    public NavigationPane(NavigationHistoryModel model) {
        this.setModel(model);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public NavigationPaneUI getUI() {
        return (NavigationPaneUI)this.ui;
    }

    public void setUI(NavigationPaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((NavigationPaneUI)UIManager.getUI(this));
    }

    public void setPages(NavigationPage[] pages) {
        if (pages == null) {
            throw new IllegalArgumentException("pages must be non null");
        }
        NavigationPage[] oldPages = this.pages;
        this.pages = pages;
        this.firePropertyChange("pages", oldPages, this.pages);
    }

    public NavigationPage[] getPages() {
        return this.pages;
    }

    public NavigationHistoryModel<NavigationPage> getModel() {
        return this.model;
    }

    public void setModel(NavigationHistoryModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        NavigationHistoryModel oldModel = this.model;
        this.model = model;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public NavigationPage getCurrentPage() {
        return this.getModel().getCurrentPage();
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleBackground(Color c) {
        Color oldColor = this.titleBackground;
        this.titleBackground = c;
        this.firePropertyChange("titleBackground", oldColor, this.titleBackground);
    }

    public void setTitlebarVisiblie(boolean b) {
        this.getUI().setTitlebarVisiblie(b);
    }

    static {
        UIManager.put(uiClassID, "net.sf.juife.plaf.basic.BasicNavigationPaneUI");
    }
}

