/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.std.JSFrame;
import org.jsampler.view.std.StdI18n;

public class JSBackendLogFrame
extends JSFrame {
    private final BackendLogPane backendLogPane = new BackendLogPane();
    private final Timer timer;

    public JSBackendLogFrame() {
        super(StdI18n.i18n.getLabel("JSBackendLogFrame.title"), "JSBackendLogFrame");
        ImageIcon imageIcon = CC.getViewConfig().getBasicIconSet().getApplicationIcon();
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        this.add(new JScrollPane(this.backendLogPane));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSBackendLogFrame.this.processInput();
            }
        };
        this.timer = new Timer(500, actionListener);
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInput() {
        Process process = CC.getBackendProcess();
        if (process == null) {
            return;
        }
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            while (process.getInputStream().available() > 0) {
                stringBuffer.append((char)process.getInputStream().read());
            }
            String string = stringBuffer.toString();
            if (string.length() > 0) {
                this.backendLogPane.appendText(string);
            }
            if ((n = string.indexOf("Starting LSCP network server")) != -1 && string.indexOf("OK", n + 27) != -1) {
                Object object = CC.getBackendMonitor();
                synchronized (object) {
                    CC.getBackendMonitor().notifyAll();
                }
            }
            stringBuffer = new StringBuffer();
            while (process.getErrorStream().available() > 0) {
                stringBuffer.append((char)process.getErrorStream().read());
            }
            string = stringBuffer.toString();
            if (string.length() > 0) {
                this.backendLogPane.appendError(string);
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    public static class BackendLogPane
    extends JTextPane {
        private final String STYLE_ROOT = "root";
        private final String STYLE_REGULAR = "regular";
        private final String STYLE_ERROR = "errorMessage";
        private final String STYLE_ERROR_0 = "errorMessage0";

        public BackendLogPane() {
            Style style = StyleContext.getDefaultStyleContext().getStyle("default");
            StyledDocument styledDocument = this.getStyledDocument();
            Style style2 = styledDocument.addStyle("root", style);
            Style style3 = styledDocument.addStyle("regular", style2);
            Style style4 = styledDocument.addStyle("errorMessage0", style3);
            StyleConstants.setForeground(style4, Color.RED);
            styledDocument.addStyle("errorMessage", style4);
            this.setEditable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public void appendText(String string) {
            StyledDocument styledDocument = this.getStyledDocument();
            try {
                styledDocument.insertString(styledDocument.getLength(), string, styledDocument.getStyle("regular"));
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            }
        }

        public void appendError(String string) {
            StyledDocument styledDocument = this.getStyledDocument();
            try {
                styledDocument.insertString(styledDocument.getLength(), string, styledDocument.getStyle("errorMessage"));
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            }
        }
    }
}

