/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class PixmapPane
extends JPanel {
    private ImageIcon pixmap;

    public PixmapPane(ImageIcon pixmap) {
        this(pixmap, new FlowLayout());
    }

    public PixmapPane(ImageIcon pixmap, LayoutManager layout) {
        super(layout);
        this.setOpaque(false);
        this.pixmap = pixmap;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.pixmap.paintIcon(this, g, 0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.pixmap.getIconWidth(), this.pixmap.getIconHeight());
    }

    public ImageIcon getPixmap() {
        return this.pixmap;
    }

    public void setPixmap(ImageIcon pixmap) {
        this.pixmap = pixmap;
        this.revalidate();
        this.repaint();
    }
}

