/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.task.Midi;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.MidiInstrumentEntry;
import org.linuxsampler.lscp.MidiInstrumentInfo;

public class JSAddMidiInstrumentDlg
extends OkCancelDialog {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.lName"));
    private final JLabel lBank = new JLabel(StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.lBank"));
    private final JLabel lProgram = new JLabel(StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.lProgram"));
    private final JLabel lVolume = new JLabel(StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.lVolume"));
    private final JLabel lLoadMode = new JLabel(StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.lLoadMode"));
    private final JTextField tfName = new JTextField();
    private JSpinner spinnerBank;
    private final JComboBox cbProgram = new JComboBox();
    private final JSlider slVolume = new JSlider(0, 100, 100);
    private final JComboBox cbLoadMode = new JComboBox();
    private MidiInstrumentMap map;
    private Instrument instr;
    private int mbBase;
    private int mpBase;
    private final Handler eventHandler = new Handler();

    public JSAddMidiInstrumentDlg(Frame frame, MidiInstrumentMap midiInstrumentMap, Instrument instrument) {
        super(frame, StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.title"));
        this.initAddMidiInstrumentDlg(midiInstrumentMap, instrument);
    }

    public JSAddMidiInstrumentDlg(Dialog dialog, MidiInstrumentMap midiInstrumentMap, Instrument instrument) {
        super(dialog, StdI18n.i18n.getLabel("JSAddMidiInstrumentDlg.title"));
        this.initAddMidiInstrumentDlg(midiInstrumentMap, instrument);
    }

    private void initAddMidiInstrumentDlg(final MidiInstrumentMap midiInstrumentMap, Instrument instrument) {
        int n;
        this.mbBase = CC.getViewConfig().getFirstMidiBankNumber();
        this.mpBase = CC.getViewConfig().getFirstMidiProgramNumber();
        this.spinnerBank = new JSpinner(new SpinnerNumberModel(this.mbBase, this.mbBase, 16383 + this.mbBase, 1));
        this.map = midiInstrumentMap;
        this.instr = instrument;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        jPanel.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lBank, gridBagConstraints);
        jPanel.add(this.lBank);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lProgram, gridBagConstraints);
        jPanel.add(this.lProgram);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lLoadMode, gridBagConstraints);
        jPanel.add(this.lLoadMode);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 24, 3);
        gridBagLayout.setConstraints(this.lVolume, gridBagConstraints);
        jPanel.add(this.lVolume);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfName, gridBagConstraints);
        jPanel.add(this.tfName);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.spinnerBank, gridBagConstraints);
        jPanel.add(this.spinnerBank);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.cbProgram, gridBagConstraints);
        jPanel.add(this.cbProgram);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.cbLoadMode, gridBagConstraints);
        jPanel.add(this.cbLoadMode);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 24, 3);
        gridBagLayout.setConstraints(this.slVolume, gridBagConstraints);
        jPanel.add(this.slVolume);
        this.setMainPane(jPanel);
        this.setResizable(true);
        this.setMinimumSize(this.getPreferredSize());
        for (n = 0; n < 128; ++n) {
            this.cbProgram.addItem(new Integer(n + this.mpBase));
        }
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.DEFAULT);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND_HOLD);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.PERSISTENT);
        n = this.preferences().getIntProperty("std.midiInstrument.loadMode", 0);
        if (this.cbLoadMode.getItemCount() > n) {
            this.cbLoadMode.setSelectedIndex(n);
        }
        this.cbLoadMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JSAddMidiInstrumentDlg.this.cbLoadMode.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                JSAddMidiInstrumentDlg.this.preferences().setIntProperty("std.midiInstrument.loadMode", n);
            }
        });
        this.tfName.getDocument().addDocumentListener(this.getHandler());
        this.setInstrumentName(instrument.getName());
        CC.scheduleInTaskQueue(new Runnable(){

            @Override
            public void run() {
                JSAddMidiInstrumentDlg.this.setMidiInstrumentEntry(midiInstrumentMap.getAvailableEntry());
            }
        });
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public void setMidiInstrumentEntry(MidiInstrumentEntry midiInstrumentEntry) {
        if (midiInstrumentEntry == null) {
            return;
        }
        this.setMidiBank(midiInstrumentEntry.getMidiBank());
        this.setMidiProgram(midiInstrumentEntry.getMidiProgram());
    }

    public int getMidiBank() {
        return Integer.parseInt(this.spinnerBank.getValue().toString()) - this.mbBase;
    }

    public void setMidiBank(int n) {
        this.spinnerBank.setValue(this.mbBase + n);
    }

    public int getMidiProgram() {
        return this.cbProgram.getSelectedIndex();
    }

    public void setMidiProgram(int n) {
        this.cbProgram.setSelectedIndex(n);
    }

    public String getInstrumentName() {
        return this.tfName.getText();
    }

    public void setInstrumentName(String string) {
        this.tfName.setText(string);
    }

    public float getVolume() {
        float f = this.slVolume.getValue();
        return f /= 100.0f;
    }

    public MidiInstrumentInfo.LoadMode getLoadMode() {
        return (MidiInstrumentInfo.LoadMode)((Object)this.cbLoadMode.getSelectedItem());
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.btnOk.setEnabled(false);
        this.preferences().setIntProperty("lastUsedMidiBank", this.getMidiBank());
        this.preferences().setIntProperty("lastUsedMidiProgram", this.getMidiProgram());
        MidiInstrumentInfo midiInstrumentInfo = new MidiInstrumentInfo();
        midiInstrumentInfo.setName(this.getInstrumentName());
        midiInstrumentInfo.setFilePath(this.instr.getFilePath());
        midiInstrumentInfo.setInstrumentIndex(this.instr.getInstrumentIndex());
        midiInstrumentInfo.setEngine(this.instr.getEngine());
        midiInstrumentInfo.setVolume(this.getVolume());
        midiInstrumentInfo.setLoadMode(this.getLoadMode());
        int n = this.map.getMapId();
        int n2 = this.getMidiBank();
        int n3 = this.getMidiProgram();
        final Midi.MapInstrument mapInstrument = new Midi.MapInstrument(n, n2, n3, midiInstrumentInfo);
        mapInstrument.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                JSAddMidiInstrumentDlg.this.btnOk.setEnabled(true);
                if (mapInstrument.doneWithErrors()) {
                    return;
                }
                JSAddMidiInstrumentDlg.this.setCancelled(false);
                JSAddMidiInstrumentDlg.this.setVisible(false);
            }
        });
        CC.getTaskQueue().add(mapInstrument);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    private void updateState() {
        boolean bl = this.tfName.getText().length() > 0;
        bl = bl && this.cbProgram.getSelectedItem() != null;
        this.btnOk.setEnabled(bl);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSAddMidiInstrumentDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSAddMidiInstrumentDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSAddMidiInstrumentDlg.this.updateState();
        }
    }
}

