/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.wizard;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.juife.JuifeI18n;
import net.sf.juife.wizard.WizardPage;

public class ProgressPage
extends WizardPage {
    private final JPanel progressPane = new JPanel();
    private final JProgressBar progress = new JProgressBar();
    private final JButton btnStop = new JButton(JuifeI18n.i18n.getButtonLabel("stop"));
    private JPanel mainInstructionsPane = null;
    private JLabel lMainInstructions = null;
    private JPanel additionalInstructionsPane = new JPanel();
    private JLabel lAdditionalInstructions = new JLabel();

    public ProgressPage() {
        this((String)null);
    }

    public ProgressPage(String subtitle) {
        this(subtitle, null);
    }

    public ProgressPage(String subtitle, String description) {
        this(subtitle, description, WizardPage.OptionalButtons.NONE);
    }

    public ProgressPage(String subtitle, String description, WizardPage.OptionalButtons optionalButtons) {
        super(subtitle, description, WizardPage.Type.PROGRESS_PAGE, optionalButtons);
        this.initProgressPage();
    }

    private void initProgressPage() {
        this.initInstructionPanes();
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(0, 24)));
        this.mainInstructionsPane.setAlignmentX(0.0f);
        this.add(this.mainInstructionsPane);
        this.progressPane.setLayout(new BoxLayout(this.progressPane, 0));
        this.progressPane.add(this.progress);
        this.progressPane.add(Box.createRigidArea(new Dimension(11, 0)));
        this.progressPane.add(this.btnStop);
        this.progressPane.setAlignmentX(0.0f);
        this.add(this.progressPane);
        this.additionalInstructionsPane.setAlignmentX(0.0f);
        this.add(this.additionalInstructionsPane);
        this.add(Box.createGlue());
    }

    private void initInstructionPanes() {
        this.mainInstructionsPane = new JPanel();
        this.mainInstructionsPane.setOpaque(false);
        this.mainInstructionsPane.setAlignmentX(0.0f);
        this.mainInstructionsPane.setLayout(new BoxLayout(this.mainInstructionsPane, 1));
        this.lMainInstructions = new JLabel();
        this.lMainInstructions.setOpaque(false);
        this.lMainInstructions.setFont(this.lMainInstructions.getFont().deriveFont(0));
        this.lMainInstructions.setAlignmentX(0.0f);
        this.mainInstructionsPane.add(Box.createRigidArea(new Dimension(0, 12)));
        this.mainInstructionsPane.add(this.lMainInstructions);
        this.mainInstructionsPane.setVisible(false);
        this.lAdditionalInstructions.setAlignmentX(0.0f);
        this.lAdditionalInstructions.setFont(this.lAdditionalInstructions.getFont().deriveFont(0));
        this.lAdditionalInstructions.setOpaque(false);
        this.additionalInstructionsPane.setLayout(new BoxLayout(this.additionalInstructionsPane, 1));
        this.additionalInstructionsPane.add(this.lAdditionalInstructions);
        this.additionalInstructionsPane.setVisible(false);
    }

    public JProgressBar getProgressBar() {
        return this.progress;
    }

    public void setAdditionalInstructions(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.additionalInstructionsPane.setVisible(true);
        this.lAdditionalInstructions.setText(text);
    }

    public void setMainInstructions(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.lMainInstructions.setText(text);
        this.mainInstructionsPane.setVisible(true);
        this.mainInstructionsPane.setMaximumSize(new Dimension(30000, this.mainInstructionsPane.getPreferredSize().height));
    }
}

