/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public final class ServerInfo
implements Parseable {
    private String desc = null;
    private String ver = null;
    private String protoVer = null;
    private boolean instrumentsDbSupport = false;

    public ServerInfo(String[] stringArray) {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public String getDescription() {
        return this.desc;
    }

    public String getVersion() {
        return this.ver;
    }

    public String getProtocolVersion() {
        return this.protoVer;
    }

    public boolean hasInstrumentsDbSupport() {
        return this.instrumentsDbSupport;
    }

    @Override
    public boolean parse(String string) {
        if (string.startsWith("DESCRIPTION: ")) {
            this.desc = string.substring("DESCRIPTION: ".length());
            this.desc = Parser.toNonEscapedString(this.desc);
        } else if (string.startsWith("VERSION: ")) {
            this.ver = string.substring("VERSION: ".length());
        } else if (string.startsWith("PROTOCOL_VERSION: ")) {
            this.protoVer = string.substring("PROTOCOL_VERSION: ".length());
        } else if (string.startsWith("INSTRUMENTS_DB_SUPPORT: ")) {
            if ((string = string.substring("INSTRUMENTS_DB_SUPPORT: ".length())).equalsIgnoreCase("yes")) {
                this.instrumentsDbSupport = true;
            }
        } else {
            return false;
        }
        return true;
    }
}

