/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.layout;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.UIThreadFadeTrackerAdapter;
import org.jvnet.lafwidget.layout.TransitionBorder;
import org.jvnet.lafwidget.layout.TransitionLayoutEvent;
import org.jvnet.lafwidget.layout.TransitionLayoutListener;

public class TransitionLayout
implements LayoutManager {
    protected LayoutManager delegate;
    protected List eventListeners;
    public static final String ALPHA = "lafwidgets.layout.alpha";
    public static final String OWN_ALPHA = "lafwidgets.layout.ownAlpha";
    public static final String ORIGINAL_OPACITY = "lafwidgets.layout.originalOpacity";
    public static final String SHOWING = "lafwidgets.layout.showing";
    public static final String LIMBO = "lafwidgets.layout.limbo";
    public static final String BOUNDS = "lafwidgets.layout.bounds";
    protected Container container;
    protected boolean doImmediateRepaint;
    public static final FadeKind COMPONENT_BOUNDS = new FadeKind("lafwidgets.layout.componentBounds");
    public static final FadeKind COMPONENT_FADE = new FadeKind("lafwidgets.layout.componentFade");
    protected boolean hasFades;
    protected boolean hasPendingLayoutRequests;
    protected int pendingAnimationCount;

    public TransitionLayout(Container container, LayoutManager delegate, boolean hasFades) {
        this.container = container;
        this.delegate = delegate;
        this.hasFades = hasFades;
        this.doImmediateRepaint = false;
        this.hasPendingLayoutRequests = false;
        this.pendingAnimationCount = 0;
        this.eventListeners = new ArrayList();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.delegate.addLayoutComponent(name, comp);
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.getPendingAnimationCount() > 0) {
            this.requestLayout();
            return;
        }
        this.fireEvent(null, 100);
        this.installBorders(this.container);
        HashMap<JComponent, Rectangle> oldLocations = new HashMap<JComponent, Rectangle>();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            JComponent jc = (JComponent)c;
            if (!jc.isVisible() || this.hasFades && !Boolean.TRUE.equals(jc.getClientProperty(SHOWING))) {
                TransitionLayout.setAlpha(jc, new Float(0.0), new Float(0.0), true);
            }
            if (Boolean.TRUE.equals(jc.getClientProperty(LIMBO))) {
                jc.setVisible(false);
            }
            oldLocations.put(jc, new Rectangle(jc.getBounds()));
        }
        HashMap<Component, Boolean> parentOpacityMap = new HashMap<Component, Boolean>();
        if (this.hasFades) {
            TransitionLayout.makeNonOpaque(parent, parentOpacityMap);
        }
        this.delegate.layoutContainer(parent);
        if (this.hasFades) {
            TransitionLayout.restoreOpaque(parent, parentOpacityMap, true);
            if (parentOpacityMap.size() > 0) {
                throw new IllegalStateException();
            }
        }
        parent.repaint();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            HashMap<Component, Boolean> opacity;
            boolean isShowing;
            Component comp = parent.getComponent(i);
            final JComponent jc = (JComponent)comp;
            final Rectangle newBounds = new Rectangle(jc.getBounds());
            final Rectangle oldBounds = jc.getClientProperty(BOUNDS) instanceof Rectangle ? (Rectangle)jc.getClientProperty(BOUNDS) : (Rectangle)oldLocations.get(jc);
            boolean wasShowing = Boolean.TRUE.equals(jc.getClientProperty(SHOWING)) && !FadeTracker.getInstance().isTracked(jc, COMPONENT_FADE);
            boolean bl = isShowing = jc.isVisible() && !Boolean.TRUE.equals(jc.getClientProperty(LIMBO));
            if (jc.isVisible()) {
                jc.putClientProperty(SHOWING, Boolean.TRUE);
            } else {
                jc.putClientProperty(SHOWING, null);
            }
            jc.putClientProperty(BOUNDS, new Rectangle(newBounds));
            if (Boolean.TRUE.equals(jc.getClientProperty(LIMBO))) {
                jc.setVisible(true);
            }
            if (!isShowing && !wasShowing) {
                TransitionLayout.clearAlpha(jc, true);
            }
            if (isShowing && wasShowing && !oldBounds.equals(newBounds)) {
                jc.setBounds(oldBounds);
                opacity = new HashMap<Component, Boolean>();
                if (this.hasFades) {
                    TransitionLayout.makeNonOpaque(jc, opacity);
                }
                this.animationStarted();
                FadeTracker.getInstance().trackFadeIn(COMPONENT_BOUNDS, jc, false, new UIThreadFadeTrackerAdapter(){

                    @Override
                    public void fadeEnded(FadeKind fadeKind) {
                        float parentAlpha;
                        if (TransitionLayout.this.hasFades) {
                            TransitionLayout.restoreOpaque(jc, opacity, true);
                            if (opacity.size() > 0) {
                                throw new IllegalStateException();
                            }
                        }
                        if ((parentAlpha = TransitionLayout.this.getCompositeAlpha(jc.getParent())) < 1.0f) {
                            TransitionLayout.setAlpha(jc, new Float(parentAlpha), new Float(1.0f), true);
                        } else {
                            TransitionLayout.clearAlpha(jc, true);
                        }
                        TransitionLayout.this.animationEnded();
                    }

                    @Override
                    public void fadePerformed(FadeKind fadeKind, float fade) {
                        Rectangle currBounds = new Rectangle((int)((float)oldBounds.x + fade * (float)(newBounds.x - oldBounds.x)), (int)((float)oldBounds.y + fade * (float)(newBounds.y - oldBounds.y)), (int)((float)oldBounds.width + fade * (float)(newBounds.width - oldBounds.width)), (int)((float)oldBounds.height + fade * (float)(newBounds.height - oldBounds.height)));
                        jc.setBounds(currBounds);
                        TransitionLayout.this.fireEvent(jc, 104);
                        jc.doLayout();
                        if (TransitionLayout.this.hasFades) {
                            double coef = 1.0 + 2.0 * Math.abs((double)fade - 0.5);
                            double alpha = 0.5 + 0.25 * coef * coef / 2.0;
                            TransitionLayout.setAlpha(jc, new Float((double)TransitionLayout.this.getCompositeAlpha(jc.getParent()) * alpha), new Float(alpha), true);
                        }
                        TransitionLayout.this.repaint(jc);
                    }
                });
            }
            if (!wasShowing && isShowing && this.hasFades) {
                TransitionLayout.setAlpha(jc, new Float(0.0), new Float(0.0), true);
                jc.setBounds(newBounds);
                opacity = new HashMap();
                TransitionLayout.makeNonOpaque(jc, opacity);
                jc.setVisible(true);
                this.animationStarted();
                FadeTracker.getInstance().trackFadeIn(COMPONENT_FADE, jc, false, new UIThreadFadeTrackerAdapter(){

                    @Override
                    public void fadeEnded(FadeKind fadeKind) {
                        float parentAlpha = TransitionLayout.this.getCompositeAlpha(jc.getParent());
                        if (parentAlpha < 1.0f) {
                            TransitionLayout.setAlpha(jc, new Float(parentAlpha), new Float(1.0f), true);
                        } else {
                            TransitionLayout.clearAlpha(jc, true);
                        }
                        TransitionLayout.restoreOpaque(jc, opacity, true);
                        if (opacity.size() > 0) {
                            throw new IllegalStateException();
                        }
                        TransitionLayout.this.animationEnded();
                    }

                    @Override
                    public void fadePerformed(FadeKind fadeKind, float fade) {
                        TransitionLayout.setAlpha(jc, new Float(TransitionLayout.this.getCompositeAlpha(jc.getParent()) * fade), new Float(fade), true);
                        TransitionLayout.this.fireEvent(jc, 103);
                        TransitionLayout.this.repaint(jc);
                    }
                });
            }
            if (isShowing || !wasShowing || !this.hasFades) continue;
            float parentAlpha = this.getCompositeAlpha(jc.getParent());
            if (parentAlpha < 1.0f) {
                TransitionLayout.setAlpha(jc, new Float(parentAlpha), new Float(1.0f), true);
            } else {
                TransitionLayout.setAlpha(jc, new Float(1.0f), new Float(1.0f), true);
            }
            final HashMap<Component, Boolean> opacity2 = new HashMap<Component, Boolean>();
            TransitionLayout.makeNonOpaque(jc, opacity2);
            jc.setBounds(oldBounds);
            jc.putClientProperty(LIMBO, Boolean.TRUE);
            jc.setVisible(true);
            this.animationStarted();
            FadeTracker.getInstance().trackFadeOut(COMPONENT_FADE, jc, false, new UIThreadFadeTrackerAdapter(){

                @Override
                public void fadeEnded(FadeKind fadeKind) {
                    TransitionLayout.restoreOpaque(jc, opacity2, true);
                    if (opacity2.size() > 0) {
                        throw new IllegalStateException();
                    }
                    jc.setBounds(newBounds);
                    jc.setVisible(false);
                    jc.putClientProperty(TransitionLayout.SHOWING, null);
                    jc.putClientProperty(TransitionLayout.LIMBO, null);
                    TransitionLayout.clearAlpha(jc, true);
                    TransitionLayout.this.animationEnded();
                }

                @Override
                public void fadePerformed(FadeKind fadeKind, float fade) {
                    TransitionLayout.setAlpha(jc, new Float(TransitionLayout.this.getCompositeAlpha(jc.getParent()) * fade), new Float(fade), true);
                    TransitionLayout.this.fireEvent(jc, 102);
                    TransitionLayout.this.repaint(jc);
                }
            });
        }
        if (this.getPendingAnimationCount() == 0) {
            this.fireEvent(null, 101);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.delegate.minimumLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.delegate.preferredLayoutSize(parent);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.delegate.removeLayoutComponent(comp);
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opacitySnapshot.put(comp, jcomp.isOpaque());
            jcomp.putClientProperty(ORIGINAL_OPACITY, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                TransitionLayout.makeNonOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opacitySnapshot, boolean toCleanup) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opacitySnapshot.containsKey(jcomp)) {
                jcomp.setOpaque(opacitySnapshot.get(jcomp));
                opacitySnapshot.remove(jcomp);
            } else {
                jcomp.setOpaque(true);
            }
            jcomp.putClientProperty(ORIGINAL_OPACITY, null);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                TransitionLayout.restoreOpaque(cont.getComponent(i), opacitySnapshot, false);
            }
        }
        if (toCleanup) {
            for (Map.Entry<Component, Boolean> entry : opacitySnapshot.entrySet()) {
                if (!(entry.getKey() instanceof JComponent)) continue;
                JComponent jcomp = (JComponent)entry.getKey();
                jcomp.setOpaque(entry.getValue());
                jcomp.putClientProperty(ORIGINAL_OPACITY, null);
            }
            opacitySnapshot.clear();
        }
    }

    public static void setAlpha(Component comp, Float alpha, Float ownAlpha, boolean main) {
        int i;
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (main) {
                jcomp.putClientProperty(OWN_ALPHA, ownAlpha);
            } else if (FadeTracker.getInstance().isTracked(jcomp, COMPONENT_FADE)) {
                return;
            }
            jcomp.putClientProperty(ALPHA, alpha);
        }
        if (comp instanceof JList) {
            JList list = (JList)comp;
            for (i = 0; i < list.getModel().getSize(); ++i) {
                Component rendComp = list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt(i), i, list.isSelectedIndex(i), false);
                TransitionLayout.setAlpha(rendComp, alpha, null, false);
            }
        }
        if (comp instanceof JTree) {
            JTree tree = (JTree)comp;
            for (int row = 0; row < tree.getRowCount(); ++row) {
                TreePath path = tree.getPathForRow(row);
                boolean isLeaf = tree.getModel().isLeaf(path.getLastPathComponent());
                Component rendComp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path.getLastPathComponent(), tree.isRowSelected(row), tree.isExpanded(row), isLeaf, row, false);
                TransitionLayout.setAlpha(rendComp, alpha, null, false);
            }
        }
        if (comp instanceof JTable) {
            JTable table = (JTable)comp;
            for (i = 0; i < table.getRowCount(); ++i) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    Component rendComp = table.getCellRenderer(i, j).getTableCellRendererComponent(table, table.getValueAt(i, j), table.isCellSelected(i, j), false, i, j);
                    TransitionLayout.setAlpha(rendComp, alpha, null, false);
                }
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (i = 0; i < cont.getComponentCount(); ++i) {
                TransitionLayout.setAlpha(cont.getComponent(i), alpha, null, false);
            }
        }
    }

    protected static void clearAlpha(Component comp, boolean main) {
        int i;
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.putClientProperty(OWN_ALPHA, null);
            if (!main && FadeTracker.getInstance().isTracked(jcomp, COMPONENT_FADE)) {
                return;
            }
            jcomp.putClientProperty(ALPHA, null);
        }
        if (comp instanceof JList) {
            JList list = (JList)comp;
            for (i = 0; i < list.getModel().getSize(); ++i) {
                Component rendComp = list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt(i), i, list.isSelectedIndex(i), false);
                TransitionLayout.clearAlpha(rendComp, false);
            }
        }
        if (comp instanceof JTree) {
            JTree tree = (JTree)comp;
            for (int row = 0; row < tree.getRowCount(); ++row) {
                TreePath path = tree.getPathForRow(row);
                boolean isLeaf = tree.getModel().isLeaf(path.getLastPathComponent());
                Component rendComp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path.getLastPathComponent(), tree.isRowSelected(row), tree.isExpanded(row), isLeaf, row, false);
                TransitionLayout.clearAlpha(rendComp, false);
            }
        }
        if (comp instanceof JTable) {
            JTable table = (JTable)comp;
            for (i = 0; i < table.getRowCount(); ++i) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    Component rendComp = table.getCellRenderer(i, j).getTableCellRendererComponent(table, table.getValueAt(i, j), table.isCellSelected(i, j), false, i, j);
                    TransitionLayout.clearAlpha(rendComp, false);
                }
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (i = 0; i < cont.getComponentCount(); ++i) {
                TransitionLayout.clearAlpha(cont.getComponent(i), false);
            }
        }
    }

    private synchronized void requestLayout() {
        this.hasPendingLayoutRequests = true;
    }

    private synchronized void layoutFinished() {
        this.hasPendingLayoutRequests = false;
        if (this.getPendingAnimationCount() == 0) {
            this.fireEvent(null, 101);
        }
    }

    private synchronized boolean hasPendingLayoutRequests() {
        return this.hasPendingLayoutRequests;
    }

    private synchronized int getPendingAnimationCount() {
        return this.pendingAnimationCount;
    }

    private synchronized void animationStarted() {
        ++this.pendingAnimationCount;
    }

    private synchronized void animationEnded() {
        --this.pendingAnimationCount;
        if (this.pendingAnimationCount == 0) {
            if (this.hasPendingLayoutRequests()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TransitionLayout.this.layoutContainer(TransitionLayout.this.container);
                        TransitionLayout.this.layoutFinished();
                        TransitionLayout.this.container.repaint();
                    }
                });
            } else {
                this.fireEvent(null, 101);
            }
        }
    }

    public LayoutManager getDelegate() {
        return this.delegate;
    }

    void installBorders(Component comp) {
        JComponent jcomp;
        Border border;
        if (comp instanceof JComponent && (border = (jcomp = (JComponent)comp).getBorder()) != null && !(border instanceof TransitionBorder)) {
            if (border instanceof UIResource) {
                jcomp.setBorder(new TransitionBorder.BorderUIResource(border));
            } else {
                jcomp.setBorder(new TransitionBorder(border));
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.installBorders(cont.getComponent(i));
            }
        }
    }

    void uninstallBorders(Component comp) {
        JComponent jcomp;
        Border border;
        if (comp instanceof JComponent && (border = (jcomp = (JComponent)comp).getBorder()) instanceof TransitionBorder) {
            jcomp.setBorder(((TransitionBorder)border).getDelegate());
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.uninstallBorders(cont.getComponent(i));
            }
        }
    }

    public static Composite getAlphaComposite(Component c, float translucency, Graphics g) {
        AlphaComposite ac;
        Graphics2D g2d;
        Composite existingComposite;
        float xFactor = 1.0f;
        if (g instanceof Graphics2D && (existingComposite = (g2d = (Graphics2D)g).getComposite()) instanceof AlphaComposite && (ac = (AlphaComposite)existingComposite).getRule() == 3) {
            xFactor = ac.getAlpha();
        }
        float finalAlpha = translucency * xFactor;
        if (c instanceof JComponent) {
            Object alphaObj = ((JComponent)c).getClientProperty(ALPHA);
            float transitionAlpha = 1.0f;
            if (alphaObj != null) {
                transitionAlpha = ((Float)alphaObj).floatValue();
            }
            finalAlpha *= transitionAlpha;
        }
        if (finalAlpha == 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.SrcOver.derive(finalAlpha);
    }

    public static Composite getAlphaComposite(Component c, float translucency) {
        return TransitionLayout.getAlphaComposite(c, translucency, null);
    }

    public static Composite getAlphaComposite(Component c, Graphics g) {
        return TransitionLayout.getAlphaComposite(c, 1.0f, g);
    }

    public static Composite getAlphaComposite(Component c) {
        return TransitionLayout.getAlphaComposite(c, 1.0f, null);
    }

    public static boolean isOpaque(Component c) {
        if (c.isOpaque()) {
            return true;
        }
        if (c instanceof JComponent) {
            return Boolean.TRUE.equals(((JComponent)c).getClientProperty(ORIGINAL_OPACITY));
        }
        return false;
    }

    void setDoImmediateRepaint(boolean doImmediateRepaint) {
        this.doImmediateRepaint = doImmediateRepaint;
    }

    protected void repaint(Component comp) {
        if (this.doImmediateRepaint && comp instanceof JComponent) {
            final JComponent jc = (JComponent)comp;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jc.paintImmediately(0, 0, jc.getWidth(), jc.getHeight());
                }
            });
            return;
        }
        comp.repaint();
    }

    protected float getCompositeAlpha(Component c) {
        float result = 1.0f;
        while (c != null) {
            if (c instanceof JComponent) {
                Object alphaObj = ((JComponent)c).getClientProperty(OWN_ALPHA);
                float transitionAlpha = 1.0f;
                if (alphaObj != null) {
                    transitionAlpha = ((Float)alphaObj).floatValue();
                }
                result *= transitionAlpha;
            }
            c = c.getParent();
        }
        return result;
    }

    public synchronized boolean isAnimating() {
        return this.getPendingAnimationCount() > 0;
    }

    public synchronized void addTransitionLayoutListener(TransitionLayoutListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized void removeTransitionLayoutListener(TransitionLayoutListener listener) {
        this.eventListeners.remove(listener);
    }

    protected void fireEvent(Component child, int id) {
        TransitionLayoutEvent event = new TransitionLayoutEvent(this.container, child, id);
        for (TransitionLayoutListener listener : this.eventListeners) {
            listener.onTransitionLayoutEvent(event);
        }
    }
}

