/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMUtils {
    private DOMUtils() {
    }

    public static Document createEmptyDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Failed to create new document!", parserConfigurationException);
        }
        return document;
    }

    public static Document readObject(InputStream inputStream) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Parsing failed", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Parsing failed", sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Parsing failed", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Parsing failed", illegalArgumentException);
        }
        return document;
    }

    public static void writeObject(Document document, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("Failed to write the document!", transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException("Failed to write the document!", transformerException);
        }
    }

    public static void validateTextContent(Node node) throws IllegalArgumentException {
        if (node.getChildNodes().getLength() != 1 || node.getFirstChild().getNodeType() != 3) {
            throw new IllegalArgumentException(node.getNodeName() + ": Not a text node");
        }
    }
}

