#------------------------------>  Tcl - script  <-----------------------------#
#- Copyright (C) 199x by International Computer Science Institute            -#
#- This file is part of the GNU Sather package. It is free software; you may -#
#- redistribute  and/or modify it under the terms of the  GNU General Public -#
#- License (GPL)  as  published  by the  Free  Software  Foundation;  either -#
#- version 2 of the license, or (at your option) any later version.          -#
#- This  program  is distributed  in the  hope that it will  be  useful, but -#
#- WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY -#
#- or FITNESS FOR A PARTICULAR PURPOSE. See Doc/GPL for more details.        -#
#- The license text is also available from:  Free Software Foundation, Inc., -#
#- 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     -#
#------------->  Please email comments to <bug-sather@gnu.org>  <-------------#

# Font and color configuration for the browser

set gTitleFont "-adobe-helvetica-medium-r-normal-*-*-120-*-*-p-*-iso8859-1"

set gCommentFont "-adobe-helvetica-medium-o-normal-*-*-140-*-*-p-*-iso8859-1"
set gClassHighlightFont "7x14"
set gTextFont "7x14"
set gFeatureListFont "-adobe-helvetica-medium-r-normal-*-*-120-*-*-p-*-iso8859-1"

# Various colors stuff.  Improved by Matt Kennel, ORNL/UTK.
# Set colors to control display.
if { $gIsColor } {
    set gSubtypeColor "firebrick"
    set gSubtypeRev   "white"

    set gIncludeColor "black"
    set gIncludeRev "white"

    set gModuleColor "darkgreen"
    set gModuleRev "white"

    set gCommentColor "brown"
    set gClassHighlightColor "blue"

    set gTextTitleColor "steelblue"
    set gTextTitleRev "white"
    #colors for text file window's title.

    set gTextBackgroundColor "gray95"

    # Color for main window border background
    set gDeepBackgroundColor "#d9d9d9"
    set gGraphBackgroundColor "gray95"

    # Color of inform text
    set gInformColor "black"

    # Color for contents window background
    set gBackgroundColor "#d9d9d9"

    set gMenuForegroundColor "black"
    set gMenuBackgroundColor "#d9d9d9"

    # Color for Module&class list title
    set gClassListTitleColor "steelblue"
    set gClassListTitleRev "white"

    #Next two pairs of values are tied to each other
    set gClassListSelectColor "white"
    set gClassListSelectRev   "steelblue"
    # Colors for Feature list and a highlighted class in class list
    set gFeatureListTitleColor ${gClassListSelectRev}
    set gFeatureListTitleRev ${gClassListSelectColor}
    
    # colors for selected features
    set gFeatureListSelectionColor "steelblue"
    set gFeatureListSelectionRev "black"

    set gTextSelectionColor "black"
    set gTextSelectionRev "steelblue"
 } else {
    # b&w choices
    set gDeepBackgroundColor "white"
    set gBackgroundColor "white"
    set gGraphBackgroundColor "white"
    set gSubtypeColor "black" 
    set gSubtypeRev "white" 
    set gIncludeColor "black"
    set gIncludeRev "white"

    set gModuleColor  "black"
    set gModuleRev    "white"
    set gCommentColor "black"
    set gClassHighlightColor "black"

    # Color of inform text
    set gInformColor "black"

    set gTextTitleColor "white"
    set gTextTitleRev "black"

    set gClassListTitleColor "black"
    set gClassListTitleRev "white"

    set gMenuForegroundColor "black"
    set gMenuBackgroundColor "white"

    #Next two pairs of values are tied to each other
    set gClassListSelectColor "white"
    set gClassListSelectRev   "black"

    # Colors for Feature list title tied to class list selection color
    set gFeatureListTitleColor ${gClassListSelectRev}
    set gFeatureListTitleRev ${gClassListSelectColor}

    set gFeatureListSelectionColor "black"
    set gFeatureListSelectionRev "white"

    set gTextSelectionColor "white"
    set gTextSelectionRev "black"
 }


# Set fonts used in various panes
 # Font used to display module names in the list of classes and
 # modules pane.
set gClassListModuleFont "-*-helvetica-bold-r-normal-*-14-*-*-*-p-*-*-*"
 # "lucidasans-bolditalic-14"
set gClassListClassFont  "-*-helvetica-medium-r-normal-*-12-*-*-*-p-*-*-*"
set gGraphButtonFont "-*-helvetica-medium-r-normal-*-12-*-*-*-p-*-*-*"

 # Global table of fonts for use by the graph viewer
set gFontSizes() ""
 # Selected font sized was intended to hold a set of larger fonts
set gBoldFontSizes() ""
set gItalicFontSizes() ""
set gBolditalicFontSizes() ""


    # See the file future.tcl for the old settings of these variables...

set gFontSizes(14) "-*-helvetica-medium-r-normal-*-14-*-*-*-p-*-*-*"
set gFontSizes(13) "-*-helvetica-medium-r-normal-*-13-*-*-*-p-*-*-*"
set gFontSizes(12) "-*-helvetica-medium-r-normal-*-12-*-*-*-p-*-*-*"
set gFontSizes(11) "-*-helvetica-medium-r-normal-*-11-*-*-*-p-*-*-*"
set gFontSizes(10) "-*-helvetica-medium-r-normal-*-10-*-*-*-p-*-*-*"
set gFontSizes(9)  "-*-helvetica-medium-r-normal-*-9-*-*-*-p-*-*-*"
set gFontSizes(8)  "-*-helvetica-medium-r-normal-*-8-*-*-*-p-*-*-*"
set gFontSizes(7)  "-*-helvetica-medium-r-normal-*-7-*-*-*-p-*-*-*"
set gFontSizes(6)  "-*-helvetica-medium-r-normal-*-6-*-*-*-p-*-*-*"
set gFontSizes(5)  "-*-helvetica-medium-r-normal-*-5-*-*-*-p-*-*-*"
set gFontSizes(4)  "-*-helvetica-medium-r-normal-*-4-*-*-*-p-*-*-*"
set gFontSizes(3)  "-*-helvetica-medium-r-normal-*-3-*-*-*-p-*-*-*"
set gFontSizes(2)  "-*-helvetica-medium-r-normal-*-2-*-*-*-p-*-*-*"
set gFontSizes(1) "nil2"

set gItalicFontSizes(14) "-*-helvetica-medium-o-normal-*-14-*-*-*-p-*-*-*"
set gItalicFontSizes(13) "-*-helvetica-medium-o-normal-*-13-*-*-*-p-*-*-*"
set gItalicFontSizes(12) "-*-helvetica-medium-o-normal-*-12-*-*-*-p-*-*-*"
set gItalicFontSizes(11) "-*-helvetica-medium-o-normal-*-11-*-*-*-p-*-*-*"
set gItalicFontSizes(10) "-*-helvetica-medium-o-normal-*-10-*-*-*-p-*-*-*"
set gItalicFontSizes(9)  "-*-helvetica-medium-o-normal-*-9-*-*-*-p-*-*-*"
set gItalicFontSizes(8)  "-*-helvetica-medium-o-normal-*-8-*-*-*-p-*-*-*"
set gItalicFontSizes(7)  "-*-helvetica-medium-o-normal-*-7-*-*-*-p-*-*-*"
set gItalicFontSizes(6)  "-*-helvetica-medium-o-normal-*-6-*-*-*-p-*-*-*"
set gItalicFontSizes(5)  "-*-helvetica-medium-o-normal-*-5-*-*-*-p-*-*-*"
set gItalicFontSizes(4)  "-*-helvetica-medium-o-normal-*-4-*-*-*-p-*-*-*"
set gItalicFontSizes(3)  "-*-helvetica-medium-o-normal-*-3-*-*-*-p-*-*-*"
set gItalicFontSizes(2)  "-*-helvetica-medium-o-normal-*-2-*-*-*-p-*-*-*"
set gItalicFontSizes(1) "nil2"

set gBoldFontSizes(14) "-*-helvetica-bold-r-normal-*-14-*-*-*-p-*-*-*"
set gBoldFontSizes(13) "-*-helvetica-bold-r-normal-*-13-*-*-*-p-*-*-*"
set gBoldFontSizes(12) "-*-helvetica-bold-r-normal-*-12-*-*-*-p-*-*-*"
set gBoldFontSizes(11) "-*-helvetica-bold-r-normal-*-11-*-*-*-p-*-*-*"
set gBoldFontSizes(10) "-*-helvetica-bold-r-normal-*-10-*-*-*-p-*-*-*"
set gBoldFontSizes(9)  "-*-helvetica-bold-r-normal-*-9-*-*-*-p-*-*-*"
set gBoldFontSizes(8)  "-*-helvetica-bold-r-normal-*-8-*-*-*-p-*-*-*"
set gBoldFontSizes(7)  "-*-helvetica-bold-r-normal-*-7-*-*-*-p-*-*-*"
set gBoldFontSizes(6)  "-*-helvetica-bold-r-normal-*-6-*-*-*-p-*-*-*"
set gBoldFontSizes(5)  "-*-helvetica-bold-r-normal-*-5-*-*-*-p-*-*-*"
set gBoldFontSizes(4)  "-*-helvetica-bold-r-normal-*-4-*-*-*-p-*-*-*"
set gBoldFontSizes(3)  "-*-helvetica-bold-r-normal-*-3-*-*-*-p-*-*-*"
set gBoldFontSizes(2)  "-*-helvetica-bold-r-normal-*-2-*-*-*-p-*-*-*"
set gBoldFontSizes(1) "nil2"

set gBolditalicFontSizes(14) "-*-helvetica-bold-o-normal-*-14-*-*-*-p-*-*-*"
set gBolditalicFontSizes(13) "-*-helvetica-bold-o-normal-*-13-*-*-*-p-*-*-*"
set gBolditalicFontSizes(12) "-*-helvetica-bold-o-normal-*-12-*-*-*-p-*-*-*"
set gBolditalicFontSizes(11) "-*-helvetica-bold-o-normal-*-11-*-*-*-p-*-*-*"
set gBolditalicFontSizes(10) "-*-helvetica-bold-o-normal-*-10-*-*-*-p-*-*-*"
set gBolditalicFontSizes(9)  "-*-helvetica-bold-o-normal-*-9-*-*-*-p-*-*-*"
set gBolditalicFontSizes(8)  "-*-helvetica-bold-o-normal-*-8-*-*-*-p-*-*-*"
set gBolditalicFontSizes(7)  "-*-helvetica-bold-o-normal-*-7-*-*-*-p-*-*-*"
set gBolditalicFontSizes(6)  "-*-helvetica-bold-o-normal-*-6-*-*-*-p-*-*-*"
set gBolditalicFontSizes(5)  "-*-helvetica-bold-o-normal-*-5-*-*-*-p-*-*-*"
set gBolditalicFontSizes(4)  "-*-helvetica-bold-o-normal-*-4-*-*-*-p-*-*-*"
set gBolditalicFontSizes(3)  "-*-helvetica-bold-o-normal-*-3-*-*-*-p-*-*-*"
set gBolditalicFontSizes(2)  "-*-helvetica-bold-o-normal-*-2-*-*-*-p-*-*-*"
set gBolditalicFontSizes(1) "nil2"
