## Copyright 2015-2016 Oliver Heimlich
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @documentencoding UTF-8
## @defmethod {@@infsupdec} cbrt (@var{X})
##
## Compute the cube root.
##
## Accuracy: The result is a tight enclosure.
##
## @example
## @group
## cbrt (infsupdec (-27, 27))
##   @result{} ans = [-3, +3]_com
## @end group
## @end example
## @seealso{@@infsupdec/realsqrt, @@infsupdec/nthroot}
## @end defmethod

## Author: Oliver Heimlich
## Keywords: interval
## Created: 2015-03-15

function result = cbrt (x)

  if (nargin ~= 1)
    print_usage ();
    return
  endif

  result = newdec (cbrt (x.infsup));
  result.dec = min (result.dec, x.dec);

endfunction

%!# from the documentation string
%!assert (isequal (cbrt (infsupdec (-27, 27)), infsupdec (-3, 3)));
