/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ResolveNames;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.reflect.ClassMethodProc;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.MakeElement;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.mapping.WrongArguments;
import gnu.xml.NamespaceBinding;
import gnu.xml.SName;
import gnu.xquery.lang.XQParser;
import gnu.xquery.lang.XQuery;
import gnu.xquery.util.NamedCollator;
import gnu.xquery.util.QNameUtils;

public class XQResolveNames
extends ResolveNames {
    XQParser parser;
    public static final int LAST_BUILTIN = -1;
    public static final int POSITION_BUILTIN = -2;
    public static final int XS_QNAME_BUILTIN = -3;
    public static final int COMPARE_BUILTIN = -4;
    public static final int DISTINCT_VALUES_BUILTIN = -5;
    public static final int LOCAL_NAME_BUILTIN = -6;
    public static final int NAMESPACE_URI_BUILTIN = -7;
    public static final int ROOT_BUILTIN = -8;
    public static final int DOC_BUILTIN = -9;
    public static final int DOC_AVAILABLE_BUILTIN = -10;
    public static final Declaration lastDecl = XQResolveNames.makeBuiltin("last", -1);
    public static final Declaration xsQNameDecl = XQResolveNames.makeBuiltin(Symbol.make("http://www.w3.org/2001/XMLSchema", "QName"), -3);
    public Namespace[] functionNamespacePath = XQuery.defaultFunctionNamespacePath;
    NamespaceBinding constructorNamespaces;

    public static Declaration makeBuiltin(String string, int n) {
        return XQResolveNames.makeBuiltin(Symbol.make("http://www.w3.org/2004/10/xpath-functions", string), n);
    }

    public static Declaration makeBuiltin(Symbol symbol, int n) {
        Declaration declaration = new Declaration(symbol);
        declaration.setProcedureDecl(true);
        declaration.setCode(n);
        return declaration;
    }

    public XQResolveNames() {
        this(null);
    }

    void pushBuiltin(String string, int n) {
        this.lookup.push(XQResolveNames.makeBuiltin(string, n));
    }

    public XQResolveNames(Compilation compilation) {
        super(compilation);
        this.lookup.push(lastDecl);
        this.lookup.push(xsQNameDecl);
        this.pushBuiltin("position", -2);
        this.pushBuiltin("compare", -4);
        this.pushBuiltin("distinct-values", -5);
        this.pushBuiltin("local-name", -6);
        this.pushBuiltin("namespace-uri", -7);
        this.pushBuiltin("root", -8);
        this.pushBuiltin("doc", -9);
        this.pushBuiltin("document", -9);
        this.pushBuiltin("doc-available", -10);
    }

    protected Symbol namespaceResolve(String string, boolean bl) {
        Object object2;
        int n = string.indexOf(58);
        String string2 = n >= 0 ? string.substring(0, n) : (bl ? "functions$" : "elements$");
        String string3 = ("$Namespace$" + string2).intern();
        Declaration declaration = this.lookup.lookup((Object)string3, -1);
        Object object3 = null;
        if (declaration != null) {
            object3 = declaration.getConstantValue();
        }
        if (!(object3 instanceof String)) {
            if (n < 0) {
                object3 = "";
            } else {
                try {
                    object2 = Class.forName(string2);
                    object3 = "class:" + string2;
                }
                catch (Exception exception) {
                    this.error('e', "unknown namespace prefix '" + string2 + "'");
                    return null;
                }
            }
        }
        object2 = n < 0 ? string : string.substring(n + 1);
        return Symbol.make(object3, (String)object2);
    }

    protected void push(ScopeExp scopeExp) {
        Declaration declaration;
        Compilation compilation = this.getCompilation();
        for (declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (!declaration.isNamespaceDecl()) continue;
            this.lookup.push(declaration);
        }
        for (declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Declaration declaration2;
            if (declaration.isNamespaceDecl()) continue;
            Object object2 = declaration.getSymbol();
            boolean bl = declaration.isProcedureDecl();
            if (object2 instanceof String) {
                int n = declaration.getLine();
                if (n > 0 && compilation != null) {
                    String string = compilation.getFile();
                    int n2 = compilation.getLine();
                    int n3 = compilation.getColumn();
                    compilation.setLine(declaration.getFile(), n, declaration.getColumn());
                    object2 = this.namespaceResolve((String)object2, bl);
                    compilation.setLine(string, n2, n3);
                } else {
                    object2 = this.namespaceResolve((String)object2, bl);
                }
                if (object2 == null) continue;
                declaration.setName(object2);
            }
            if (!((declaration2 = this.lookup.lookup(object2, bl)) == null || object2 instanceof Symbol && ((Symbol)object2).getNamespace() == null)) {
                compilation.error('w', declaration, "declaration ", " hides previous declaration");
            }
            this.lookup.push(declaration);
        }
    }

    Declaration flookup(Symbol symbol) {
        Object object2;
        Environment environment = XQuery.xqEnvironment;
        Location location2 = environment.lookup(symbol, EnvironmentKey.FUNCTION);
        if (location2 == null) {
            return null;
        }
        if ((location2 = location2.getBase()) instanceof StaticFieldLocation && (object2 = ((StaticFieldLocation)location2).getDeclaration()) != null) {
            return object2;
        }
        object2 = location2.get(null);
        if (object2 != null) {
            return XQResolveNames.procToDecl(symbol, object2);
        }
        return null;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        if (referenceExp.getBinding() == null) {
            boolean bl;
            Object object2 = referenceExp.getSymbol();
            Declaration declaration = this.lookup.lookup(object2, bl = referenceExp.isProcedureName());
            if (declaration == null) {
                Symbol symbol;
                if (object2 instanceof Symbol && "".equals((symbol = (Symbol)object2).getNamespaceURI())) {
                    String string = symbol.getLocalName();
                    Expression expression = "request".equals(string) ? XQParser.makeFunctionExp("gnu.kawa.servlet.GetRequest", "getRequest") : ("response".equals(string) ? XQParser.makeFunctionExp("gnu.kawa.servlet.GetResponse", "getResponse") : null);
                    if (expression != null) {
                        return new ApplyExp(expression, Expression.noExpressions);
                    }
                } else {
                    String string = (String)object2;
                    if (bl && string.indexOf(58) < 0) {
                        for (int i = 0; !(i >= this.functionNamespacePath.length || (symbol = this.functionNamespacePath[i].lookup(string)) != null && ((declaration = this.lookup.lookup((Object)symbol, bl)) != null || bl && (declaration = this.flookup(symbol)) != null)); ++i) {
                        }
                    } else {
                        symbol = this.namespaceResolve(string, bl);
                        if (symbol != null && (declaration = this.lookup.lookup((Object)symbol, bl)) == null && bl) {
                            String string2 = symbol.getNamespaceURI();
                            if (string2 != null && string2.length() > 6 && string2.startsWith("class:")) {
                                ClassType classType = ClassType.make(string2.substring(6));
                                return ClassMethodProc.makeExp(new QuoteExp(classType), new QuoteExp((Object)symbol.getName()));
                            }
                            declaration = this.flookup(symbol);
                        }
                    }
                }
            }
            if (declaration != null) {
                referenceExp.setBinding(declaration);
            } else {
                this.error('e', (bl ? "unknown function " : "unknown variable $") + object2);
            }
        }
        return referenceExp;
    }

    protected Expression walkSetExp(SetExp setExp) {
        Object object2;
        Expression expression = super.walkSetExp(setExp);
        Declaration declaration = setExp.getBinding();
        if (declaration != null && !this.getCompilation().immediate && (object2 = declaration.getSymbol()) instanceof Symbol && "http://www.w3.org/2004/10/xquery-local-functions".equals(((Symbol)object2).getNamespaceURI())) {
            declaration.setFlag(0x1000000);
            declaration.setPrivate(true);
        }
        return expression;
    }

    Expression getCollator(Expression[] expressionArray, int n) {
        if (expressionArray != null && expressionArray.length > n) {
            return new ApplyExp(ClassType.make("gnu.xquery.util.NamedCollator").getDeclaredMethod("find", 1), new Expression[]{expressionArray[n]});
        }
        NamedCollator namedCollator = this.parser.defaultCollator;
        return namedCollator == null ? QuoteExp.nullExp : new QuoteExp(namedCollator);
    }

    Expression withCollator(Method method, Expression[] expressionArray, String string, int n) {
        return this.withCollator(new QuoteExp(new PrimProcedure(method)), expressionArray, string, n);
    }

    Expression withCollator(Expression expression, Expression[] expressionArray, String string, int n) {
        String string2 = WrongArguments.checkArgCount(string, n, n + 1, expressionArray.length);
        if (string2 != null) {
            return this.getCompilation().syntaxError(string2);
        }
        Expression[] expressionArray2 = new Expression[n + 1];
        System.arraycopy(expressionArray, 0, expressionArray2, 0, n);
        expressionArray2[n] = this.getCollator(expressionArray, n);
        return new ApplyExp(expression, expressionArray2);
    }

    Expression withContext(Method method, Expression[] expressionArray, String string, int n) {
        String string2 = WrongArguments.checkArgCount(string, n, n + 1, expressionArray.length);
        if (string2 != null) {
            return this.getCompilation().syntaxError(string2);
        }
        if (expressionArray.length == n) {
            Expression[] expressionArray2 = new Expression[n + 1];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, n);
            Declaration declaration = this.lookup.lookup((Object)XQParser.DOT_VARNAME, -1);
            if (declaration == null) {
                return this.getCompilation().syntaxError("undefined context for " + string);
            }
            expressionArray2[n] = new ReferenceExp(declaration);
            expressionArray = expressionArray2;
        }
        return new ApplyExp(method, expressionArray);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        int n;
        Object object2;
        Expression expression = applyExp.getFunction();
        NamespaceBinding namespaceBinding = this.constructorNamespaces;
        Object object3 = applyExp.getFunctionValue();
        if (object3 instanceof MakeElement) {
            this.constructorNamespaces = ((MakeElement)object3).getNamespaceNodes();
        }
        super.walkApplyExp(applyExp);
        this.constructorNamespaces = namespaceBinding;
        expression = applyExp.getFunction();
        if (expression instanceof ReferenceExp && (object2 = ((ReferenceExp)expression).getBinding()) != null && (n = ((Declaration)object2).getCode()) < 0) {
            switch (n) {
                case -2: 
                case -1: {
                    Symbol symbol = n == -1 ? XQParser.LAST_VARNAME : XQParser.POSITION_VARNAME;
                    object2 = this.lookup.lookup((Object)symbol, -1);
                    if (object2 == null) {
                        this.error('e', "undefined context for " + symbol.getName());
                    }
                    return new ReferenceExp(symbol, (Declaration)object2);
                }
                case -3: {
                    Expression[] expressionArray = applyExp.getArgs();
                    if (expressionArray[0] instanceof QuoteExp) {
                        try {
                            Object object4 = ((QuoteExp)expressionArray[0]).getValue();
                            object4 = QNameUtils.resolveQName(object4, this.constructorNamespaces, this.parser.prologNamespaces);
                            return new QuoteExp(object4);
                        }
                        catch (RuntimeException runtimeException) {
                            return this.getCompilation().syntaxError(runtimeException.getMessage());
                        }
                    }
                    Expression[] expressionArray2 = new Expression[]{expressionArray[0], new QuoteExp(this.constructorNamespaces), new QuoteExp(this.parser.prologNamespaces)};
                    Method method = ClassType.make("gnu.xquery.util.QNameUtils").getDeclaredMethod("resolveQName", 3);
                    ApplyExp applyExp2 = new ApplyExp(method, expressionArray2);
                    applyExp2.setFlag(2);
                    return applyExp2;
                }
                case -6: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("localName", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:local-name", 0);
                }
                case -8: {
                    Method method = ClassType.make("gnu.kawa.xml.Nodes").getDeclaredMethod("root", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:root", 0);
                }
                case -7: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("namespaceURI", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:namespace-uri", 0);
                }
                case -4: {
                    Method method = ClassType.make("gnu.xquery.util.StringValue").getDeclaredMethod("compare", 3);
                    return this.withCollator(method, applyExp.getArgs(), "fn:compare", 2);
                }
                case -10: 
                case -9: {
                    String string;
                    Expression[] expressionArray = applyExp.getArgs();
                    ClassType classType = ClassType.make("gnu.kawa.xml.Document");
                    if (n == -9) {
                        string = "parseCached";
                        if (XQParser.warnOldVersion && "document".equals(((Declaration)object2).getName())) {
                            this.getCompilation().error('w', "replace 'document' by 'doc'");
                        }
                    } else {
                        string = "availableCached";
                    }
                    Method method = classType.getDeclaredMethod(string, 2);
                    String string2 = WrongArguments.checkArgCount("fn:" + ((Declaration)object2).getName(), 1, 1, expressionArray.length);
                    if (string2 != null) {
                        return this.getCompilation().syntaxError(string2);
                    }
                    QuoteExp quoteExp = QuoteExp.getInstance(this.parser.baseURI);
                    return new ApplyExp(method, new Expression[]{expressionArray[0], quoteExp});
                }
                case -5: {
                    Method method = ClassType.make("gnu.xquery.util.DistinctValues").getDeclaredMethod("distinctValues$X", 3);
                    return this.withCollator(method, applyExp.getArgs(), "fn:distinct-values", 1);
                }
            }
        }
        if ((object3 = applyExp.getFunctionValue()) instanceof MakeElement) {
            object2 = (MakeElement)object3;
            NamespaceBinding namespaceBinding2 = ((MakeElement)object2).getNamespaceNodes();
            namespaceBinding2 = XQResolveNames.maybeAddNamespace(MakeElement.getTagName(applyExp), namespaceBinding2);
            Expression[] expressionArray = applyExp.getArgs();
            for (int i = 0; i < expressionArray.length; ++i) {
                ApplyExp applyExp3;
                Expression expression2;
                if (!((expression2 = expressionArray[i++]) instanceof ApplyExp) || (applyExp3 = (ApplyExp)expression2).getFunction() != MakeAttribute.makeAttributeExp) continue;
                namespaceBinding2 = XQResolveNames.maybeAddNamespace(MakeElement.getTagName(applyExp3), namespaceBinding2);
            }
            if (namespaceBinding2 != null) {
                ((MakeElement)object2).setNamespaceNodes(namespaceBinding2);
            }
        }
        return applyExp;
    }

    static NamespaceBinding maybeAddNamespace(SName sName, NamespaceBinding namespaceBinding) {
        if (sName == null) {
            return namespaceBinding;
        }
        String string = sName.getPrefix();
        String string2 = sName.getNamespaceURI();
        return NamespaceBinding.maybeAdd(string, string2 == "" ? null : string2, namespaceBinding);
    }

    static Declaration procToDecl(Object object2, Object object3) {
        Declaration declaration = new Declaration(object2);
        declaration.setProcedureDecl(true);
        declaration.noteValue(new QuoteExp(object3));
        declaration.setFlag(16384);
        return declaration;
    }
}

