/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.ExtPosition;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;

class LListPosition
extends ExtPosition {
    Object xpos;

    public LListPosition(LListPosition lListPosition) {
        this.sequence = lListPosition.sequence;
        this.ipos = lListPosition.ipos;
        this.xpos = lListPosition.xpos;
    }

    public SeqPosition copy() {
        return new LListPosition(this);
    }

    public LListPosition(LList lList, int n, boolean bl) {
        this.set(lList, n, bl);
    }

    public void set(LList lList, int n, boolean bl) {
        this.sequence = lList;
        this.ipos = n << 1 | (bl ? 1 : 0);
        int n2 = n;
        n2 = bl ? (n2 -= 2) : --n2;
        if (n2 >= 0) {
            Object object2 = lList;
            while (--n2 >= 0) {
                object2 = ((Pair)object2).cdr;
            }
            this.xpos = object2;
        } else {
            this.xpos = null;
        }
    }

    public void set(AbstractSequence abstractSequence, int n, boolean bl) {
        this.set((LList)abstractSequence, n, bl);
    }

    public boolean hasNext() {
        if (this.xpos == null) {
            if (this.ipos >> 1 == 0) {
                return this.sequence != LList.Empty;
            }
            return ((Pair)this.sequence).cdr != LList.Empty;
        }
        Object object2 = ((Pair)this.xpos).cdr;
        if ((this.ipos & 1) > 0) {
            object2 = ((Pair)object2).cdr;
        }
        return object2 != LList.Empty;
    }

    public boolean hasPrevious() {
        return this.ipos >>> 1 != 0;
    }

    public Pair getNextPair() {
        Object object2;
        int n = this.ipos & 1;
        if (n > 0) {
            if (this.xpos == null) {
                object2 = this.sequence;
                if (this.ipos >> 1 != 0) {
                    object2 = ((Pair)object2).cdr;
                }
            } else {
                object2 = ((Pair)((Pair)this.xpos).cdr).cdr;
            }
        } else {
            object2 = this.xpos == null ? this.sequence : ((Pair)this.xpos).cdr;
        }
        if (object2 == LList.Empty) {
            return null;
        }
        return (Pair)object2;
    }

    public Object getNext() {
        Pair pair = this.getNextPair();
        return pair == null ? Sequence.eofValue : pair.car;
    }

    public void setNext(Object object2) {
        Pair pair = this.getNextPair();
        pair.car = object2;
    }

    public Pair getPreviousPair() {
        int n = this.ipos & 1;
        Object object2 = this.xpos;
        if (n > 0) {
            object2 = object2 == null ? this.sequence : ((Pair)object2).cdr;
        } else if (object2 == null) {
            return null;
        }
        if (object2 == LList.Empty) {
            return null;
        }
        return (Pair)object2;
    }

    public Object getPrevious() {
        Pair pair = this.getPreviousPair();
        return pair == null ? Sequence.eofValue : pair.car;
    }

    public void setPrevious(Object object2) {
        Pair pair = this.getPreviousPair();
        pair.car = object2;
    }

    public int nextIndex() {
        return this.ipos >> 1;
    }

    public boolean gotoNext() {
        boolean bl = (this.ipos & 1) != 0;
        int n = this.ipos;
        Object object2 = this.xpos;
        if (object2 != null) {
            if (bl) {
                object2 = ((Pair)object2).cdr;
            }
            if (((Pair)object2).cdr == LList.Empty) {
                return false;
            }
            this.xpos = object2;
            this.ipos = (this.ipos | 1) + 2;
        } else if (this.ipos >> 1 == 0) {
            if (this.sequence == LList.Empty) {
                return false;
            }
            this.ipos = 3;
        } else {
            object2 = this.sequence;
            if (((Pair)object2).cdr == LList.Empty) {
                return false;
            }
            this.ipos = 5;
            this.xpos = object2;
        }
        return true;
    }

    public boolean gotoPrevious() {
        if (this.ipos >>> 1 == 0) {
            return false;
        }
        if ((this.ipos & 1) != 0) {
            this.ipos -= 3;
            return true;
        }
        int n = this.nextIndex();
        this.set((LList)this.sequence, n - 1, false);
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LListPos[");
        stringBuffer.append("index:");
        stringBuffer.append(this.ipos);
        if (this.isAfter()) {
            stringBuffer.append(" after");
        }
        if (this.position >= 0) {
            stringBuffer.append(" position:");
            stringBuffer.append(this.position);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

