/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;

public class Invoke
extends ProcedureN
implements CanInline {
    char kind;
    Language language;
    public static final Invoke invoke = new Invoke("invoke", 'V');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke invokeSpecial = new Invoke("invoke-special", 'P');
    public static final Invoke make = new Invoke("make", 'N');
    private PrimProcedure[] cacheMethods;
    private Expression[] cacheArgs;
    private int cacheDefinitelyApplicableMethodCount;
    private int cachePossiblyApplicableMethodCount;

    public Invoke(String string, char c) {
        super(string);
        this.kind = c;
        this.language = Language.getDefaultLanguage();
    }

    public Invoke(String string, char c, Language language) {
        super(string);
        this.kind = c;
        this.language = language;
    }

    public static Object invoke$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invoke, objectArray);
    }

    public static Object invokeStatic$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invokeStatic, objectArray);
    }

    public static Object make$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(make, objectArray);
    }

    private static ClassType typeFrom(Object object2, Invoke invoke) {
        if (object2 instanceof Class) {
            object2 = Type.make((Class)object2);
        }
        if (object2 instanceof ClassType) {
            return (ClassType)object2;
        }
        if (object2 instanceof String || object2 instanceof FString) {
            return ClassType.make(object2.toString());
        }
        if (object2 instanceof Symbol) {
            return ClassType.make(((Symbol)object2).getName());
        }
        throw new WrongType((Procedure)invoke, 0, null);
    }

    public void apply(CallContext callContext) throws Throwable {
        this.apply(callContext.getArgs(), callContext);
    }

    public void apply(Object[] objectArray, CallContext callContext) throws Throwable {
        if (this.kind == 'S' || this.kind == 'V') {
            String string;
            int n = objectArray.length;
            Procedure.checkArgCount(this, n);
            Object object2 = objectArray[0];
            ClassType classType = this.kind != 'V' ? Invoke.typeFrom(object2, this) : (ClassType)Type.make(object2.getClass());
            Object object3 = objectArray[1];
            if (object3 instanceof String || object3 instanceof FString) {
                string = object3.toString();
            } else if (object3 instanceof Symbol) {
                string = ((Symbol)object3).getName();
            } else {
                throw new WrongType((Procedure)this, 1, null);
            }
            string = Compilation.mangleName(string);
            MethodProc methodProc = ClassMethods.apply(classType, string, null, null, 0, this.kind == 'S' ? 0 : 8);
            if (methodProc == null) {
                throw new RuntimeException(this.getName() + ": no method named `" + string + "' in class " + classType.getName());
            }
            Object[] objectArray2 = new Object[n - (this.kind == 'S' ? 2 : 1)];
            int n2 = 0;
            if (this.kind == 'V') {
                objectArray2[n2++] = objectArray[0];
            }
            System.arraycopy(objectArray, 2, objectArray2, n2, n - 2);
            methodProc.checkN(objectArray2, callContext);
        } else {
            callContext.writeValue(this.applyN(objectArray));
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        return Invoke.applyN(this, objectArray);
    }

    protected static Object applyN(Invoke invoke, Object[] objectArray) throws Throwable {
        Object object2;
        String string;
        char c = invoke.kind;
        if (c == 'P') {
            throw new RuntimeException(invoke.getName() + ": invoke-special not allowed at run time");
        }
        int n = objectArray.length;
        Procedure.checkArgCount(invoke, n);
        Object object3 = objectArray[0];
        ClassType classType = c != 'V' ? Invoke.typeFrom(object3, invoke) : (ClassType)Type.make(object3.getClass());
        Object object4 = null;
        if (c == 'N') {
            string = "<init>";
            if (classType instanceof PairClassType) {
                object2 = (PairClassType)classType;
                classType = ((PairClassType)object2).instanceType;
                object4 = ((PairClassType)object2).getStaticLink();
            }
        } else {
            object2 = objectArray[1];
            if (object2 instanceof String || object2 instanceof FString) {
                string = object2.toString();
            } else if (object2 instanceof Symbol) {
                string = ((Symbol)object2).getName();
            } else {
                throw new WrongType((Procedure)invoke, 1, null);
            }
            string = Compilation.mangleName(string);
        }
        if ((object2 = ClassMethods.apply(classType, string, null, null, invoke.kind == 's' ? 8 : 0, invoke.kind == 'S' ? 0 : 8)) == null) {
            throw new RuntimeException(invoke.getName() + ": no method named `" + string + "' in class " + classType.getName());
        }
        Object[] objectArray2 = new Object[n - (c == 'S' || c == 's' ? 2 : (object4 != null ? 0 : 1))];
        int n2 = 0;
        if (c == 'V') {
            objectArray2[n2++] = objectArray[0];
        } else if (object4 != null) {
            objectArray2[n2++] = object4;
        }
        System.arraycopy(objectArray, c == 'N' ? 1 : 2, objectArray2, n2, n - (c == 'N' ? 1 : 2));
        if (c == 'N') {
            CallContext callContext = CallContext.getInstance();
            int n3 = ((Procedure)object2).matchN(objectArray2, callContext);
            int n4 = n - 1;
            if (n3 == 0) {
                return callContext.runUntilValue();
            }
            if ((n4 & 1) == 0) {
                Object object5;
                for (n2 = 0; n2 < n4; n2 += 2) {
                    if (objectArray2[n2] instanceof Keyword) continue;
                    throw MethodProc.matchFailAsException(n3, invoke, objectArray);
                }
                if (object4 == null) {
                    object5 = ((ProcedureN)object2).apply0();
                    n2 = 0;
                } else {
                    object5 = ((ProcedureN)object2).apply1(object4);
                    n2 = 1;
                }
                while (n2 < n4) {
                    Keyword keyword = (Keyword)objectArray2[n2];
                    Object object6 = objectArray2[n2 + 1];
                    SlotSet.apply(false, object5, keyword.getName(), object6);
                    n2 += 2;
                }
                return object5;
            }
            throw MethodProc.matchFailAsException(n3, invoke, objectArray);
        }
        return ((MethodProc)object2).applyN(objectArray2);
    }

    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected PrimProcedure[] getMethods(ClassType classType, String string, Expression[] expressionArray, int n, int n2, int n3, ClassType classType2) {
        if (expressionArray == this.cacheArgs) {
            return this.cacheMethods;
        }
        Type[] typeArray = new Type[n];
        int n4 = 0;
        if (n3 >= 0) {
            typeArray[n4++] = classType;
        }
        for (int i = n2; i < expressionArray.length && n4 < typeArray.length; ++i, ++n4) {
            typeArray[n4] = expressionArray[i].getType();
        }
        PrimProcedure[] primProcedureArray = ClassMethods.getMethods(classType, string, this.kind == 's' ? 8 : 0, this.kind == 'S' ? 0 : 8, this.kind == 'P', classType2, this.language);
        long l = ClassMethods.selectApplicable(primProcedureArray, typeArray);
        this.cacheArgs = expressionArray;
        this.cacheDefinitelyApplicableMethodCount = (int)(l >> 32);
        this.cachePossiblyApplicableMethodCount = (int)l;
        this.cacheMethods = primProcedureArray;
        return this.cacheMethods;
    }

    static Object[] checkKeywords(Type type, Expression[] expressionArray, int n) {
        int n2 = expressionArray.length;
        if ((n2 - n & 1) != 0) {
            return null;
        }
        Object[] objectArray = new Object[n2 - n >> 1];
        int n3 = objectArray.length;
        while (--n3 >= 0) {
            Expression expression = expressionArray[n + 2 * n3];
            if (!(expression instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression).getValue();
            if (!(object2 instanceof Keyword)) {
                return null;
            }
            String string = ((Keyword)object2).getName();
            Object object3 = SlotSet.getField(type, string);
            objectArray[n3] = object3 != null ? object3 : string;
        }
        return objectArray;
    }

    public static Expression inlineClassName(ApplyExp applyExp, int n, InlineCalls inlineCalls) {
        Compilation compilation = inlineCalls.getCompilation();
        Language language = compilation.getLanguage();
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > n) {
            Type type = language.getTypeFor(expressionArray[n]);
            if (type instanceof PairClassType) {
                type = ((PairClassType)type).instanceType;
            } else if (!(type instanceof Type)) {
                return applyExp;
            }
            if (type instanceof ClassType && ((ClassType)type).isExisting()) {
                try {
                    type.getReflectClass();
                }
                catch (Exception exception) {
                    compilation.error('e', "unknown class: " + type.getName());
                }
            }
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
            expressionArray2[n] = new QuoteExp(type);
            return new ApplyExp(applyExp.getFunction(), expressionArray2).setLine(applyExp);
        }
        return applyExp;
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        return this.inline(applyExp, expWalker.getCompilation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Expression inline(ApplyExp applyExp, Compilation compilation) {
        block29: {
            int n;
            Object object2;
            int n2;
            Procedure[] procedureArray;
            int n3;
            int n4;
            Procedure[] procedureArray2;
            block28: {
                int n5;
                String string;
                ClassType classType;
                block36: {
                    block37: {
                        StringBuffer stringBuffer;
                        block33: {
                            int n6;
                            block35: {
                                block34: {
                                    block31: {
                                        block32: {
                                            block30: {
                                                Object object3;
                                                int n7;
                                                Type type;
                                                procedureArray2 = applyExp.getArgs();
                                                int n8 = procedureArray2.length;
                                                if (n8 == 0 || this.kind == 'V' && n8 == 1) {
                                                    return applyExp;
                                                }
                                                Expression expression = procedureArray2[0];
                                                Type type2 = type = this.kind == 'V' ? expression.getType() : this.language.getTypeFor(expression);
                                                classType = type instanceof PairClassType ? ((PairClassType)type).instanceType : (type instanceof ClassType ? (ClassType)type : null);
                                                string = this.getMethodName((Expression[])procedureArray2);
                                                if (this.kind == 'V') {
                                                    n4 = n8 - 1;
                                                    n7 = 2;
                                                    n3 = 0;
                                                } else if (this.kind == 'N') {
                                                    n4 = n8 - 1;
                                                    n7 = 1;
                                                    n3 = -1;
                                                } else if (this.kind == 'S' || this.kind == 's') {
                                                    n4 = n8 - 2;
                                                    n7 = 2;
                                                    n3 = -1;
                                                } else {
                                                    if (this.kind != 'P') {
                                                        return applyExp;
                                                    }
                                                    n4 = n8 - 2;
                                                    n7 = 3;
                                                    n3 = 1;
                                                }
                                                if (this.kind == 'N' && n7 == 1 && type instanceof PairClassType && ((PairClassType)type).getStaticLink() != null) {
                                                    object3 = new Expression[]{procedureArray2[0]};
                                                    procedureArray = new Expression[n4 + 1];
                                                    procedureArray[0] = new ApplyExp(ClassType.make("gnu.expr.PairClassType").getDeclaredMethod("getStaticLink", 0), (Expression[])object3);
                                                    System.arraycopy(procedureArray2, n7, procedureArray, 1, n4);
                                                    ++n4;
                                                    n7 = 0;
                                                    procedureArray2 = procedureArray;
                                                }
                                                if (classType == null || string == null || this.kind == 'N' && !classType.isExisting() && (!(expression instanceof ReferenceExp) || (object3 = ((ReferenceExp)expression).getBinding()) == null || !((Declaration)object3).getFlag(2048))) break block29;
                                                Invoke invoke = this;
                                                synchronized (invoke) {
                                                    try {
                                                        procedureArray = this.getMethods(classType, string, (Expression[])procedureArray2, n4, n7, n3, compilation == null ? null : (compilation.curClass != null ? compilation.curClass : compilation.mainClass));
                                                    }
                                                    catch (Exception exception) {
                                                        compilation.error('w', "unknown class: " + classType.getName());
                                                        procedureArray = null;
                                                    }
                                                    n5 = this.cacheDefinitelyApplicableMethodCount;
                                                    n6 = this.cachePossiblyApplicableMethodCount;
                                                    if (procedureArray == null) break block29;
                                                }
                                                n2 = -1;
                                                if (procedureArray.length != 0) break block30;
                                                if (compilation.getBooleanOption("warn-invoke-unknown-method", true)) {
                                                    compilation.error('w', "no accessible method '" + string + "' in " + classType.getName());
                                                }
                                                break block28;
                                            }
                                            if (n5 + n6 != 0) break block31;
                                            if (this.kind != 'N' || ClassMethods.selectApplicable((PrimProcedure[])procedureArray, Type.typeArray0) >> 32 != 1L || (object2 = Invoke.checkKeywords(classType, (Expression[])procedureArray2, 1)) == null) break block32;
                                            stringBuffer = null;
                                            break block33;
                                        }
                                        compilation.error('w', "no possibly applicable method '" + string + "' in " + classType.getName());
                                        break block28;
                                    }
                                    if (n5 != 1 && (n5 != 0 || n6 != 1)) break block34;
                                    n2 = 0;
                                    break block28;
                                }
                                if (n5 <= 0) break block35;
                                n2 = MethodProc.mostSpecific((MethodProc[])procedureArray, n5);
                                if (n2 >= 0 || this.kind != 'S') break block36;
                                break block37;
                            }
                            if (compilation.getBooleanOption("warn-invoke-unknown-method", true)) {
                                object2 = new StringBuffer();
                                ((StringBuffer)object2).append("more than one possibly applicable method '");
                                ((StringBuffer)object2).append(string);
                                ((StringBuffer)object2).append("' in ");
                                ((StringBuffer)object2).append(classType.getName());
                                this.append((PrimProcedure[])procedureArray, n6, (StringBuffer)object2);
                                compilation.error('w', ((StringBuffer)object2).toString());
                            }
                            break block28;
                        }
                        for (n = 0; n < ((Object)object2).length; ++n) {
                            if (!(object2[n] instanceof String)) continue;
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("no field or setter ");
                            } else {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append('`');
                            stringBuffer.append(object2[n]);
                            stringBuffer.append('\'');
                        }
                        if (stringBuffer != null) {
                            stringBuffer.append(" in class ");
                            stringBuffer.append(classType.getName());
                            compilation.error('w', stringBuffer.toString());
                            break block28;
                        } else {
                            Procedure procedure = procedureArray[0];
                            ApplyExp applyExp2 = new ApplyExp(procedure, new Expression[0]);
                            int n9 = 0;
                            while (true) {
                                if (n9 >= ((Object)object2).length) {
                                    return applyExp2.setLine(applyExp);
                                }
                                Expression[] expressionArray = new Expression[]{applyExp2, new QuoteExp(object2[n9]), procedureArray2[2 * n9 + 2]};
                                applyExp2 = new ApplyExp(SlotSet.setFieldReturnObject, expressionArray);
                                ++n9;
                            }
                        }
                    }
                    for (int i = 0; i < n5; ++i) {
                        if (!((PrimProcedure)procedureArray[i]).getStaticFlag()) continue;
                        if (n2 >= 0) {
                            n2 = -1;
                            break;
                        }
                        n2 = i;
                    }
                }
                if (n2 < 0 && compilation.getBooleanOption("warn-invoke-unknown-method", true)) {
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append("more than one definitely applicable method `");
                    ((StringBuffer)object2).append(string);
                    ((StringBuffer)object2).append("' in ");
                    ((StringBuffer)object2).append(classType.getName());
                    this.append((PrimProcedure[])procedureArray, n5, (StringBuffer)object2);
                    compilation.error('w', ((StringBuffer)object2).toString());
                }
            }
            if (n2 >= 0) {
                object2 = new Expression[n4];
                int n10 = 0;
                if (n3 >= 0) {
                    object2[n10++] = procedureArray2[n3];
                }
                for (n = n7; n < procedureArray2.length && n10 < ((Expression[])object2).length; ++n, ++n10) {
                    object2[n10] = procedureArray2[n];
                }
                Procedure procedure = procedureArray[n2];
                return new ApplyExp(procedure, (Expression[])object2).setLine(applyExp);
            }
        }
        return applyExp;
    }

    private void append(PrimProcedure[] primProcedureArray, int n, StringBuffer stringBuffer) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n  candidate: ");
            stringBuffer.append(primProcedureArray[i]);
        }
    }

    private String getMethodName(Expression[] expressionArray) {
        int n;
        if (this.kind == 'N') {
            return "<init>";
        }
        int n2 = n = this.kind == 'P' ? 2 : 1;
        if (expressionArray.length >= n + 1) {
            return ClassMethods.checkName(expressionArray[n], false);
        }
        return null;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType classType, String string, Expression[] expressionArray) {
        PrimProcedure primProcedure = Invoke.getStaticMethod(classType, string, expressionArray);
        if (primProcedure == null) {
            throw new RuntimeException("missing or ambiguous method `" + string + "' in " + classType.getName());
        }
        return new ApplyExp(primProcedure, expressionArray);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType classType, String string, Expression[] expressionArray) {
        MethodProc[] methodProcArray = invokeStatic.getMethods(classType, string, expressionArray, expressionArray.length, 0, -1, null);
        int n = Invoke.invokeStatic.cacheDefinitelyApplicableMethodCount;
        int n2 = Invoke.invokeStatic.cachePossiblyApplicableMethodCount;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }
}

