/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.uml.architecture.internal.messages;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.emf.ui.providers.labelproviders.DelegatingToEMFLabelProvider;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.TextDocumentTemplate;
import org.eclipse.papyrus.model2doc.integration.uml.architecture.internal.messages.Activator;
import org.eclipse.papyrus.model2doc.integration.uml.architecture.internal.messages.Messages;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCreateDocumentTemplateEditorCommand {
    protected String askDocumentName(String dialogTitle, String proposedName) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), dialogTitle, Messages.AbstractCreateDocumentTemplateEditorCommand_DialogMessage, proposedName, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    protected boolean execute(final DocumentTemplatePrototype documentTemplatePrototype, final EObject semanticContext, final String documentName) {
        Resource res = semanticContext.eResource();
        URI semanticURI = res.getURI();
        if (semanticURI.isPlatformPlugin()) {
            Activator.log.error((Throwable)new UnsupportedOperationException("Documentation for element stored as platform plugin is not yet supported"));
            return false;
        }
        TransactionalEditingDomain domain = this.getEditingDomain(semanticContext);
        if (domain == null) {
            return false;
        }
        domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Create new DocumentTemplate"){

            protected void doExecute() {
                DocumentTemplate template = documentTemplatePrototype.getDocumentTemplate();
                DocumentTemplate newInstance = (DocumentTemplate)EcoreUtil.copy((EObject)template);
                if (newInstance instanceof TextDocumentTemplate) {
                    ((TextDocumentTemplate)newInstance).setMainTitle(AbstractCreateDocumentTemplateEditorCommand.this.getDocumentMainTitle(semanticContext));
                }
                AbstractCreateDocumentTemplateEditorCommand.this.attachToResource(semanticContext, newInstance);
                IDocumentStructureGeneratorConfiguration generator = newInstance.getDocumentStructureGeneratorConfiguration();
                if (generator != null) {
                    generator.setDocumentName(documentName);
                }
                newInstance.setDocumentTemplatePrototype(documentTemplatePrototype);
                newInstance.setGraphicalContext(semanticContext);
                newInstance.setSemanticContext(semanticContext);
                newInstance.setName(documentName);
                AbstractCreateDocumentTemplateEditorCommand.this.openEditor(newInstance);
            }
        });
        return true;
    }

    protected String getDocumentMainTitle(EObject semanticContext) {
        return DelegatingToEMFLabelProvider.INSTANCE.getText((Object)semanticContext);
    }

    protected TransactionalEditingDomain getEditingDomain(EObject modelElement) {
        return TransactionUtil.getEditingDomain((EObject)modelElement);
    }

    protected abstract void attachToResource(EObject var1, DocumentTemplate var2);

    protected abstract void openEditor(DocumentTemplate var1);
}

