/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.editor;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.system.XSimpleMailClient;
import com.sun.star.system.XSimpleMailClientSupplier;
import com.sun.star.system.XSimpleMailMessage;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ooo.connector.BootstrapSocketConnector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.operations.GeneratorConfigurationOperations;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.message.Messages;
import org.eclipse.papyrus.model2doc.odt.internal.util.LibreOfficeInstallationPathUtil;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOService;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOServiceImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ODTEditor {
    private static final String LIBREOFFICE_FILE_PREFIX = "file:///";
    private static final String STANDART_FILE_PREFIX = "file:/";
    private static final String ODT_FILE_EXTENSION = "odt";
    private XComponentLoader officeLoader = null;
    private XTextDocument xTextDocument = null;
    private XDesktop xDesktop = null;
    private IDocumentGeneratorConfiguration configuration;
    private XMultiComponentFactory xMultiComponentFactory = null;
    private XMultiServiceFactory xMultiServiceFactory = null;
    private XComponentContext xComponentContext = null;
    private ODTFileIOService fileIOService = null;

    public ODTEditor(String projectFolder) {
        this.fileIOService = new ODTFileIOServiceImpl();
        this.loadOffice();
    }

    public ODTEditor(IDocumentGeneratorConfiguration generatorConfig) {
        this.configuration = generatorConfig;
        this.loadOffice();
        if (this.officeLoader != null) {
            this.fileIOService = new ODTFileIOServiceImpl();
            String templateURL = GeneratorConfigurationOperations.getTemplateFilePathInLocalPath((IDocumentGeneratorConfiguration)generatorConfig);
            this.createTextDocument(templateURL);
            this.xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        }
    }

    public XTextDocument getXTextDocument() {
        return this.xTextDocument;
    }

    public XMultiComponentFactory getXMultiComponentFactory() {
        return this.xMultiComponentFactory;
    }

    public XMultiServiceFactory getXMultiServiceFactory() {
        return this.xMultiServiceFactory;
    }

    public XComponentContext getXComponentContext() {
        return this.xComponentContext;
    }

    public XPageCursor getPageCursor() {
        XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDocument);
        XController xController = model.getCurrentController();
        XTextViewCursorSupplier supplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
        return (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)supplier.getViewCursor());
    }

    public void openDocument(String documentURL) {
        XComponent xComponent = this.getDocument(documentURL);
        if (xComponent != null) {
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XWindow xWindow = model.getCurrentController().getFrame().getContainerWindow();
            xWindow.setVisible(true);
            xWindow.setFocus();
        }
    }

    public void save(String fileName) {
        this.saveAs(fileName, ODT_FILE_EXTENSION);
    }

    public String saveAs(String fileName, String extension) {
        String exportedDocumentURL = this.saveDocument(fileName, extension);
        this.closeDocument();
        this.closeLibreOffice();
        return exportedDocumentURL;
    }

    public String exportDocument(String fileName, String documentURL, String extension) {
        XComponent xComponent = this.getDocument(documentURL);
        if (xComponent != null) {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            return this.saveAs(fileName, extension);
        }
        return null;
    }

    public String getFormat(String extension) {
        switch (extension) {
            case "odt": {
                return "writer8";
            }
            case "pdf": {
                return "writer_pdf_Export";
            }
        }
        return "writer8";
    }

    public void sendMail(String subject, String documentToAttach) {
        System.out.println("Subject: " + subject + " DocumentURL: " + documentToAttach);
        XSimpleMailClientSupplier xSimpleMailClientSupplier = this.createSimpleMailClientSupplier();
        if (xSimpleMailClientSupplier != null) {
            XSimpleMailClient xSimpleMailClient = xSimpleMailClientSupplier.querySimpleMailClient();
            XSimpleMailMessage mailMessage = xSimpleMailClient.createSimpleMailMessage();
            mailMessage.setSubject(subject);
            if (documentToAttach != null) {
                String[] attachs = new String[]{documentToAttach};
                mailMessage.setAttachement(attachs);
            }
            try {
                xSimpleMailClient.sendSimpleMailMessage(mailMessage, 0);
            }
            catch (IllegalArgumentException | com.sun.star.uno.Exception e) {
                Activator.log.error(e);
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.ODTEditor_SendMail, (String)Messages.ODTEditor_MailClientWasNotFound);
        }
    }

    public void closeDocument(String documentURL) {
        XComponent xComponent = this.getDocument(documentURL);
        if (xComponent != null) {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            this.closeDocument();
            this.closeLibreOffice();
        }
    }

    public XComponent getDocument(String documentURL) {
        XComponent xComponent = null;
        if (this.officeLoader != null) {
            PropertyValue[] props = new PropertyValue[2];
            props[0] = new PropertyValue();
            props[0].Name = "Hidden";
            props[0].Value = true;
            try {
                xComponent = this.officeLoader.loadComponentFromURL(documentURL, "_blank", 0, props);
            }
            catch (IOException | IllegalArgumentException e) {
                Activator.log.error("Unable to get document object from" + documentURL + " : ", e);
            }
        }
        return xComponent;
    }

    private void loadOffice() {
        String oooExeFolder = LibreOfficeInstallationPathUtil.getLibreOfficeInstallationPath();
        if (oooExeFolder == null || oooExeFolder.isEmpty()) {
            Activator.log.warn("The path for the LibreOffice installation is null or empty. We stop the documentation generation.");
        }
        try {
            try {
                this.xComponentContext = BootstrapSocketConnector.bootstrap((String)oooExeFolder);
                this.xMultiComponentFactory = this.xComponentContext.getServiceManager();
                if (this.xMultiComponentFactory != null) {
                    Object oDesktop = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.xComponentContext);
                    this.xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)oDesktop);
                    this.officeLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xDesktop);
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                if (this.officeLoader == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorTitle, (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorMessage);
                    LibreOfficeInstallationPathUtil.eraseLibreOfficeInstallationPath();
                }
            }
        }
        finally {
            if (this.officeLoader == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorTitle, (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorMessage);
                LibreOfficeInstallationPathUtil.eraseLibreOfficeInstallationPath();
            }
        }
    }

    private XTextDocument createTextDocument(String templateURL) {
        try {
            XComponent xComponent = null;
            xComponent = templateURL != null && !templateURL.isEmpty() ? this.createNewDocumentFromTemplate(ODTEditor.convertToLibreOfficeFileURI(templateURL)) : this.createNewDocument();
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XWindow xWindow = model.getCurrentController().getFrame().getContainerWindow();
            xWindow.setVisible(false);
            xWindow.setFocus();
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return this.xTextDocument;
    }

    private XComponent createNewDocument() {
        String sURL = "private:factory/swriter";
        XComponent xComponent = null;
        PropertyValue[] xEmptyArgs = new PropertyValue[]{};
        try {
            xComponent = this.officeLoader.loadComponentFromURL(sURL, "_blank", 0, xEmptyArgs);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return xComponent;
    }

    private XComponent createNewDocumentFromTemplate(String templateURL) {
        XComponent xComponent = null;
        try {
            this.officeLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.officeLoader);
            PropertyValue[] props = new PropertyValue[2];
            props[0] = new PropertyValue();
            props[0].Name = "Hidden";
            props[0].Value = true;
            props[1] = new PropertyValue();
            props[1].Name = "AsTemplate";
            props[1].Value = true;
            xComponent = this.officeLoader.loadComponentFromURL(ODTEditor.convertToLibreOfficeFileURI(templateURL), "_blank", 0, props);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        if (xComponent == null) {
            xComponent = this.createNewDocument();
        }
        return xComponent;
    }

    private XSimpleMailClientSupplier createSimpleMailClientSupplier() {
        XSimpleMailClientSupplier xSimpleMailClientSupplier = null;
        Object oSimpleMailClientSupplier = null;
        try {
            oSimpleMailClientSupplier = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.system.SimpleSystemMail", this.xComponentContext);
            if (oSimpleMailClientSupplier != null) {
                xSimpleMailClientSupplier = (XSimpleMailClientSupplier)UnoRuntime.queryInterface(XSimpleMailClientSupplier.class, (Object)oSimpleMailClientSupplier);
            } else {
                oSimpleMailClientSupplier = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.system.SimpleCommandMail", this.xComponentContext);
                if (oSimpleMailClientSupplier != null) {
                    xSimpleMailClientSupplier = (XSimpleMailClientSupplier)UnoRuntime.queryInterface(XSimpleMailClientSupplier.class, (Object)oSimpleMailClientSupplier);
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            Activator.log.error((Throwable)e);
        }
        return xSimpleMailClientSupplier;
    }

    private String saveDocument(String fileName, String extension) {
        XStorable store = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
        String saveFileURL = ODTEditor.convertToLibreOfficeFileURI(GeneratorConfigurationOperations.getDocumentFileLocalPath((IDocumentGeneratorConfiguration)this.configuration, (String)ODT_FILE_EXTENSION));
        if (saveFileURL == null) {
            return null;
        }
        PropertyValue[] storeProps = new PropertyValue[2];
        storeProps[0] = new PropertyValue();
        storeProps[0].Name = "Overwrite";
        storeProps[0].Value = true;
        storeProps[1] = new PropertyValue();
        storeProps[1].Name = "FilterName";
        storeProps[1].Value = this.getFormat(extension);
        try {
            store.storeToURL(saveFileURL, storeProps);
            Activator.log.info("Saving document: " + saveFileURL);
        }
        catch (IOException e) {
            Activator.log.error(String.valueOf(saveFileURL) + " have not been saved: ", (Throwable)e);
        }
        return saveFileURL;
    }

    private void closeDocument() {
        XCloseable closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDocument);
        if (closeable == null) {
            return;
        }
        try {
            closeable.close(false);
        }
        catch (DisposedException e) {
            Activator.log.warn("Document close failed since LibreOffice link disposed.");
        }
        catch (CloseVetoException e) {
            Activator.log.error("Close was vetoed: ", (Throwable)e);
        }
    }

    private void closeLibreOffice() {
        if (this.xDesktop == null) {
            return;
        }
        try {
            boolean isOfficeTerminated = this.xDesktop.terminate();
            if (isOfficeTerminated) {
                Activator.log.info("LibreOffice terminated.");
            } else {
                Activator.log.warn("LibreOffice failed to terminate.");
            }
        }
        catch (DisposedException e) {
            Activator.log.warn("LibreOffice link disposed.");
        }
        catch (Exception e) {
            Activator.log.error("Termination exception: ", (Throwable)e);
        }
    }

    private static final String convertToLibreOfficeFileURI(String fileURL) {
        String newFileURL = fileURL;
        if (fileURL.startsWith(STANDART_FILE_PREFIX) && !newFileURL.startsWith(LIBREOFFICE_FILE_PREFIX)) {
            newFileURL = newFileURL.replaceFirst(STANDART_FILE_PREFIX, LIBREOFFICE_FILE_PREFIX);
        }
        return newFileURL;
    }
}

