/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceRelatedViewer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class ValuesViewer
extends TableViewer
implements IComparisonSideViewer,
IDifferenceRelatedViewer {
    private final boolean _sideIsLeft;
    private boolean _showAllValues;

    public ValuesViewer(Composite parent_p, boolean sideIsLeft_p) {
        this(parent_p, 770, sideIsLeft_p);
    }

    public ValuesViewer(Composite parent_p, int style_p, boolean sideIsLeft_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._sideIsLeft = sideIsLeft_p;
        this._showAllValues = false;
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setMultilineSupport(this.getControl());
    }

    public EObject getElementForValue(Object viewerValueElement_p) {
        Object result = viewerValueElement_p instanceof IReferenceValuePresence ? (EObject)this.getValueToRepresent((IValuePresence)viewerValueElement_p) : (viewerValueElement_p instanceof IMatch ? ((IMatch)viewerValueElement_p).get(this.getSideRole()) : (viewerValueElement_p instanceof EObject && !(viewerValueElement_p instanceof IDifference) ? (EObject)viewerValueElement_p : null));
        return result;
    }

    public ValuesInput getInput() {
        return (ValuesInput)super.getInput();
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getContext().getResourceManager();
    }

    protected Role getSideRole() {
        return this.getInput() == null ? null : this.getInput().getContext().getRoleForSide(this.isLeftSide());
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)super.getSelection();
    }

    protected Object getValueToRepresent(IValuePresence presence_p) {
        Object result = presence_p.getFeature() instanceof EAttribute ? presence_p.getValue() : (this.isOwnership(this.getInput().getMatchAndFeature()) ? ((IReferenceValuePresence)presence_p).getElementMatch().get(presence_p.getPresenceRole()) : ((IReferenceValuePresence)presence_p).getValue().get(presence_p.getPresenceRole()));
        return result;
    }

    protected boolean isContainment(Object object_p) {
        boolean result = false;
        if (object_p instanceof MatchAndFeature) {
            EStructuralFeature feature = ((MatchAndFeature)object_p).getFeature();
            result = feature instanceof EReference && ((EReference)feature).isContainment();
        }
        return result;
    }

    public boolean isDifferenceAgnostic() {
        return this._showAllValues;
    }

    public boolean isLeftSide() {
        return this._sideIsLeft;
    }

    protected boolean isOwnership(Object object_p) {
        boolean result = false;
        Object object = object_p;
        if (object instanceof ValuesInput) {
            object = ((ValuesInput)object).getMatchAndFeature();
        }
        if (object instanceof MatchAndFeature) {
            EStructuralFeature feature = ((MatchAndFeature)object).getFeature();
            result = EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature().equals(feature);
        }
        return result;
    }

    public void setDifferenceAgnostic(boolean agnostic_p) {
        if (agnostic_p != this.isDifferenceAgnostic()) {
            this._showAllValues = agnostic_p;
            this.refresh(false);
        }
    }

    protected void setMultilineSupport(Control control_p) {
        control_p.addListener(41, new Listener(){

            public void handleEvent(Event event_p) {
                TableItem item = (TableItem)event_p.item;
                if (item != null) {
                    String text = item.getText(event_p.index);
                    Point size = event_p.gc.textExtent(text);
                    event_p.width = size.x + item.getImageBounds((int)0).width + 4;
                    event_p.height = size.y;
                }
            }
        });
        control_p.addListener(40, new Listener(){

            public void handleEvent(Event event_p) {
                event_p.detail &= 0xFFFFFFEF;
            }
        });
        control_p.addListener(42, new Listener(){

            public void handleEvent(Event event_p) {
                TableItem item = (TableItem)event_p.item;
                if (item != null) {
                    String text = item.getText(event_p.index);
                    Point size = text != null ? event_p.gc.textExtent(text) : new Point(0, 0);
                    event_p.width = size.x + 8;
                    event_p.height = Math.max(event_p.height, size.y);
                    int offset = event_p.x;
                    Image image = item.getImage();
                    if (image != null) {
                        event_p.gc.drawImage(image, offset, event_p.y);
                    }
                    if (text != null) {
                        event_p.gc.drawText(text, offset + item.getImageBounds((int)0).width + 4, event_p.y, true);
                    }
                }
            }
        });
    }

    protected boolean showAsDifference(Object element_p) {
        return element_p instanceof IValuePresence && !((IValuePresence)element_p).isMerged() && !this.getInput().getContext().shouldBeIgnored((IDifference)element_p);
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        public Object[] getElements(Object inputElement_p) {
            ArrayList<Object> result;
            block7: {
                MatchAndFeature input;
                block8: {
                    block9: {
                        block6: {
                            input = ((ValuesInput)inputElement_p).getMatchAndFeature();
                            result = new ArrayList<Object>();
                            if (!ValuesViewer.this.isOwnership(input)) break block6;
                            IReferenceValuePresence ownership = input.getMatch().getOwnershipDifference(ValuesViewer.this.getSideRole());
                            if (ownership == null) break block7;
                            result.add(ownership);
                            break block7;
                        }
                        IValuePresence orderDifference = input.getMatch().getOrderDifference(input.getFeature(), ValuesViewer.this.getSideRole());
                        if (orderDifference != null) {
                            result.add(orderDifference);
                        }
                        if (ValuesViewer.this.isContainment(input)) break block7;
                        if (!ValuesViewer.this.isDifferenceAgnostic()) break block8;
                        if (!(input.getFeature() instanceof EAttribute)) break block9;
                        EAttribute attribute = (EAttribute)input.getFeature();
                        EComparison comparison = input.getMatch().getMapping().getComparison();
                        EMatch match = input.getMatch();
                        EObject source = match.get(ValuesViewer.this.getSideRole());
                        if (source == null) break block7;
                        List values = comparison.getScope(ValuesViewer.this.getSideRole()).get(source, attribute);
                        for (Object value : values) {
                            IAttributeValuePresence presence = match.getAttributeValueDifference(attribute, value);
                            if (presence != null) {
                                result.add(presence);
                                continue;
                            }
                            result.add(value);
                        }
                        break block7;
                    }
                    EReference reference = (EReference)input.getFeature();
                    EComparison comparison = input.getMatch().getMapping().getComparison();
                    EMatch match = input.getMatch();
                    EObject source = match.get(ValuesViewer.this.getSideRole());
                    if (source == null) break block7;
                    List values = comparison.getScope(ValuesViewer.this.getSideRole()).get(source, reference);
                    for (EObject value : values) {
                        IMatch valueMatch = comparison.getMapping().getMatchFor(value, ValuesViewer.this.getSideRole());
                        if (valueMatch == null) continue;
                        IReferenceValuePresence presence = match.getReferenceValueDifference(reference, valueMatch);
                        if (presence != null) {
                            result.add(presence);
                            continue;
                        }
                        result.add(valueMatch);
                    }
                    break block7;
                }
                Collection bothSides = input.getFeature() instanceof EAttribute ? input.getMatch().getAttributeDifferences((EAttribute)input.getFeature()) : input.getMatch().getReferenceDifferences((EReference)input.getFeature());
                for (IValuePresence presence : bothSides) {
                    if ((presence.isOrder() || presence.getPresenceRole() != ValuesViewer.this.getSideRole() || presence.getMergeDestination() == ValuesViewer.this.getSideRole()) && (presence.isOrder() || presence.getPresenceRole() != ValuesViewer.this.getSideRole().opposite() || presence.getMergeDestination() != ValuesViewer.this.getSideRole())) continue;
                    result.add(presence);
                }
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider {
        protected LabelProvider() {
        }

        private String formatCrossReferenceValue(String initialLabel_p, EObject value_p) {
            EObject container;
            String containerLabel;
            StringBuilder builder = new StringBuilder();
            if (initialLabel_p != null) {
                builder.append(initialLabel_p);
            }
            String string = containerLabel = (container = value_p.eContainer()) == null ? null : this.getDelegate().getText((Object)container);
            if (containerLabel != null) {
                builder.append(' ');
                builder.append(String.format(Messages.ValuesViewer_ContainerLabel, containerLabel));
            }
            return builder.toString();
        }

        private String formatOwnershipValue(String ownerLabel_p, IReferenceValuePresence presence_p) {
            EReference containment;
            StringBuilder builder = new StringBuilder();
            if (ownerLabel_p != null) {
                builder.append(ownerLabel_p);
            }
            if ((containment = presence_p.getFeature()) != null) {
                builder.append(' ');
                builder.append(String.format(Messages.ValuesViewer_FeatureLabel, containment.getName()));
            }
            return builder.toString();
        }

        public Font getFont(Object element_p) {
            Font result = ValuesViewer.this.getControl().getFont();
            if (ValuesViewer.this.showAsDifference(element_p)) {
                result = UIUtil.getBold(result);
            }
            return result;
        }

        public Color getForeground(Object element_p) {
            EMFDiffMergeUIPlugin.DifferenceColorKind result = ValuesViewer.this.showAsDifference(element_p) ? (ValuesViewer.this.getSideRole() == ValuesViewer.this.getInput().getContext().getDrivingRole() ? EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT : EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT) : EMFDiffMergeUIPlugin.DifferenceColorKind.DEFAULT;
            return ValuesViewer.this.getInput().getContext().getDifferenceColor(result);
        }

        public Image getImage(Object element_p) {
            Image result;
            if (element_p instanceof IValuePresence) {
                IValuePresence presence = (IValuePresence)element_p;
                if (presence.isOrder()) {
                    result = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SORT);
                } else {
                    Object toRepresent = ValuesViewer.this.getValueToRepresent(presence);
                    result = this.getDelegate().getImage(toRepresent);
                }
                if (ValuesViewer.this.getInput().getContext().usesCustomIcons()) {
                    DifferenceKind kind = ValuesViewer.this.isOwnership(ValuesViewer.this.getInput().getMatchAndFeature()) && ValuesViewer.this.getInput().getContext().getReferenceRole() == null ? DifferenceKind.MODIFIED : ValuesViewer.this.getInput().getContext().getDifferenceKind((IDifference)presence);
                    result = ValuesViewer.this.getResourceManager().adaptImage(result, kind);
                }
            } else {
                result = element_p instanceof IMatch ? this.getDelegate().getImage((Object)((IMatch)element_p).get(ValuesViewer.this.getSideRole())) : this.getDelegate().getImage(element_p);
            }
            return result;
        }

        public String getText(Object element_p) {
            String result;
            if (element_p instanceof IValuePresence) {
                IValuePresence presence = (IValuePresence)element_p;
                if (presence.isOrder()) {
                    result = Messages.ValuesViewer_OrderLabel;
                } else {
                    Object toRepresent = ValuesViewer.this.getValueToRepresent(presence);
                    result = this.getDelegate().getText(toRepresent);
                    if (ValuesViewer.this.isOwnership(ValuesViewer.this.getInput())) {
                        result = this.formatOwnershipValue(result, (IReferenceValuePresence)presence);
                    } else if (toRepresent instanceof EObject) {
                        result = this.formatCrossReferenceValue(result, (EObject)toRepresent);
                    }
                }
                if (ValuesViewer.this.getInput().getContext().usesCustomLabels()) {
                    DifferenceKind kind = ValuesViewer.this.getInput().getContext().getDifferenceKind((IDifference)presence);
                    String prefix = EMFDiffMergeUIPlugin.getDefault().getDifferencePrefix(kind);
                    result = String.valueOf(prefix) + result;
                }
            } else {
                result = element_p instanceof IMatch ? this.getDelegate().getText((Object)((IMatch)element_p).get(ValuesViewer.this.getSideRole())) : this.getDelegate().getText(element_p);
            }
            return result;
        }
    }

    public static class ValuesInput {
        private final EMFDiffNode _context;
        private final MatchAndFeature _matchAndFeature;

        public ValuesInput(EMFDiffNode context_p, MatchAndFeature matchAndFeature_p) {
            this._context = context_p;
            this._matchAndFeature = matchAndFeature_p;
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof ValuesInput) {
                ValuesInput peer = (ValuesInput)object_p;
                result = this._context == peer.getContext() && this._matchAndFeature.getFeature() == peer.getMatchAndFeature().getFeature() && this._matchAndFeature.getMatch().equals((Object)peer.getMatchAndFeature().getMatch());
            }
            return result;
        }

        public EMFDiffNode getContext() {
            return this._context;
        }

        public MatchAndFeature getMatchAndFeature() {
            return this._matchAndFeature;
        }

        public int hashCode() {
            return this._context.hashCode() + this._matchAndFeature.getMatch().hashCode() + this._matchAndFeature.getFeature().hashCode();
        }
    }
}

