/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractLayoutReuseOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations.SiriusFilteredGraphicalUpdateOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.LayoutUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.EdgeLayout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.Layout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.NodeLayout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SiriusLayoutReuseOperation
extends SiriusFilteredGraphicalUpdateOperation {
    protected final PinHelper _pinHelper = new PinHelper();
    private final Map<Object, ComposedImage.Point> _initialElementsLocationsMap;
    private final Map<Object, Object> _initialElementsContainersMap;
    private InnerLayoutReuseOperation _innerLayoutReuseOperation;
    protected Collection<DDiagramElement> _roots;

    public SiriusLayoutReuseOperation(Object diagram_p, IPatternInstance instance_p, Map<Object, ComposedImage.Point> initialElementsLocationsMap_p, Map<Object, Object> elementsContainersMap_p, int vx_p, int vy_p, boolean updateLayout_p, boolean updateStyle_p, Object sourceContext_p) {
        super(AbstractLayoutReuseOperation.getName(), diagram_p, instance_p, true, sourceContext_p);
        this._initialElementsLocationsMap = initialElementsLocationsMap_p;
        this._initialElementsContainersMap = elementsContainersMap_p;
        this._innerGraphicalOperation = new InnerLayoutReuseOperation(instance_p, updateLayout_p, updateStyle_p);
        this._innerLayoutReuseOperation = (InnerLayoutReuseOperation)this._innerGraphicalOperation;
        this.setVector(vx_p, vy_p);
    }

    public SiriusLayoutReuseOperation(Collection<Object> diagramElements_p, IPatternInstance instance_p, Map<Object, ComposedImage.Point> initialElementsLocationsMap_p, Map<Object, Object> elementsContainersMap_p, int vx_p, int vy_p, boolean updateLayout_p, boolean updateStyle_p, Object sourceContext_p) {
        super(AbstractLayoutReuseOperation.getName(), diagramElements_p, false, sourceContext_p);
        this._initialElementsLocationsMap = initialElementsLocationsMap_p;
        this._initialElementsContainersMap = elementsContainersMap_p;
        this._innerGraphicalOperation = new InnerLayoutReuseOperation(instance_p, updateLayout_p, updateStyle_p);
        this._innerLayoutReuseOperation = (InnerLayoutReuseOperation)this._innerGraphicalOperation;
        this.setVector(vx_p, vy_p);
    }

    public void setVector(int vx_p, int vy_p) {
        this._innerLayoutReuseOperation.setVectorX(vx_p);
        this._innerLayoutReuseOperation.setVectorY(vy_p);
    }

    protected void update(Object decorator_p, boolean isMerged) {
        this._innerLayoutReuseOperation.update(decorator_p, isMerged);
    }

    private boolean isMerged(EObject target_p) {
        DSemanticDecorator decorator;
        List mergedElements = LocationsUtil.getMergeTargets((IPatternApplication)this._innerLayoutReuseOperation.getInstance());
        return target_p instanceof DSemanticDecorator && mergedElements.contains((decorator = (DSemanticDecorator)target_p).getTarget());
    }

    @Override
    public Collection<Object> run() {
        FOrderedSet result = new FOrderedSet();
        boolean updated = false;
        Collection<DDiagramElement> toUpdate = this.getDiagramElementsToUpdate();
        this._roots = this.getHigherHierachicalElements(toUpdate);
        List<DDiagramElement> mergedElements = this.getMergedElementsFromList(toUpdate);
        DDiagramElement referenceElement = null;
        if (!this._roots.isEmpty()) {
            referenceElement = this.getReferenceElementFromList(this._roots, mergedElements);
        } else {
            assert (!toUpdate.isEmpty());
            if (toUpdate.iterator().hasNext()) {
                referenceElement = toUpdate.iterator().next();
            }
        }
        if (this._diagram instanceof DSemanticDecorator && (updated = this.checkUpdate(this._diagram, false))) {
            result.add(this._diagram);
        }
        for (DDiagramElement diagramElement : toUpdate) {
            updated = this.checkUpdate(diagramElement, this.isMerged((EObject)diagramElement));
            if (!updated) continue;
            result.add(diagramElement);
        }
        ComposedImage.Point translationVector = new ComposedImage.Point();
        if (this.isMerged((EObject)referenceElement) && !this._initialElementsLocationsMap.isEmpty()) {
            if (this._diagramUtil != null) {
                ComposedImage.Point initialRefElemLocation = this._initialElementsLocationsMap.get(referenceElement);
                ComposedImage.Point currentRefElemLocation = this._diagramUtil.getLocation((Object)referenceElement);
                if (initialRefElemLocation != null && currentRefElemLocation != null) {
                    translationVector.x = initialRefElemLocation.x - currentRefElemLocation.x;
                    translationVector.y = initialRefElemLocation.y - currentRefElemLocation.y;
                }
            }
            ArrayList<DDiagramElement> finalPosElementsList = new ArrayList<DDiagramElement>();
            for (DDiagramElement diagramElement : mergedElements) {
                if (diagramElement.eContainer() == this._initialElementsContainersMap.get(diagramElement)) {
                    LayoutUtil.setLocation(diagramElement, this._initialElementsLocationsMap.get(diagramElement));
                    continue;
                }
                ComposedImage.Point point = new ComposedImage.Point();
                point.x = 10;
                point.y = 10;
                LayoutUtil.setLocation(diagramElement, point);
                if (!(diagramElement.eContainer() instanceof DDiagramElement)) continue;
                LayoutUtil.setLocation((DDiagramElement)diagramElement.eContainer(), this._initialElementsLocationsMap.get(diagramElement));
                finalPosElementsList.add((DDiagramElement)diagramElement.eContainer());
            }
            for (DDiagramElement diagramElement : toUpdate) {
                if (LayoutUtil.isInstanceParticipant(diagramElement, this._innerLayoutReuseOperation.getInstance().getElements())) {
                    ComposedImage.Point newPosition;
                    if (this.isMerged((EObject)diagramElement) || finalPosElementsList.contains(diagramElement) || !this._roots.contains(diagramElement)) continue;
                    DDiagramElement localRefElement = LayoutUtil.getLocalReferenceLocation(diagramElement, mergedElements);
                    if (localRefElement == null) {
                        newPosition = this._diagramUtil.getLocation((Object)diagramElement);
                        newPosition.x += translationVector.x;
                        newPosition.y += translationVector.y;
                        LayoutUtil.setLocation(diagramElement, newPosition);
                        continue;
                    }
                    newPosition = this._diagramUtil.getLocation((Object)diagramElement);
                    ComposedImage.Point initialLocalRefElemLocation = this._initialElementsLocationsMap.get(localRefElement);
                    ComposedImage.Point currentLocalRefElemLocation = this._diagramUtil.getLocation((Object)localRefElement);
                    if (initialLocalRefElemLocation != null && currentLocalRefElemLocation != null) {
                        translationVector = new ComposedImage.Point();
                        translationVector.x = initialLocalRefElemLocation.x - currentLocalRefElemLocation.x;
                        translationVector.y = initialLocalRefElemLocation.y - currentLocalRefElemLocation.y;
                    }
                    newPosition.x += translationVector.x;
                    newPosition.y += translationVector.y;
                    LayoutUtil.setLocation(diagramElement, newPosition);
                    continue;
                }
                if (!(diagramElement instanceof AbstractDNode)) continue;
                AbstractDNode dnode = (AbstractDNode)diagramElement;
                LayoutUtil.setLocation((DDiagramElement)dnode, this._initialElementsLocationsMap.get(dnode));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    private List<DDiagramElement> getMergedElementsFromList(Collection<DDiagramElement> list_p) {
        ArrayList<DDiagramElement> mergedElements = new ArrayList<DDiagramElement>();
        for (DDiagramElement diagramElement : list_p) {
            if (!this.isMerged((EObject)diagramElement)) continue;
            mergedElements.add(diagramElement);
        }
        return mergedElements;
    }

    private DDiagramElement getReferenceElementFromList(Collection<DDiagramElement> roots_p, Collection<DDiagramElement> mergedElements_p) {
        DDiagramElement result = null;
        ArrayList equalPriorityElements = new ArrayList();
        if (!mergedElements_p.isEmpty()) {
            ArrayList<DDiagramElement> mergedNodes = new ArrayList<DDiagramElement>();
            for (DDiagramElement mergedElement : mergedElements_p) {
                if (!(mergedElement instanceof AbstractDNode)) continue;
                mergedNodes.add(mergedElement);
            }
            if (!mergedNodes.isEmpty()) {
                equalPriorityElements.addAll(mergedNodes);
            }
        } else {
            ArrayList<DDiagramElement> nonMergedNodes = new ArrayList<DDiagramElement>();
            for (DDiagramElement nonMergedElement : roots_p) {
                if (!(nonMergedElement instanceof AbstractDNode)) continue;
                nonMergedNodes.add(nonMergedElement);
            }
            if (!nonMergedNodes.isEmpty()) {
                equalPriorityElements.addAll(nonMergedNodes);
            } else {
                equalPriorityElements.addAll(roots_p);
            }
        }
        result = (DDiagramElement)equalPriorityElements.toArray()[0];
        return result;
    }

    private Collection<DDiagramElement> getHigherHierachicalElements(Collection<DDiagramElement> inputList_p) {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        for (DDiagramElement current : inputList_p) {
            if (!LayoutUtil.isHigherLevelDiagramElementInList(current, inputList_p)) continue;
            result.add(current);
        }
        return result;
    }

    private Collection<DDiagramElement> getDiagramElementsToUpdate() {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        List initial = this._diagramElements != null ? this.getAllDiagramElements(this._diagramElements) : this._diagramUtil.getDiagramElements(this._diagram);
        for (Object current : initial) {
            if (!(current instanceof DDiagramElement) || !LayoutUtil.isInstanceParticipant((DDiagramElement)current, this._innerLayoutReuseOperation.getInstance().getElements())) continue;
            result.add((DDiagramElement)current);
        }
        return result;
    }

    protected class InnerLayoutReuseOperation
    extends AbstractLayoutReuseOperation {
        public InnerLayoutReuseOperation(IPatternInstance instance_p, boolean updateLayout_p, boolean updateStyle_p) {
            super(instance_p, updateLayout_p, updateStyle_p);
        }

        public void update(Object object_p, boolean isMerged) {
            if (object_p instanceof DSemanticDecorator) {
                TemplatePattern pattern;
                DSemanticDecorator decorator = (DSemanticDecorator)object_p;
                if (this.getInstance().getPattern() instanceof TemplatePattern && this.getInstance().getPatternData() instanceof TemplatePatternData && !(pattern = (TemplatePattern)this.getInstance().getPattern()).getLayoutData().isEmpty()) {
                    TemplatePatternData data = (TemplatePatternData)this.getInstance().getPatternData();
                    EObject semanticElement = SiriusLayersUtil.downViewpointToSemantic(decorator);
                    if (semanticElement != null) {
                        EObject templateElement = data.getCounterpart(semanticElement, false);
                        Layout layout = (Layout)pattern.getLayoutData().get((Object)templateElement);
                        if (layout instanceof NodeLayout) {
                            NodeLayout nodeLayout = (NodeLayout)layout;
                            List<View> views = SiriusLayersUtil.upViewpointToGmf(decorator);
                            if (!views.isEmpty() && views.get(0) instanceof Node) {
                                Node node = (Node)views.get(0);
                                LayoutConstraint constraint = node.getLayoutConstraint();
                                if (this.isUpdateStyle()) {
                                    if (nodeLayout.getFontStyle() != null) {
                                        LayoutUtil.applyAbstractDNodePatternFontStyle(nodeLayout.getFontStyle(), node);
                                    }
                                    if (nodeLayout.getOwnedStyle() != null) {
                                        LayoutUtil.applyNodePatternStyleToDNode(nodeLayout.getOwnedStyle(), node);
                                    }
                                }
                                if (this.isUpdateLayout() && constraint instanceof Bounds) {
                                    Bounds bounds = (Bounds)constraint;
                                    LayoutUtil.nodeLayoutToBounds(nodeLayout, bounds);
                                    if (SiriusLayoutReuseOperation.this._roots.contains(decorator)) {
                                        LayoutUtil.applyVector((Location)bounds, this.getVectorX(), this.getVectorY());
                                    } else {
                                        LayoutUtil.applyVector((Location)bounds, 0, 0);
                                    }
                                    if (decorator instanceof DDiagramElement) {
                                        SiriusLayoutReuseOperation.this._pinHelper.markAsPinned((DDiagramElement)decorator);
                                    }
                                }
                            }
                        } else if (layout instanceof EdgeLayout) {
                            EdgeLayout edgeLayout = (EdgeLayout)layout;
                            List<View> views = SiriusLayersUtil.upViewpointToGmf(decorator);
                            if (!views.isEmpty() && views.get(0) instanceof Edge) {
                                Edge edge = (Edge)views.get(0);
                                LayoutUtil.applyEdgeLayout(edge, edgeLayout);
                                if (this.isUpdateStyle()) {
                                    LayoutUtil.applyEdgeStyle(edge, edgeLayout);
                                }
                                if (decorator instanceof DDiagramElement) {
                                    SiriusLayoutReuseOperation.this._pinHelper.markAsPinned((DDiagramElement)decorator);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

