/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.diffuidata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.generic.api.IMapping;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementRelativePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.DiffuidataPackage;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;

public class ComparisonSelectionImpl
extends EObjectImpl
implements ComparisonSelection {
    protected static final EMFDiffNode DIFF_NODE_EDEFAULT = null;
    protected EMFDiffNode diffNode = DIFF_NODE_EDEFAULT;
    protected EList<IMatch<?>> selectedMatches;
    protected EList<IDifference<?>> _differences;
    protected EList<Object> _concernedElements;
    protected Role _preferredSide;
    protected MatchAndFeature selectedMatchAndFeature;
    protected EList<IMatch<?>> selectedTreePath;
    protected EList<IValuePresence<?>> selectedValuePresences;

    protected ComparisonSelectionImpl() {
    }

    public ComparisonSelectionImpl(Object selected_p, Role preferredSide_p, EMFDiffNode diffNode_p) {
        Collection collection;
        this._preferredSide = preferredSide_p;
        this.diffNode = diffNode_p;
        if (selected_p instanceof IMatch) {
            this.getSelectedMatches().add((Object)((IMatch)selected_p));
        } else if (selected_p instanceof MatchAndFeature) {
            this.selectedMatchAndFeature = (MatchAndFeature)selected_p;
        } else if (selected_p instanceof TreePath) {
            TreePath path = (TreePath)selected_p;
            int i = 0;
            while (i < path.getSegmentCount()) {
                this.getSelectedTreePath().add((Object)((IMatch)path.getSegment(i)));
                ++i;
            }
        } else if (selected_p instanceof IValuePresence) {
            this.getSelectedValuePresences().add((Object)((IValuePresence)selected_p));
        } else if (selected_p instanceof Collection && !(collection = (Collection)selected_p).isEmpty()) {
            ArrayList<IMatch> matches = new ArrayList<IMatch>();
            ArrayList<IValuePresence> presences = new ArrayList<IValuePresence>();
            for (Object current : collection) {
                if (current instanceof IValuePresence) {
                    presences.add((IValuePresence)current);
                    continue;
                }
                if (!(current instanceof IMatch)) continue;
                matches.add((IMatch)current);
            }
            if (!presences.isEmpty()) {
                this.getSelectedValuePresences().addAll(presences);
            } else {
                this.getSelectedMatches().addAll(matches);
            }
        }
    }

    protected EClass eStaticClass() {
        return DiffuidataPackage.Literals.COMPARISON_SELECTION;
    }

    @Override
    public EMFDiffNode getDiffNode() {
        return this.diffNode;
    }

    @Override
    public EList<IMatch<?>> getSelectedMatches() {
        if (this.selectedMatches == null) {
            this.selectedMatches = new EObjectResolvingEList(IMatch.class, (InternalEObject)this, 1);
        }
        return this.selectedMatches;
    }

    @Override
    public MatchAndFeature getSelectedMatchAndFeature() {
        return this.selectedMatchAndFeature;
    }

    public NotificationChain basicSetSelectedMatchAndFeature(MatchAndFeature newSelectedMatchAndFeature, NotificationChain msgs_p) {
        NotificationChain msgs = msgs_p;
        MatchAndFeature oldSelectedMatchAndFeature = this.selectedMatchAndFeature;
        this.selectedMatchAndFeature = newSelectedMatchAndFeature;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSelectedMatchAndFeature, (Object)newSelectedMatchAndFeature);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public EList<IMatch<?>> getSelectedTreePath() {
        if (this.selectedTreePath == null) {
            this.selectedTreePath = new EObjectResolvingEList(IMatch.class, (InternalEObject)this, 3);
        }
        return this.selectedTreePath;
    }

    @Override
    public EList<IValuePresence<?>> getSelectedValuePresences() {
        if (this.selectedValuePresences == null) {
            this.selectedValuePresences = new EObjectResolvingEList(IValuePresence.class, (InternalEObject)this, 4);
        }
        return this.selectedValuePresences;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetSelectedMatchAndFeature(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDiffNode();
            }
            case 1: {
                return this.getSelectedMatches();
            }
            case 2: {
                return this.getSelectedMatchAndFeature();
            }
            case 3: {
                return this.getSelectedTreePath();
            }
            case 4: {
                return this.getSelectedValuePresences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DIFF_NODE_EDEFAULT == null ? this.diffNode != null : !DIFF_NODE_EDEFAULT.equals(this.diffNode);
            }
            case 1: {
                return this.selectedMatches != null && !this.selectedMatches.isEmpty();
            }
            case 2: {
                return this.selectedMatchAndFeature != null;
            }
            case 3: {
                return this.selectedTreePath != null && !this.selectedTreePath.isEmpty();
            }
            case 4: {
                return this.selectedValuePresences != null && !this.selectedValuePresences.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (diffNode: ");
        result.append(this.diffNode);
        result.append(')');
        return result.toString();
    }

    @Override
    public EList<IDifference<?>> asDifferencesToMerge() {
        if (this._differences == null) {
            this._differences = this.getDifferencesToMerge();
        }
        return ECollections.unmodifiableEList(this._differences);
    }

    @Override
    public Object asFeature() {
        Object result = null;
        if (this.getSelectedMatchAndFeature() != null) {
            result = this.getSelectedMatchAndFeature().getFeature();
        } else {
            IValuePresence<?> presence = this.asValuePresence();
            if (presence != null) {
                result = this.representAsOwnership((IMergeableDifference<?>)presence) ? EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature() : presence.getFeature();
            }
        }
        return result;
    }

    @Override
    public MatchAndFeature asMatchAndFeature() {
        return this.selectedMatchAndFeature;
    }

    @Override
    public IMatch<?> asMatch() {
        IMatch result = null;
        if (!this.getSelectedMatches().isEmpty()) {
            result = (IMatch)this.getSelectedMatches().get(0);
        } else if (!this.getSelectedTreePath().isEmpty()) {
            result = (IMatch)this.getSelectedTreePath().get(this.getSelectedTreePath().size() - 1);
        } else if (this.getSelectedMatchAndFeature() != null) {
            result = this.getSelectedMatchAndFeature().getMatch();
        } else if (!this.getSelectedValuePresences().isEmpty()) {
            IValuePresence<?> presence = this.asValuePresence();
            result = this.representAsOwnership((IMergeableDifference<?>)presence) ? ((IReferenceValuePresence)presence).getValueMatch() : presence.getElementMatch();
        }
        return result;
    }

    @Override
    public EList<IMatch<?>> asMatches() {
        FOrderedSet result = ECollections.emptyEList();
        if (!this.getSelectedMatches().isEmpty()) {
            result = this.getSelectedMatches();
        } else if (!this.getSelectedValuePresences().isEmpty()) {
            result = new FOrderedSet();
            for (IValuePresence valuePresence : this.getSelectedValuePresences()) {
                IMatch match = valuePresence.getElementMatch();
                if (match == null) continue;
                result.add((Object)match);
            }
        } else if (this.getSelectedMatchAndFeature() != null || this.getSelectedTreePath() != null) {
            result = new BasicEList(1);
            IMatch<?> match = this.asMatch();
            if (match != null) {
                result.add(match);
            }
        }
        return ECollections.unmodifiableEList(result);
    }

    @Override
    public TreePath asMatchPath() {
        TreePath result = null;
        if (!this.getSelectedTreePath().isEmpty()) {
            result = new TreePath(this.getSelectedTreePath().toArray());
        }
        return result;
    }

    @Override
    public EList<IValuePresence<?>> asValuePresences() {
        return this.getSelectedValuePresences();
    }

    @Override
    public IValuePresence<?> asValuePresence() {
        IValuePresence result = null;
        if (!this.getSelectedValuePresences().isEmpty()) {
            result = (IValuePresence)this.getSelectedValuePresences().get(0);
        }
        return result;
    }

    @Override
    public void dispose() {
        if (this._concernedElements != null) {
            this._concernedElements.clear();
        }
        if (this._differences != null) {
            this._differences.clear();
        }
        this.diffNode = null;
        this.selectedMatchAndFeature = null;
        if (this.selectedMatches != null) {
            this.selectedMatches.clear();
        }
        if (this.selectedTreePath != null) {
            this.selectedTreePath.clear();
        }
        if (this.selectedValuePresences != null) {
            this.selectedValuePresences.clear();
        }
    }

    protected EList<Object> getConcernedElements() {
        FOrderedSet result;
        block4: {
            Object element;
            EList<IMatch<?>> matches;
            block3: {
                result = new FOrderedSet();
                matches = this.asMatches();
                if (!matches.isEmpty()) break block3;
                for (IDifference difference : this.asDifferencesToMerge()) {
                    IElementRelativePresence elementDifference;
                    IMatch match;
                    if (!(difference instanceof IElementRelativePresence) || (match = (elementDifference = (IElementRelativePresence)difference).getElementMatch()) == null) continue;
                    Object element2 = match.get(elementDifference.getPresenceRole());
                    result.add(element2);
                }
                break block4;
            }
            Role firstSide = this.getPreferredSide();
            for (IMatch match : matches) {
                element = match.get(firstSide);
                if (element == null) continue;
                result.add(element);
            }
            if (!result.isEmpty()) break block4;
            for (IMatch match : matches) {
                element = match.get(firstSide.opposite());
                if (element == null) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected EList<IDifference<?>> getDifferencesToMerge() {
        FArrayList result = new FArrayList();
        if (!this.asValuePresences().isEmpty()) {
            result.addAll(this.asValuePresences());
        } else if (!this.getSelectedMatches().isEmpty()) {
            for (IMatch match : this.getSelectedMatches()) {
                result.addAll((Collection)match.getAllDifferences());
            }
        } else {
            IValuePresence<?> presence = this.asValuePresence();
            if (presence != null) {
                result.add(presence);
            } else {
                IMatch<?> match = this.asMatch();
                Object feature = this.asFeature();
                if (match != null && feature != null) {
                    if (feature instanceof EAttribute) {
                        result.addAll(match.getAttributeDifferences(feature));
                    } else {
                        result.addAll(match.getReferenceDifferences(feature));
                    }
                } else if (match != null) {
                    result.addAll((Collection)match.getAllDifferences());
                }
            }
        }
        return result;
    }

    public Object getFirstElement() {
        List<Object> list = this.toList();
        return list.isEmpty() ? null : list.get(0);
    }

    protected Role getPreferredSide() {
        Role firstSide = this._preferredSide;
        if (firstSide == null) {
            firstSide = this.getDiffNode().getTargetRole();
        }
        if (firstSide == null) {
            firstSide = this.getDiffNode().getDrivingRole();
        }
        return firstSide;
    }

    public boolean isEmpty() {
        return this.toList().isEmpty();
    }

    public Iterator<Object> iterator() {
        return this.toList().iterator();
    }

    protected boolean representAsOwnership(IMergeableDifference<?> difference_p) {
        boolean result = false;
        if (difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence presence = (IReferenceValuePresence)difference_p;
            result = presence.isOwnership();
        }
        return result;
    }

    public int size() {
        return this.toList().size();
    }

    public Object[] toArray() {
        return this.toList().toArray();
    }

    public List<Object> toList() {
        if (this._concernedElements == null) {
            this._concernedElements = this.getConcernedElements();
        }
        return ECollections.unmodifiableEList(this._concernedElements);
    }

    public static List<IMatch<?>> selectionToMatches(IStructuredSelection selection_p, EMFDiffNode diffNode_p) {
        return ComparisonSelectionImpl.selectionToMatches(selection_p, diffNode_p, diffNode_p.getDrivingRole());
    }

    public static List<IMatch<?>> selectionToMatches(IStructuredSelection selection_p, EMFDiffNode diffNode_p, Role role_p) {
        FArrayList result = new FArrayList();
        GComparison comparison = diffNode_p.getActualComparison();
        if (comparison != null) {
            IMapping mapping = comparison.getMapping();
            Object[] objectArray = selection_p.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                IMatch match = mapping.getMatchFor(selectedElement, role_p);
                if (match == null) {
                    match = mapping.getMatchFor(selectedElement, role_p.opposite());
                }
                if (match != null) {
                    result.add(match);
                }
                ++n2;
            }
        }
        return result;
    }

    public static TreePath selectionToTreePath(IStructuredSelection selection_p, EMFDiffNode diffNode_p) {
        TreePath result = null;
        if (!selection_p.isEmpty()) {
            Role role = diffNode_p.getDrivingRole();
            Object singletonSelection = selection_p.size() == 1 ? selection_p : new StructuredSelection(selection_p.getFirstElement());
            List<IMatch<?>> convertedSelection = ComparisonSelectionImpl.selectionToMatches(singletonSelection, diffNode_p, role);
            if (!convertedSelection.isEmpty()) {
                IMatch<?> selectedMatch = convertedSelection.get(0);
                GComparison comparison = diffNode_p.getActualComparison();
                ITreeDataScope scope = comparison.getScope(role);
                IMapping mapping = comparison.getMapping();
                LinkedList treePathContents = new LinkedList();
                IMatch<?> treeNode = selectedMatch;
                while (treeNode != null) {
                    treePathContents.addFirst(treeNode);
                    Object element = treeNode.get(role);
                    Object parent = element == null ? null : scope.getContainer(element);
                    IMatch<?> iMatch = treeNode = parent == null ? null : mapping.getMatchFor(parent, role);
                }
                result = UIUtil.toTreePath(treePathContents);
            }
        }
        return result;
    }
}

