/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http11OutputBuffer
implements HttpOutputBuffer {
    protected static final StringManager sm = StringManager.getManager(Http11OutputBuffer.class);
    protected Response response;
    private volatile boolean ackSent = false;
    protected boolean responseFinished;
    protected final ByteBuffer headerBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected HttpOutputBuffer outputStreamOutputBuffer;
    protected SocketWrapperBase<?> socketWrapper;
    protected long byteCount = 0L;
    @Deprecated
    private boolean sendReasonPhrase = false;

    protected Http11OutputBuffer(Response response, int n, boolean bl) {
        this.response = response;
        this.sendReasonPhrase = bl;
        this.headerBuffer = ByteBuffer.allocate(n);
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.responseFinished = false;
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        if (bl) {
            HttpMessages.getInstance(response.getLocale()).getMessage(200);
        }
    }

    public void addFilter(OutputFilter outputFilter) {
        OutputFilter[] outputFilterArray = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            outputFilterArray[i] = this.filterLibrary[i];
        }
        outputFilterArray[this.filterLibrary.length] = outputFilter;
        this.filterLibrary = outputFilterArray;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(OutputFilter outputFilter) {
        if (this.lastActiveFilter == -1) {
            outputFilter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != outputFilter) continue;
                return;
            }
            outputFilter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = outputFilter;
        outputFilter.setResponse(this.response);
    }

    @Override
    @Deprecated
    public int doWrite(ByteChunk byteChunk) throws IOException {
        if (!this.response.isCommitted()) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(byteChunk);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(byteChunk);
    }

    @Override
    public int doWrite(ByteBuffer byteBuffer) throws IOException {
        if (!this.response.isCommitted()) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(byteBuffer);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(byteBuffer);
    }

    @Override
    public long getBytesWritten() {
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.getBytesWritten();
        }
        return this.activeFilters[this.lastActiveFilter].getBytesWritten();
    }

    @Override
    public void flush() throws IOException {
        if (this.lastActiveFilter == -1) {
            this.outputStreamOutputBuffer.flush();
        } else {
            this.activeFilters[this.lastActiveFilter].flush();
        }
    }

    @Override
    public void end() throws IOException {
        if (this.responseFinished) {
            return;
        }
        if (this.lastActiveFilter == -1) {
            this.outputStreamOutputBuffer.end();
        } else {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.responseFinished = true;
    }

    void resetHeaderBuffer() {
        this.headerBuffer.position(0).limit(this.headerBuffer.capacity());
    }

    public void recycle() {
        this.nextRequest();
        this.socketWrapper = null;
    }

    public void nextRequest() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.response.recycle();
        this.headerBuffer.position(0).limit(this.headerBuffer.capacity());
        this.lastActiveFilter = -1;
        this.ackSent = false;
        this.responseFinished = false;
        this.byteCount = 0L;
    }

    public void init(SocketWrapperBase<?> socketWrapperBase) {
        this.socketWrapper = socketWrapperBase;
    }

    public void sendAck() throws IOException {
        if (!this.response.isCommitted() && !this.ackSent) {
            this.ackSent = true;
            if (this.sendReasonPhrase) {
                this.socketWrapper.write(this.isBlocking(), org.apache.coyote.http11.Constants.ACK_BYTES_REASON, 0, org.apache.coyote.http11.Constants.ACK_BYTES_REASON.length);
            } else {
                this.socketWrapper.write(this.isBlocking(), org.apache.coyote.http11.Constants.ACK_BYTES, 0, org.apache.coyote.http11.Constants.ACK_BYTES.length);
            }
            if (this.flushBuffer(true)) {
                throw new IOException(sm.getString("iob.failedwrite.ack"));
            }
        }
    }

    protected void commit() throws IOException {
        this.response.setCommitted(true);
        if (this.headerBuffer.position() > 0) {
            this.headerBuffer.flip();
            try {
                this.socketWrapper.write(this.isBlocking(), this.headerBuffer);
            }
            finally {
                this.headerBuffer.position(0).limit(this.headerBuffer.capacity());
            }
        }
    }

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.headerBuffer.put((byte)32);
        int n = this.response.getStatus();
        switch (n) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(n);
            }
        }
        this.headerBuffer.put((byte)32);
        if (this.sendReasonPhrase) {
            String string = null;
            if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
                string = this.response.getMessage();
            }
            if (string == null) {
                this.write(HttpMessages.getInstance(this.response.getLocale()).getMessage(n));
            } else {
                this.write(string);
            }
        }
        this.headerBuffer.put((byte)13).put((byte)10);
    }

    public void sendHeader(MessageBytes messageBytes, MessageBytes messageBytes2) {
        this.write(messageBytes);
        this.headerBuffer.put((byte)58).put((byte)32);
        this.write(messageBytes2);
        this.headerBuffer.put((byte)13).put((byte)10);
    }

    public void endHeaders() {
        this.headerBuffer.put((byte)13).put((byte)10);
    }

    private void write(MessageBytes messageBytes) {
        if (messageBytes.getType() != 2) {
            messageBytes.toBytes();
            ByteChunk byteChunk = messageBytes.getByteChunk();
            byte[] byArray = byteChunk.getBuffer();
            for (int i = byteChunk.getOffset(); i < byteChunk.getLength(); ++i) {
                if ((byArray[i] <= -1 || byArray[i] > 31 || byArray[i] == 9) && byArray[i] != 127) continue;
                byArray[i] = 32;
            }
        }
        this.write(messageBytes.getByteChunk());
    }

    private void write(ByteChunk byteChunk) {
        int n = byteChunk.getLength();
        this.checkLengthBeforeWrite(n);
        this.headerBuffer.put(byteChunk.getBytes(), byteChunk.getStart(), n);
    }

    public void write(byte[] byArray) {
        this.checkLengthBeforeWrite(byArray.length);
        this.headerBuffer.put(byArray);
    }

    private void write(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        this.checkLengthBeforeWrite(n);
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (n2 <= 31 && n2 != 9 || n2 == 127 || n2 > 255) {
                n2 = 32;
            }
            this.headerBuffer.put((byte)n2);
        }
    }

    private void write(int n) {
        String string = Integer.toString(n);
        int n2 = string.length();
        this.checkLengthBeforeWrite(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            this.headerBuffer.put((byte)c);
        }
    }

    private void checkLengthBeforeWrite(int n) {
        if (this.headerBuffer.position() + n + 4 > this.headerBuffer.capacity()) {
            throw new HeadersTooLargeException(sm.getString("iob.responseheadertoolarge.error"));
        }
    }

    protected boolean flushBuffer(boolean bl) throws IOException {
        return this.socketWrapper.flush(bl);
    }

    protected final boolean isBlocking() {
        return this.response.getWriteListener() == null;
    }

    protected final boolean isReady() {
        boolean bl;
        boolean bl2 = bl = !this.hasDataToWrite();
        if (!bl) {
            this.socketWrapper.registerWriteInterest();
        }
        return bl;
    }

    public boolean hasDataToWrite() {
        return this.socketWrapper.hasDataToWrite();
    }

    public void registerWriteInterest() {
        this.socketWrapper.registerWriteInterest();
    }

    protected class SocketOutputBuffer
    implements HttpOutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        @Deprecated
        public int doWrite(ByteChunk byteChunk) throws IOException {
            int n = byteChunk.getLength();
            int n2 = byteChunk.getStart();
            byte[] byArray = byteChunk.getBuffer();
            Http11OutputBuffer.this.socketWrapper.write(Http11OutputBuffer.this.isBlocking(), byArray, n2, n);
            Http11OutputBuffer.this.byteCount += (long)n;
            return n;
        }

        @Override
        public int doWrite(ByteBuffer byteBuffer) throws IOException {
            try {
                int n = byteBuffer.remaining();
                Http11OutputBuffer.this.socketWrapper.write(Http11OutputBuffer.this.isBlocking(), byteBuffer);
                Http11OutputBuffer.this.byteCount += (long)(n -= byteBuffer.remaining());
                return n;
            }
            catch (IOException iOException) {
                Http11OutputBuffer.this.response.action(ActionCode.CLOSE_NOW, iOException);
                throw iOException;
            }
        }

        @Override
        public long getBytesWritten() {
            return Http11OutputBuffer.this.byteCount;
        }

        @Override
        public void end() throws IOException {
            Http11OutputBuffer.this.socketWrapper.flush(true);
        }

        @Override
        public void flush() throws IOException {
            Http11OutputBuffer.this.socketWrapper.flush(Http11OutputBuffer.this.isBlocking());
        }
    }
}

