/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.storeconfig.IStoreConfig;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFileMover;
import org.apache.catalina.storeconfig.StoreRegistry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StoreConfig
implements IStoreConfig {
    private static Log log = LogFactory.getLog(StoreConfig.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.storeconfig");
    private String serverFilename = "conf/server.xml";
    private StoreRegistry registry;
    private Server server;

    public String getServerFilename() {
        return this.serverFilename;
    }

    public void setServerFilename(String string) {
        this.serverFilename = string;
    }

    @Override
    public StoreRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setRegistry(StoreRegistry storeRegistry) {
        this.registry = storeRegistry;
    }

    @Override
    public void storeConfig() {
        this.store(this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeServer(String string, boolean bl, boolean bl2) throws MalformedObjectNameException {
        block11: {
            ObjectName objectName;
            if (string == null || string.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Please, call with a correct server ObjectName!");
                }
                return;
            }
            MBeanServer mBeanServer = MBeanUtils.createServer();
            if (mBeanServer.isRegistered(objectName = new ObjectName(string))) {
                try {
                    Server server = (Server)mBeanServer.getAttribute(objectName, "managedResource");
                    StoreDescription storeDescription = null;
                    storeDescription = this.getRegistry().findDescription(StandardContext.class);
                    if (storeDescription != null) {
                        boolean bl3 = storeDescription.isStoreSeparate();
                        boolean bl4 = storeDescription.isBackup();
                        boolean bl5 = storeDescription.isExternalAllowed();
                        try {
                            storeDescription.setStoreSeparate(true);
                            storeDescription.setBackup(bl);
                            storeDescription.setExternalAllowed(bl2);
                            this.store(server);
                            break block11;
                        }
                        finally {
                            storeDescription.setStoreSeparate(bl3);
                            storeDescription.setBackup(bl4);
                            storeDescription.setExternalAllowed(bl5);
                        }
                    }
                    this.store(server);
                }
                catch (Exception exception) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Object " + string + " is no a Server instance or store exception"), (Throwable)exception);
                    }
                    break block11;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Server " + string + " not found!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeContext(String string, boolean bl, boolean bl2) throws MalformedObjectNameException {
        block13: {
            ObjectName objectName;
            if (string == null || string.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Please, call with a correct context ObjectName!");
                }
                return;
            }
            MBeanServer mBeanServer = MBeanUtils.createServer();
            if (mBeanServer.isRegistered(objectName = new ObjectName(string))) {
                try {
                    Context context = (Context)mBeanServer.getAttribute(objectName, "managedResource");
                    URL uRL = context.getConfigFile();
                    if (uRL != null) {
                        try {
                            StoreDescription storeDescription = null;
                            storeDescription = this.getRegistry().findDescription(context.getClass());
                            if (storeDescription == null) break block13;
                            boolean bl3 = storeDescription.isStoreSeparate();
                            boolean bl4 = storeDescription.isBackup();
                            boolean bl5 = storeDescription.isExternalAllowed();
                            try {
                                storeDescription.setStoreSeparate(true);
                                storeDescription.setBackup(bl);
                                storeDescription.setExternalAllowed(bl2);
                                storeDescription.getStoreFactory().store(null, -2, context);
                                break block13;
                            }
                            finally {
                                storeDescription.setStoreSeparate(bl3);
                                storeDescription.setBackup(bl4);
                                storeDescription.setBackup(bl5);
                            }
                        }
                        catch (Exception exception) {
                            log.error((Object)exception);
                        }
                        break block13;
                    }
                    log.error((Object)("Missing configFile at Context " + context.getPath() + " to store!"));
                }
                catch (Exception exception) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Object " + string + " is no a context instance or store exception"), (Throwable)exception);
                    }
                    break block13;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Context " + string + " not found!"));
            }
        }
    }

    @Override
    public synchronized boolean store(Server server) {
        StoreFileMover storeFileMover = new StoreFileMover(System.getProperty("catalina.base"), this.getServerFilename(), this.getRegistry().getEncoding());
        try {
            try (PrintWriter printWriter = storeFileMover.getWriter();){
                this.store(printWriter, -2, server);
            }
            storeFileMover.move();
            return true;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("config.storeServerError"), (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean store(Context context) {
        try {
            StoreDescription storeDescription = null;
            storeDescription = this.getRegistry().findDescription(context.getClass());
            if (storeDescription != null) {
                boolean bl = storeDescription.isStoreSeparate();
                try {
                    storeDescription.setStoreSeparate(true);
                    storeDescription.getStoreFactory().store(null, -2, context);
                }
                finally {
                    storeDescription.setStoreSeparate(bl);
                }
            }
            return true;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("config.storeContextError", new Object[]{context.getName()}), (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(PrintWriter printWriter, int n, Context context) throws Exception {
        block5: {
            boolean bl = true;
            StoreDescription storeDescription = null;
            try {
                storeDescription = this.getRegistry().findDescription(context.getClass());
                if (storeDescription != null) {
                    bl = storeDescription.isStoreSeparate();
                    storeDescription.setStoreSeparate(false);
                    storeDescription.getStoreFactory().store(printWriter, n, context);
                }
                if (storeDescription == null) break block5;
                storeDescription.setStoreSeparate(bl);
            }
            catch (Throwable throwable) {
                if (storeDescription != null) {
                    storeDescription.setStoreSeparate(bl);
                } else {
                    log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{context.getClass()}));
                }
                throw throwable;
            }
        }
        log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{context.getClass()}));
    }

    @Override
    public void store(PrintWriter printWriter, int n, Host host) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(host.getClass());
        if (storeDescription != null) {
            storeDescription.getStoreFactory().store(printWriter, n, host);
        } else {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{host.getClass()}));
        }
    }

    @Override
    public void store(PrintWriter printWriter, int n, Service service) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(service.getClass());
        if (storeDescription != null) {
            storeDescription.getStoreFactory().store(printWriter, n, service);
        } else {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{service.getClass()}));
        }
    }

    @Override
    public void store(PrintWriter printWriter, int n, Server server) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(server.getClass());
        if (storeDescription != null) {
            storeDescription.getStoreFactory().store(printWriter, n, server);
        } else {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{server.getClass()}));
        }
    }
}

