/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.StoreManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class PersistentValve
extends ValveBase {
    private static final ClassLoader MY_CLASSLOADER = PersistentValve.class.getClassLoader();
    private volatile boolean clBindRequired;
    protected Pattern filter = null;
    private final Map<String, UsageCountingSemaphore> sessionToSemaphoreMap = new HashMap<String, UsageCountingSemaphore>();
    private boolean semaphoreFairness = true;
    private boolean semaphoreBlockOnAcquire = true;
    private boolean semaphoreAcquireUninterruptibly = true;

    public PersistentValve() {
        super(true);
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.clBindRequired = container instanceof Engine || container instanceof Host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block65: {
            Map<String, UsageCountingSemaphore> map;
            UsageCountingSemaphore usageCountingSemaphore;
            String string;
            block66: {
                Object object;
                Object object2;
                boolean bl;
                Context context;
                block60: {
                    block62: {
                        block63: {
                            block61: {
                                if (this.isRequestWithoutSession(request.getDecodedRequestURI())) {
                                    if (this.containerLog.isTraceEnabled()) {
                                        this.containerLog.trace((Object)sm.getString("persistentValve.requestIgnore", new Object[]{request.getDecodedRequestURI()}));
                                    }
                                    this.getNext().invoke(request, response);
                                    return;
                                }
                                if (this.containerLog.isTraceEnabled()) {
                                    this.containerLog.trace((Object)sm.getString("persistentValve.requestProcess", new Object[]{request.getDecodedRequestURI()}));
                                }
                                if ((context = request.getContext()) == null) {
                                    response.sendError(500, sm.getString("standardHost.noContext"));
                                    return;
                                }
                                string = request.getRequestedSessionId();
                                usageCountingSemaphore = null;
                                bl = true;
                                try {
                                    if (string == null) break block60;
                                    map = this.sessionToSemaphoreMap;
                                    synchronized (map) {
                                        usageCountingSemaphore = this.sessionToSemaphoreMap.get(string);
                                        if (usageCountingSemaphore == null) {
                                            usageCountingSemaphore = new UsageCountingSemaphore(this.semaphoreFairness);
                                            this.sessionToSemaphoreMap.put(string, usageCountingSemaphore);
                                        } else {
                                            usageCountingSemaphore.incrementUsageCount();
                                        }
                                    }
                                    if (!this.semaphoreBlockOnAcquire) break block61;
                                    if (this.semaphoreAcquireUninterruptibly) {
                                        usageCountingSemaphore.acquireUninterruptibly();
                                        break block60;
                                    }
                                    try {
                                        usageCountingSemaphore.acquire();
                                        break block60;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        bl = false;
                                        this.onSemaphoreNotAcquired(request, response);
                                        if (this.containerLog.isDebugEnabled()) {
                                            this.containerLog.debug((Object)sm.getString("persistentValve.acquireInterrupted", new Object[]{request.getDecodedRequestURI()}));
                                        }
                                        if (usageCountingSemaphore != null) {
                                            if (bl) {
                                                usageCountingSemaphore.release();
                                            }
                                            Map<String, UsageCountingSemaphore> map2 = this.sessionToSemaphoreMap;
                                            synchronized (map2) {
                                                long l = usageCountingSemaphore.decrementAndGetUsageCount();
                                                if (l == 0L) {
                                                    this.sessionToSemaphoreMap.remove(string);
                                                }
                                            }
                                        }
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (usageCountingSemaphore != null) {
                                        if (bl) {
                                            usageCountingSemaphore.release();
                                        }
                                        Map<String, UsageCountingSemaphore> map3 = this.sessionToSemaphoreMap;
                                        synchronized (map3) {
                                            long l = usageCountingSemaphore.decrementAndGetUsageCount();
                                            if (l == 0L) {
                                                this.sessionToSemaphoreMap.remove(string);
                                            }
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            if (usageCountingSemaphore.tryAcquire()) break block60;
                            this.onSemaphoreNotAcquired(request, response);
                            if (this.containerLog.isDebugEnabled()) {
                                this.containerLog.debug((Object)sm.getString("persistentValve.acquireFailed", new Object[]{request.getDecodedRequestURI()}));
                            }
                            if (usageCountingSemaphore == null) break block62;
                            if (!bl) break block63;
                            usageCountingSemaphore.release();
                        }
                        map = this.sessionToSemaphoreMap;
                        synchronized (map) {
                            long l = usageCountingSemaphore.decrementAndGetUsageCount();
                            if (l == 0L) {
                                this.sessionToSemaphoreMap.remove(string);
                            }
                        }
                    }
                    return;
                }
                map = context.getManager();
                if (string != null && map instanceof StoreManager && (object2 = ((StoreManager)((Object)map)).getStore()) != null) {
                    object = null;
                    try {
                        object = object2.load(string);
                    }
                    catch (Exception exception) {
                        this.containerLog.error((Object)sm.getString("persistentValve.sessionLoadFail", new Object[]{string}));
                    }
                    if (object != null) {
                        if (!object.isValid() || this.isSessionStale((Session)object, System.currentTimeMillis())) {
                            if (this.containerLog.isTraceEnabled()) {
                                this.containerLog.trace((Object)"session swapped in is invalid or expired");
                            }
                            object.expire();
                            object2.remove(string);
                        } else {
                            object.setManager((Manager)((Object)map));
                            map.add((Session)object);
                            object.access();
                            object.endAccess();
                        }
                    }
                }
                if (this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace((Object)("sessionId: " + string));
                }
                this.getNext().invoke(request, response);
                if (!request.isAsync()) {
                    try {
                        object2 = request.getSessionInternal(false);
                    }
                    catch (Exception exception) {
                        object2 = null;
                    }
                    object = null;
                    if (object2 != null) {
                        object = object2.getIdInternal();
                    }
                    if (this.containerLog.isTraceEnabled()) {
                        this.containerLog.trace((Object)("newsessionId: " + (String)object));
                    }
                    if (object != null) {
                        try {
                            this.bind(context);
                            if (map instanceof StoreManager) {
                                Session session = map.findSession((String)object);
                                Store store = ((StoreManager)((Object)map)).getStore();
                                boolean bl2 = false;
                                if (session != null && store != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                                    store.save(session);
                                    ((StoreManager)((Object)map)).removeSuper(session);
                                    session.recycle();
                                    bl2 = true;
                                }
                                if (!bl2 && this.containerLog.isTraceEnabled()) {
                                    this.containerLog.trace((Object)("newsessionId store: " + store + " session: " + session + " valid: " + (session == null ? "N/A" : Boolean.toString(session.isValid())) + " stale: " + this.isSessionStale(session, System.currentTimeMillis())));
                                }
                            } else if (this.containerLog.isTraceEnabled()) {
                                this.containerLog.trace((Object)("newsessionId Manager: " + map));
                            }
                        }
                        finally {
                            this.unbind(context);
                        }
                    }
                }
                if (usageCountingSemaphore == null) break block65;
                if (!bl) break block66;
                usageCountingSemaphore.release();
            }
            map = this.sessionToSemaphoreMap;
            synchronized (map) {
                long l = usageCountingSemaphore.decrementAndGetUsageCount();
                if (l == 0L) {
                    this.sessionToSemaphoreMap.remove(string);
                }
            }
        }
    }

    protected void onSemaphoreNotAcquired(Request request, Response response) throws IOException {
        response.sendError(429);
    }

    protected boolean isSessionStale(Session session, long l) {
        int n;
        int n2;
        return session != null && (n2 = session.getMaxInactiveInterval()) > 0 && (n = (int)(session.getIdleTimeInternal() / 1000L)) >= n2;
    }

    private void bind(Context context) {
        if (this.clBindRequired) {
            context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void unbind(Context context) {
        if (this.clBindRequired) {
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    protected boolean isRequestWithoutSession(String string) {
        Pattern pattern = this.filter;
        return pattern != null && pattern.matcher(string).matches();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.toString();
    }

    public void setFilter(String string) {
        if (string == null || string.length() == 0) {
            this.filter = null;
        } else {
            try {
                this.filter = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.container.getLogger().error((Object)sm.getString("persistentValve.filter.failure", new Object[]{string}), (Throwable)patternSyntaxException);
            }
        }
    }

    public boolean isSemaphoreFairness() {
        return this.semaphoreFairness;
    }

    public void setSemaphoreFairness(boolean bl) {
        this.semaphoreFairness = bl;
    }

    public boolean isSemaphoreBlockOnAcquire() {
        return this.semaphoreBlockOnAcquire;
    }

    public void setSemaphoreBlockOnAcquire(boolean bl) {
        this.semaphoreBlockOnAcquire = bl;
    }

    public boolean isSemaphoreAcquireUninterruptibly() {
        return this.semaphoreAcquireUninterruptibly;
    }

    public void setSemaphoreAcquireUninterruptibly(boolean bl) {
        this.semaphoreAcquireUninterruptibly = bl;
    }

    private static class UsageCountingSemaphore {
        private final AtomicLong usageCount = new AtomicLong(1L);
        private final Semaphore semaphore;

        private UsageCountingSemaphore(boolean bl) {
            this.semaphore = new Semaphore(1, bl);
        }

        private UsageCountingSemaphore incrementUsageCount() {
            this.usageCount.incrementAndGet();
            return this;
        }

        private long decrementAndGetUsageCount() {
            return this.usageCount.decrementAndGet();
        }

        private void acquire() throws InterruptedException {
            this.semaphore.acquire();
        }

        private void acquireUninterruptibly() {
            this.semaphore.acquireUninterruptibly();
        }

        private boolean tryAcquire() {
            return this.semaphore.tryAcquire();
        }

        private void release() {
            this.semaphore.release();
        }
    }
}

