/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler;

import com.alipay.sofa.jraft.error.RemotingException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.RetainedPersistManager;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.cs.channel.ChannelCloseFrom;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.facotry.MqttMessageFactory;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.infly.PushAction;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttSubscribeHandler
implements MqttPacketHandler<MqttSubscribeMessage> {
    private static Logger logger = LoggerFactory.getLogger(MqttSubscribeHandler.class);
    @Resource
    private SessionLoop sessionLoop;
    @Resource
    private ChannelManager channelManager;
    @Resource
    private RetainedPersistManager retainedPersistManager;
    @Resource
    private PushAction pushAction;
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("check_subscribe_future"));

    @Override
    public boolean preHandler(ChannelHandlerContext ctx, MqttSubscribeMessage mqttMessage) {
        return true;
    }

    @Override
    public void doHandler(ChannelHandlerContext ctx, MqttSubscribeMessage mqttMessage, HookResult upstreamHookResult) {
        String clientId = ChannelInfo.getClientId(ctx.channel());
        Channel channel = ctx.channel();
        if (!upstreamHookResult.isSuccess()) {
            this.channelManager.closeConnect(channel, ChannelCloseFrom.SERVER, upstreamHookResult.getRemark());
            return;
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ChannelInfo.setFuture(channel, "subscribe", future);
        this.scheduler.schedule(() -> {
            if (!future.isDone()) {
                future.complete(null);
            }
        }, 1L, TimeUnit.SECONDS);
        try {
            MqttSubscribePayload payload = mqttMessage.payload();
            List mqttTopicSubscriptions = payload.topicSubscriptions();
            HashSet<Subscription> subscriptions = new HashSet<Subscription>();
            if (mqttTopicSubscriptions != null && !mqttTopicSubscriptions.isEmpty()) {
                for (MqttTopicSubscription mqttTopicSubscription : mqttTopicSubscriptions) {
                    Subscription subscription = new Subscription();
                    subscription.setQos(mqttTopicSubscription.qualityOfService().value());
                    subscription.setTopicFilter(TopicUtils.normalizeTopic((String)mqttTopicSubscription.topicName()));
                    subscriptions.add(subscription);
                }
                this.sessionLoop.addSubscription(ChannelInfo.getId(ctx.channel()), subscriptions);
            }
            future.thenAccept(aVoid -> {
                if (!channel.isActive()) {
                    return;
                }
                ChannelInfo.removeFuture(channel, "subscribe");
                channel.writeAndFlush((Object)this.getResponse(mqttMessage));
                if (!subscriptions.isEmpty()) {
                    try {
                        this.sendRetainMessage(ctx, subscriptions);
                    }
                    catch (RemotingException | InterruptedException | org.apache.rocketmq.remoting.exception.RemotingException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Subscribe:{}", (Object)clientId, (Object)e);
            this.channelManager.closeConnect(channel, ChannelCloseFrom.SERVER, "SubscribeException");
        }
    }

    private MqttSubAckMessage getResponse(MqttSubscribeMessage mqttSubscribeMessage) {
        MqttSubscribePayload payload = mqttSubscribeMessage.payload();
        List mqttTopicSubscriptions = payload.topicSubscriptions();
        int[] qoss = new int[mqttTopicSubscriptions.size()];
        int i = 0;
        for (MqttTopicSubscription sub : mqttTopicSubscriptions) {
            qoss[i++] = sub.qualityOfService().value();
        }
        int messageId = mqttSubscribeMessage.variableHeader().messageId();
        return MqttMessageFactory.buildSubAckMessage(messageId, qoss);
    }

    private void sendRetainMessage(ChannelHandlerContext ctx, Set<Subscription> subscriptions) throws InterruptedException, RemotingException, org.apache.rocketmq.remoting.exception.RemotingException {
        String clientId = ChannelInfo.getClientId(ctx.channel());
        Session session = this.sessionLoop.getSession(ChannelInfo.getId(ctx.channel()));
        HashSet<Subscription> preciseTopics = new HashSet<Subscription>();
        HashSet<Subscription> wildcardTopics = new HashSet<Subscription>();
        for (Subscription subscription : subscriptions) {
            if (!TopicUtils.isWildCard((String)subscription.getTopicFilter())) {
                preciseTopics.add(subscription);
                continue;
            }
            wildcardTopics.add(subscription);
        }
        for (Subscription subscription : preciseTopics) {
            CompletableFuture retainedMessage = this.retainedPersistManager.getRetainedMessage(subscription.getTopicFilter());
            retainedMessage.whenComplete((msg, throwable) -> {
                if (msg == null) {
                    return;
                }
                this.pushAction._sendMessage(session, clientId, subscription, (Message)msg);
            });
        }
        for (Subscription subscription : wildcardTopics) {
            CompletableFuture future = this.retainedPersistManager.getMsgsFromTrie(subscription);
            future.whenComplete((msgsList, throwable) -> {
                for (Message msg : msgsList) {
                    if (msg == null) {
                        return;
                    }
                    this.pushAction._sendMessage(session, clientId, subscription, msg);
                }
            });
        }
    }
}

