/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rhea.DefaultRegionKVService;
import com.alipay.sofa.jraft.rhea.DescriberManager;
import com.alipay.sofa.jraft.rhea.JRaftHelper;
import com.alipay.sofa.jraft.rhea.RegionEngine;
import com.alipay.sofa.jraft.rhea.RegionKVService;
import com.alipay.sofa.jraft.rhea.StateListenerContainer;
import com.alipay.sofa.jraft.rhea.StoreEngineHelper;
import com.alipay.sofa.jraft.rhea.client.pd.HeartbeatSender;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.RemotePlacementDriverClient;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.RheaRuntimeException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metadata.RegionEpoch;
import com.alipay.sofa.jraft.rhea.metadata.Store;
import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.options.HeartbeatOptions;
import com.alipay.sofa.jraft.rhea.options.MemoryDBOptions;
import com.alipay.sofa.jraft.rhea.options.RegionEngineOptions;
import com.alipay.sofa.jraft.rhea.options.RocksDBOptions;
import com.alipay.sofa.jraft.rhea.options.StoreEngineOptions;
import com.alipay.sofa.jraft.rhea.rpc.ExtSerializerSupports;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.storage.BatchRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.KVClosureAdapter;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.MemoryRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.RocksRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.StorageType;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.NetUtil;
import com.alipay.sofa.jraft.rhea.util.Strings;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolMetricRegistry;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreEngine
implements Lifecycle<StoreEngineOptions>,
Describer {
    private static final Logger LOG = LoggerFactory.getLogger(StoreEngine.class);
    private final ConcurrentMap<Long, RegionKVService> regionKVServiceTable = Maps.newConcurrentMapLong();
    private final ConcurrentMap<Long, RegionEngine> regionEngineTable = Maps.newConcurrentMapLong();
    private final StateListenerContainer<Long> stateListenerContainer;
    private final PlacementDriverClient pdClient;
    private final long clusterId;
    private Long storeId;
    private final AtomicBoolean splitting = new AtomicBoolean(false);
    private long startTime = System.currentTimeMillis();
    private File dbPath;
    private RpcServer rpcServer;
    private BatchRawKVStore<?> rawKVStore;
    private HeartbeatSender heartbeatSender;
    private StoreEngineOptions storeOpts;
    private ExecutorService readIndexExecutor;
    private ExecutorService raftStateTrigger;
    private ExecutorService snapshotExecutor;
    private ExecutorService cliRpcExecutor;
    private ExecutorService raftRpcExecutor;
    private ExecutorService kvRpcExecutor;
    private ScheduledExecutorService metricsScheduler;
    private ScheduledReporter kvMetricsReporter;
    private ScheduledReporter threadPoolMetricsReporter;
    private boolean started;

    public StoreEngine(PlacementDriverClient pdClient, StateListenerContainer<Long> stateListenerContainer) {
        this.pdClient = (PlacementDriverClient)Requires.requireNonNull((Object)pdClient, (String)"pdClient");
        this.clusterId = pdClient.getClusterId();
        this.stateListenerContainer = (StateListenerContainer)Requires.requireNonNull(stateListenerContainer, (String)"stateListenerContainer");
    }

    public synchronized boolean init(StoreEngineOptions opts) {
        boolean useSharedRpcExecutor;
        if (this.started) {
            LOG.info("[StoreEngine] already started.");
            return true;
        }
        DescriberManager.getInstance().addDescriber(this);
        this.storeOpts = (StoreEngineOptions)Requires.requireNonNull((Object)opts, (String)"opts");
        Endpoint serverAddress = (Endpoint)Requires.requireNonNull((Object)opts.getServerAddress(), (String)"opts.serverAddress");
        int port = serverAddress.getPort();
        String ip = serverAddress.getIp();
        if (ip == null || "0.0.0.0".equals(ip)) {
            serverAddress = new Endpoint(NetUtil.getLocalCanonicalHostName(), port);
            opts.setServerAddress(serverAddress);
        }
        long metricsReportPeriod = opts.getMetricsReportPeriod();
        List<RegionEngineOptions> rOptsList = opts.getRegionEngineOptionsList();
        if (rOptsList == null || rOptsList.isEmpty()) {
            RegionEngineOptions rOpts = new RegionEngineOptions();
            rOpts.setRegionId(-1L);
            rOptsList = Lists.newArrayList();
            rOptsList.add(rOpts);
            opts.setRegionEngineOptionsList(rOptsList);
        }
        String clusterName = this.pdClient.getClusterName();
        for (RegionEngineOptions rOpts : rOptsList) {
            rOpts.setRaftGroupId(JRaftHelper.getJRaftGroupId(clusterName, rOpts.getRegionId()));
            rOpts.setServerAddress(serverAddress);
            if (Strings.isBlank(rOpts.getInitialServerList())) {
                rOpts.setInitialServerList(opts.getInitialServerList());
            }
            if (rOpts.getNodeOptions() == null) {
                rOpts.setNodeOptions(opts.getCommonNodeOptions() == null ? new NodeOptions() : opts.getCommonNodeOptions().copy());
            }
            if (rOpts.getMetricsReportPeriod() > 0L || metricsReportPeriod <= 0L) continue;
            rOpts.setMetricsReportPeriod(metricsReportPeriod);
        }
        Store store = this.pdClient.getStoreMetadata(opts);
        if (store == null || store.getRegions() == null || store.getRegions().isEmpty()) {
            LOG.error("Empty store metadata: {}.", (Object)store);
            return false;
        }
        this.storeId = store.getId();
        if (this.readIndexExecutor == null) {
            this.readIndexExecutor = StoreEngineHelper.createReadIndexExecutor(opts.getReadIndexCoreThreads());
        }
        if (this.raftStateTrigger == null) {
            this.raftStateTrigger = StoreEngineHelper.createRaftStateTrigger(opts.getLeaderStateTriggerCoreThreads());
        }
        if (this.snapshotExecutor == null) {
            this.snapshotExecutor = StoreEngineHelper.createSnapshotExecutor(opts.getSnapshotCoreThreads(), opts.getSnapshotMaxThreads());
        }
        if (!(useSharedRpcExecutor = opts.isUseSharedRpcExecutor())) {
            if (this.cliRpcExecutor == null) {
                this.cliRpcExecutor = StoreEngineHelper.createCliRpcExecutor(opts.getCliRpcCoreThreads());
            }
            if (this.raftRpcExecutor == null) {
                this.raftRpcExecutor = StoreEngineHelper.createRaftRpcExecutor(opts.getRaftRpcCoreThreads());
            }
            if (this.kvRpcExecutor == null) {
                this.kvRpcExecutor = StoreEngineHelper.createKvRpcExecutor(opts.getKvRpcCoreThreads());
            }
        }
        this.startMetricReporters(metricsReportPeriod);
        this.rpcServer = RaftRpcServerFactory.createRaftRpcServer((Endpoint)serverAddress, (Executor)this.raftRpcExecutor, (Executor)this.cliRpcExecutor);
        StoreEngineHelper.addKvStoreRequestProcessor(this.rpcServer, this);
        if (!this.rpcServer.init(null)) {
            LOG.error("Fail to init [RpcServer].");
            return false;
        }
        if (!this.initRawKVStore(opts)) {
            return false;
        }
        if (this.rawKVStore instanceof Describer) {
            DescriberManager.getInstance().addDescriber((Describer)this.rawKVStore);
        }
        if (!this.initAllRegionEngine(opts, store)) {
            LOG.error("Fail to init all [RegionEngine].");
            return false;
        }
        if (this.pdClient instanceof RemotePlacementDriverClient) {
            HeartbeatOptions heartbeatOpts = opts.getHeartbeatOptions();
            if (heartbeatOpts == null) {
                heartbeatOpts = new HeartbeatOptions();
            }
            this.heartbeatSender = new HeartbeatSender(this);
            if (!this.heartbeatSender.init(heartbeatOpts)) {
                LOG.error("Fail to init [HeartbeatSender].");
                return false;
            }
        }
        this.startTime = System.currentTimeMillis();
        LOG.info("[StoreEngine] start successfully: {}.", (Object)this);
        this.started = true;
        return true;
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        if (!this.regionEngineTable.isEmpty()) {
            for (RegionEngine engine : this.regionEngineTable.values()) {
                engine.shutdown();
            }
            this.regionEngineTable.clear();
        }
        if (this.rawKVStore != null) {
            this.rawKVStore.shutdown();
        }
        if (this.heartbeatSender != null) {
            this.heartbeatSender.shutdown();
        }
        this.regionKVServiceTable.clear();
        if (this.kvMetricsReporter != null) {
            this.kvMetricsReporter.stop();
        }
        if (this.threadPoolMetricsReporter != null) {
            this.threadPoolMetricsReporter.stop();
        }
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.readIndexExecutor);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.raftStateTrigger);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.snapshotExecutor);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.cliRpcExecutor);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.raftRpcExecutor);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.kvRpcExecutor);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.metricsScheduler);
        this.started = false;
        LOG.info("[StoreEngine] shutdown successfully.");
    }

    public PlacementDriverClient getPlacementDriverClient() {
        return this.pdClient;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public StoreEngineOptions getStoreOpts() {
        return this.storeOpts;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    public BatchRawKVStore<?> getRawKVStore() {
        return this.rawKVStore;
    }

    public RegionKVService getRegionKVService(long regionId) {
        return (RegionKVService)this.regionKVServiceTable.get(regionId);
    }

    public long getTotalSpace() {
        if (this.dbPath == null || !this.dbPath.exists()) {
            return 0L;
        }
        return this.dbPath.getTotalSpace();
    }

    public long getUsableSpace() {
        if (this.dbPath == null || !this.dbPath.exists()) {
            return 0L;
        }
        return this.dbPath.getUsableSpace();
    }

    public long getStoreUsedSpace() {
        if (this.dbPath == null || !this.dbPath.exists()) {
            return 0L;
        }
        return FileUtils.sizeOf((File)this.dbPath);
    }

    public Endpoint getSelfEndpoint() {
        return this.storeOpts == null ? null : this.storeOpts.getServerAddress();
    }

    public RegionEngine getRegionEngine(long regionId) {
        return (RegionEngine)this.regionEngineTable.get(regionId);
    }

    public List<RegionEngine> getAllRegionEngines() {
        return Lists.newArrayList(this.regionEngineTable.values());
    }

    public ExecutorService getReadIndexExecutor() {
        return this.readIndexExecutor;
    }

    public void setReadIndexExecutor(ExecutorService readIndexExecutor) {
        this.readIndexExecutor = readIndexExecutor;
    }

    public ExecutorService getRaftStateTrigger() {
        return this.raftStateTrigger;
    }

    public void setRaftStateTrigger(ExecutorService raftStateTrigger) {
        this.raftStateTrigger = raftStateTrigger;
    }

    public ExecutorService getSnapshotExecutor() {
        return this.snapshotExecutor;
    }

    public void setSnapshotExecutor(ExecutorService snapshotExecutor) {
        this.snapshotExecutor = snapshotExecutor;
    }

    public ExecutorService getCliRpcExecutor() {
        return this.cliRpcExecutor;
    }

    public void setCliRpcExecutor(ExecutorService cliRpcExecutor) {
        this.cliRpcExecutor = cliRpcExecutor;
    }

    public ExecutorService getRaftRpcExecutor() {
        return this.raftRpcExecutor;
    }

    public void setRaftRpcExecutor(ExecutorService raftRpcExecutor) {
        this.raftRpcExecutor = raftRpcExecutor;
    }

    public ExecutorService getKvRpcExecutor() {
        return this.kvRpcExecutor;
    }

    public void setKvRpcExecutor(ExecutorService kvRpcExecutor) {
        this.kvRpcExecutor = kvRpcExecutor;
    }

    public ScheduledExecutorService getMetricsScheduler() {
        return this.metricsScheduler;
    }

    public void setMetricsScheduler(ScheduledExecutorService metricsScheduler) {
        this.metricsScheduler = metricsScheduler;
    }

    public ScheduledReporter getKvMetricsReporter() {
        return this.kvMetricsReporter;
    }

    public void setKvMetricsReporter(ScheduledReporter kvMetricsReporter) {
        this.kvMetricsReporter = kvMetricsReporter;
    }

    public ScheduledReporter getThreadPoolMetricsReporter() {
        return this.threadPoolMetricsReporter;
    }

    public void setThreadPoolMetricsReporter(ScheduledReporter threadPoolMetricsReporter) {
        this.threadPoolMetricsReporter = threadPoolMetricsReporter;
    }

    public boolean removeAndStopRegionEngine(long regionId) {
        RegionEngine engine = (RegionEngine)this.regionEngineTable.get(regionId);
        if (engine != null) {
            engine.shutdown();
            return true;
        }
        return false;
    }

    public StateListenerContainer<Long> getStateListenerContainer() {
        return this.stateListenerContainer;
    }

    public List<Long> getLeaderRegionIds() {
        ArrayList<Long> regionIds = Lists.newArrayListWithCapacity(this.regionEngineTable.size());
        for (RegionEngine regionEngine : this.regionEngineTable.values()) {
            if (!regionEngine.isLeader()) continue;
            regionIds.add(regionEngine.getRegion().getId());
        }
        return regionIds;
    }

    public int getRegionCount() {
        return this.regionEngineTable.size();
    }

    public int getLeaderRegionCount() {
        int count = 0;
        for (RegionEngine regionEngine : this.regionEngineTable.values()) {
            if (!regionEngine.isLeader()) continue;
            ++count;
        }
        return count;
    }

    public boolean isBusy() {
        return this.splitting.get();
    }

    public void applySplit(Long regionId, Long newRegionId, KVStoreClosure closure) {
        long leastKeysOnSplit;
        byte[] endKey;
        Requires.requireNonNull((Object)regionId, (String)"regionId");
        Requires.requireNonNull((Object)newRegionId, (String)"newRegionId");
        if (this.regionEngineTable.containsKey(newRegionId)) {
            closure.setError(Errors.CONFLICT_REGION_ID);
            closure.run(new Status(-1, "Conflict region id %d", new Object[]{newRegionId}));
            return;
        }
        if (!this.splitting.compareAndSet(false, true)) {
            closure.setError(Errors.SERVER_BUSY);
            closure.run(new Status(-1, "Server is busy now"));
            return;
        }
        RegionEngine parentEngine = this.getRegionEngine(regionId);
        if (parentEngine == null) {
            closure.setError(Errors.NO_REGION_FOUND);
            closure.run(new Status(-1, "RegionEngine[%s] not found", new Object[]{regionId}));
            this.splitting.set(false);
            return;
        }
        if (!parentEngine.isLeader()) {
            closure.setError(Errors.NOT_LEADER);
            closure.run(new Status(-1, "RegionEngine[%s] not leader", new Object[]{regionId}));
            this.splitting.set(false);
            return;
        }
        Region parentRegion = parentEngine.getRegion();
        byte[] startKey = BytesUtil.nullToEmpty((byte[])parentRegion.getStartKey());
        long approximateKeys = this.rawKVStore.getApproximateKeysInRange(startKey, endKey = parentRegion.getEndKey());
        if (approximateKeys < (leastKeysOnSplit = this.storeOpts.getLeastKeysOnSplit())) {
            closure.setError(Errors.TOO_SMALL_TO_SPLIT);
            closure.run(new Status(-1, "RegionEngine[%s]'s keys less than %d", new Object[]{regionId, leastKeysOnSplit}));
            this.splitting.set(false);
            return;
        }
        byte[] splitKey = this.rawKVStore.jumpOver(startKey, approximateKeys >> 1);
        if (splitKey == null) {
            closure.setError(Errors.STORAGE_ERROR);
            closure.run(new Status(-1, "Fail to scan split key"));
            this.splitting.set(false);
            return;
        }
        KVOperation op = KVOperation.createRangeSplit(splitKey, regionId, newRegionId);
        Task task = new Task();
        task.setData(ByteBuffer.wrap(Serializers.getDefault().writeObject(op)));
        task.setDone((Closure)new KVClosureAdapter(closure, op));
        parentEngine.getNode().apply(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSplit(Long regionId, Long newRegionId, byte[] splitKey) {
        try {
            Requires.requireNonNull((Object)regionId, (String)"regionId");
            Requires.requireNonNull((Object)newRegionId, (String)"newRegionId");
            RegionEngine parent = this.getRegionEngine(regionId);
            Region region = parent.getRegion().copy();
            RegionEngineOptions rOpts = parent.copyRegionOpts();
            region.setId(newRegionId);
            region.setStartKey(splitKey);
            region.setRegionEpoch(new RegionEpoch(-1L, -1L));
            rOpts.setRegionId(newRegionId);
            rOpts.setStartKeyBytes(region.getStartKey());
            rOpts.setEndKeyBytes(region.getEndKey());
            rOpts.setRaftGroupId(JRaftHelper.getJRaftGroupId(this.pdClient.getClusterName(), newRegionId));
            rOpts.setRaftDataPath(null);
            String baseRaftDataPath = this.storeOpts.getRaftDataPath();
            if (Strings.isBlank(baseRaftDataPath)) {
                baseRaftDataPath = "";
            }
            rOpts.setRaftDataPath(baseRaftDataPath + "raft_data_region_" + region.getId() + "_" + this.getSelfEndpoint().getPort());
            RegionEngine engine = new RegionEngine(region, this);
            if (!engine.init(rOpts)) {
                LOG.error("Fail to init [RegionEngine: {}].", (Object)region);
                throw Errors.REGION_ENGINE_FAIL.exception();
            }
            Region pRegion = parent.getRegion();
            RegionEpoch pEpoch = pRegion.getRegionEpoch();
            long version = pEpoch.getVersion();
            pEpoch.setVersion(version + 1L);
            pRegion.setEndKey(splitKey);
            this.regionEngineTable.put(region.getId(), engine);
            this.registerRegionKVService(new DefaultRegionKVService(engine));
            this.pdClient.getRegionRouteTable().splitRegion(pRegion.getId(), region);
        }
        finally {
            this.splitting.set(false);
        }
    }

    private void startMetricReporters(long metricsReportPeriod) {
        if (metricsReportPeriod <= 0L) {
            return;
        }
        if (this.kvMetricsReporter == null) {
            if (this.metricsScheduler == null) {
                this.metricsScheduler = StoreEngineHelper.createMetricsScheduler();
            }
            this.kvMetricsReporter = Slf4jReporter.forRegistry((MetricRegistry)KVMetrics.metricRegistry()).prefixedWith("store_" + this.storeId).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).outputTo(LOG).scheduleOn(this.metricsScheduler).shutdownExecutorOnStop(false).build();
            this.kvMetricsReporter.start(metricsReportPeriod, TimeUnit.SECONDS);
        }
        if (this.threadPoolMetricsReporter == null) {
            if (this.metricsScheduler == null) {
                this.metricsScheduler = StoreEngineHelper.createMetricsScheduler();
            }
            this.threadPoolMetricsReporter = Slf4jReporter.forRegistry((MetricRegistry)ThreadPoolMetricRegistry.metricRegistry()).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).outputTo(LOG).scheduleOn(this.metricsScheduler).shutdownExecutorOnStop(false).build();
            this.threadPoolMetricsReporter.start(metricsReportPeriod, TimeUnit.SECONDS);
        }
    }

    private boolean initRawKVStore(StoreEngineOptions opts) {
        StorageType storageType = opts.getStorageType();
        switch (storageType) {
            case RocksDB: {
                return this.initRocksDB(opts);
            }
            case Memory: {
                return this.initMemoryDB(opts);
            }
        }
        throw new UnsupportedOperationException("unsupported storage type: " + (Object)((Object)storageType));
    }

    private boolean initRocksDB(StoreEngineOptions opts) {
        String dbPath;
        RocksDBOptions rocksOpts = opts.getRocksDBOptions();
        if (rocksOpts == null) {
            rocksOpts = new RocksDBOptions();
            opts.setRocksDBOptions(rocksOpts);
        }
        if (Strings.isNotBlank(dbPath = rocksOpts.getDbPath())) {
            try {
                FileUtils.forceMkdir((File)new File(dbPath));
            }
            catch (Throwable t) {
                LOG.error("Fail to make dir for dbPath {}.", (Object)dbPath);
                return false;
            }
        } else {
            dbPath = "";
        }
        String childPath = "db_" + this.storeId + "_" + opts.getServerAddress().getPort();
        rocksOpts.setDbPath(Paths.get(dbPath, childPath).toString());
        this.dbPath = new File(rocksOpts.getDbPath());
        RocksRawKVStore rocksRawKVStore = new RocksRawKVStore();
        if (!rocksRawKVStore.init(rocksOpts)) {
            LOG.error("Fail to init [RocksRawKVStore].");
            return false;
        }
        this.rawKVStore = rocksRawKVStore;
        return true;
    }

    private boolean initMemoryDB(StoreEngineOptions opts) {
        MemoryRawKVStore memoryRawKVStore;
        MemoryDBOptions memoryOpts = opts.getMemoryDBOptions();
        if (memoryOpts == null) {
            memoryOpts = new MemoryDBOptions();
            opts.setMemoryDBOptions(memoryOpts);
        }
        if (!(memoryRawKVStore = new MemoryRawKVStore()).init(memoryOpts)) {
            LOG.error("Fail to init [MemoryRawKVStore].");
            return false;
        }
        this.rawKVStore = memoryRawKVStore;
        return true;
    }

    private boolean initAllRegionEngine(StoreEngineOptions opts, Store store) {
        Requires.requireNonNull((Object)opts, (String)"opts");
        Requires.requireNonNull((Object)store, (String)"store");
        String baseRaftDataPath = opts.getRaftDataPath();
        if (Strings.isNotBlank(baseRaftDataPath)) {
            try {
                FileUtils.forceMkdir((File)new File(baseRaftDataPath));
            }
            catch (Throwable t) {
                LOG.error("Fail to make dir for raftDataPath: {}.", (Object)baseRaftDataPath);
                return false;
            }
        } else {
            baseRaftDataPath = "";
        }
        Endpoint serverAddress = opts.getServerAddress();
        List<RegionEngineOptions> rOptsList = opts.getRegionEngineOptionsList();
        List<Region> regionList = store.getRegions();
        Requires.requireTrue((rOptsList.size() == regionList.size() ? 1 : 0) != 0);
        for (int i = 0; i < rOptsList.size(); ++i) {
            RegionEngineOptions rOpts = rOptsList.get(i);
            if (!this.inConfiguration(rOpts.getServerAddress().toString(), rOpts.getInitialServerList())) continue;
            Region region = regionList.get(i);
            if (Strings.isBlank(rOpts.getRaftDataPath())) {
                String childPath = "raft_data_region_" + region.getId() + "_" + serverAddress.getPort();
                rOpts.setRaftDataPath(Paths.get(baseRaftDataPath, childPath).toString());
            }
            Requires.requireNonNull((Object)region.getRegionEpoch(), (String)"regionEpoch");
            RegionEngine engine = new RegionEngine(region, this);
            if (engine.init(rOpts)) {
                DefaultRegionKVService regionKVService = new DefaultRegionKVService(engine);
                this.registerRegionKVService(regionKVService);
                this.regionEngineTable.put(region.getId(), engine);
                continue;
            }
            LOG.error("Fail to init [RegionEngine: {}].", (Object)region);
            return false;
        }
        return true;
    }

    private boolean inConfiguration(String curr, String all) {
        PeerId currPeer = new PeerId();
        if (!currPeer.parse(curr)) {
            return false;
        }
        Configuration allConf = new Configuration();
        if (!allConf.parse(all)) {
            return false;
        }
        return allConf.contains(currPeer) || allConf.getLearners().contains(currPeer);
    }

    private void registerRegionKVService(RegionKVService regionKVService) {
        RegionKVService preService = this.regionKVServiceTable.putIfAbsent(regionKVService.getRegionId(), regionKVService);
        if (preService != null) {
            throw new RheaRuntimeException("RegionKVService[region=" + regionKVService.getRegionId() + "] has already been registered, can not register again!");
        }
    }

    public String toString() {
        return "StoreEngine{storeId=" + this.storeId + ", startTime=" + this.startTime + ", dbPath=" + this.dbPath + ", storeOpts=" + this.storeOpts + ", started=" + this.started + ", regions=" + this.getAllRegionEngines() + '}';
    }

    public void describe(Describer.Printer out) {
        out.println((Object)"StoreEngine:");
        out.print((Object)"  AllLeaderRegions:").println(this.getLeaderRegionIds());
        for (RegionEngine r : this.getAllRegionEngines()) {
            r.describe(out);
        }
    }

    static {
        ExtSerializerSupports.init();
    }
}

