/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.model;

import org.apache.rocketmq.mqtt.common.util.TopicUtils;

public class Subscription {
    private String topicFilter;
    private int qos;

    public Subscription() {
    }

    public Subscription(String topicFilter) {
        this.topicFilter = topicFilter;
    }

    public Subscription(String topicFilter, int qos) {
        this.topicFilter = topicFilter;
        this.qos = qos;
    }

    public String toFirstTopic() {
        return TopicUtils.decode(this.topicFilter).getFirstTopic();
    }

    public String toQueueName() {
        return this.topicFilter;
    }

    public static Subscription newP2pSubscription(String clientId) {
        Subscription p2pSubscription = new Subscription();
        p2pSubscription.setTopicFilter(TopicUtils.getP2pTopic(clientId));
        p2pSubscription.setQos(1);
        return p2pSubscription;
    }

    public static Subscription newRetrySubscription(String clientId) {
        Subscription retrySubscription = new Subscription();
        retrySubscription.setTopicFilter(TopicUtils.getRetryTopic(clientId));
        retrySubscription.setQos(1);
        return retrySubscription;
    }

    public boolean isRetry() {
        return TopicUtils.isRetryTopic(this.topicFilter);
    }

    public boolean isP2p() {
        return TopicUtils.isP2pTopic(this.topicFilter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return this.topicFilter != null ? this.topicFilter.equals(that.topicFilter) : that.topicFilter == null;
    }

    public int hashCode() {
        return this.topicFilter != null ? this.topicFilter.hashCode() : 0;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public void setTopicFilter(String topicFilter) {
        this.topicFilter = topicFilter;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public String toString() {
        return "Subscription{topicFilter='" + this.topicFilter + '\'' + ", qos=" + this.qos + '}';
    }
}

