/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.Lookup;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;

public class LookupImpl
extends BaseResource
implements Lookup {
    private final WebTarget v2lookup;
    private final boolean useTls;
    private final Topics topics;

    public LookupImpl(WebTarget web, Authentication auth, boolean useTls, long readTimeoutMs, Topics topics) {
        super(auth, readTimeoutMs);
        this.useTls = useTls;
        this.v2lookup = web.path("/lookup/v2");
        this.topics = topics;
    }

    public String lookupTopic(String topic) throws PulsarAdminException {
        return (String)this.sync(() -> this.lookupTopicAsync(topic));
    }

    public CompletableFuture<String> lookupTopicAsync(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget path = this.v2lookup.path(prefix).path(topicName.getLookupName());
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<LookupData>(){}).thenApply(lookupData -> this.useTls && StringUtils.isNotBlank((CharSequence)lookupData.getBrokerUrlTls()) ? lookupData.getBrokerUrlTls() : lookupData.getBrokerUrl());
    }

    public Map<String, String> lookupPartitionedTopic(String topic) throws PulsarAdminException {
        return (Map)this.sync(() -> this.lookupPartitionedTopicAsync(topic));
    }

    public CompletableFuture<Map<String, String>> lookupPartitionedTopicAsync(String topic) {
        CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        ((CompletableFuture)this.topics.getPartitionedTopicMetadataAsync(topic).thenAccept(partitionedTopicMetadata -> {
            int partitions = partitionedTopicMetadata.partitions;
            if (partitions <= 0) {
                future.completeExceptionally(new PulsarAdminException("Topic " + topic + " is not a partitioned topic"));
                return;
            }
            LinkedHashMap<CallSite, CompletableFuture<String>> lookupResult = new LinkedHashMap<CallSite, CompletableFuture<String>>(partitions);
            for (int i = 0; i < partitions; ++i) {
                String partitionTopicName = topic + "-partition-" + i;
                lookupResult.put((CallSite)((Object)partitionTopicName), this.lookupTopicAsync(partitionTopicName));
            }
            FutureUtil.waitForAll(new ArrayList(lookupResult.values())).whenComplete((url, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally(LookupImpl.getApiException(throwable.getCause()));
                    return;
                }
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (Map.Entry entry : lookupResult.entrySet()) {
                    try {
                        result.put((String)entry.getKey(), (String)((CompletableFuture)entry.getValue()).get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        future.completeExceptionally(e);
                        return;
                    }
                }
                future.complete(result);
            });
        })).exceptionally(throwable -> {
            future.completeExceptionally(LookupImpl.getApiException(throwable.getCause()));
            return null;
        });
        return future;
    }

    public String getBundleRange(String topic) throws PulsarAdminException {
        return (String)this.sync(() -> this.getBundleRangeAsync(topic));
    }

    public CompletableFuture<String> getBundleRangeAsync(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget path = this.v2lookup.path(prefix).path(topicName.getLookupName()).path("bundle");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }
}

