/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import com.google.common.base.Preconditions;
import javax.servlet.Servlet;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.configuration.VipStatus;
import org.apache.pulsar.common.util.ShutdownUtil;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketMultiTopicConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketReaderServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.admin.v1.WebSocketProxyStatsV1;
import org.apache.pulsar.websocket.admin.v2.WebSocketProxyStatsV2;
import org.apache.pulsar.websocket.service.ProxyServer;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class WebSocketServiceStarter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServiceStarter.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        try {
            commander.parseArgs(args);
            if (arguments.help) {
                commander.usage(commander.getOut());
                return;
            }
            if (arguments.generateDocs && arguments.configFile != null) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("websocket", (Object)commander);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            commander.getErr().println(e);
            return;
        }
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Need to specify a configuration file");
        try {
            String configFile = args[0];
            WebSocketProxyConfiguration config = WebSocketServiceStarter.loadConfig(configFile);
            ProxyServer proxyServer = new ProxyServer(config);
            WebSocketService service = new WebSocketService(config);
            WebSocketServiceStarter.start(proxyServer, service);
        }
        catch (Exception e) {
            log.error("Failed to start WebSocket service", (Throwable)e);
            ShutdownUtil.triggerImmediateForcefulShutdown();
        }
    }

    public static void start(ProxyServer proxyServer, WebSocketService service) throws Exception {
        proxyServer.addWebSocketServlet("/ws/producer", (Servlet)new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/consumer", (Servlet)new WebSocketConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/reader", (Servlet)new WebSocketReaderServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/producer", (Servlet)new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/consumer", (Servlet)new WebSocketConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v3/consumer", (Servlet)new WebSocketMultiTopicConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/reader", (Servlet)new WebSocketReaderServlet(service));
        proxyServer.addRestResource("/admin", "webProxyService", service, WebSocketProxyStatsV1.class);
        proxyServer.addRestResource("/admin/v2", "webProxyService", service, WebSocketProxyStatsV2.class);
        proxyServer.addRestResource("/", "statusFilePath", service.getConfig().getStatusFilePath(), VipStatus.class);
        proxyServer.start();
        service.start();
    }

    private static WebSocketProxyConfiguration loadConfig(String configFile) throws Exception {
        log.info("Loading configuration from {}", (Object)configFile);
        WebSocketProxyConfiguration config = (WebSocketProxyConfiguration)PulsarConfigurationLoader.create((String)configFile, WebSocketProxyConfiguration.class);
        PulsarConfigurationLoader.isComplete((Object)config);
        return config;
    }

    @CommandLine.Command(name="websocket", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class Arguments {
        @CommandLine.Parameters(description={"config file"}, arity="0..1")
        private String configFile = "";
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

