/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import org.apache.pulsar.client.impl.metrics.MetricsUtil;
import org.apache.pulsar.client.impl.metrics.Unit;

public class Counter {
    private final LongCounter counter;
    private final Attributes attributes;

    Counter(Meter meter, String name, Unit unit, String description, String topic, Attributes attributes) {
        LongCounterBuilder builder = meter.counterBuilder(name).setDescription(description).setUnit(unit.toString());
        if (topic != null) {
            if (builder instanceof ExtendedLongCounterBuilder) {
                ExtendedLongCounterBuilder eb = (ExtendedLongCounterBuilder)builder;
                eb.setAttributesAdvice(MetricsUtil.getDefaultAggregationLabels(attributes));
            }
            attributes = MetricsUtil.getTopicAttributes(topic, attributes);
        }
        this.counter = builder.build();
        this.attributes = attributes;
    }

    public void increment() {
        this.add(1);
    }

    public void add(int delta) {
        this.counter.add((long)delta, this.attributes);
    }
}

