/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander.converters;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import java.util.EnumSet;

public class EnumConverter<T extends Enum<T>>
implements IStringConverter<T> {
    private final String optionName;
    private final Class<T> clazz;

    public EnumConverter(String optionName, Class<T> clazz) {
        this.optionName = optionName;
        this.clazz = clazz;
    }

    @Override
    public T convert(String value) {
        try {
            try {
                return Enum.valueOf(this.clazz, value);
            }
            catch (IllegalArgumentException e) {
                return Enum.valueOf(this.clazz, value.toUpperCase());
            }
        }
        catch (Exception e) {
            throw new ParameterException("Invalid value for " + this.optionName + " parameter. Allowed values:" + EnumSet.allOf(this.clazz));
        }
    }
}

