/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter.rules.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Rule;

/**
 * Rule
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: RuleImpl.java 764612 2009-04-13 21:17:59Z taylor $
 */
public class RuleImpl extends IdentifiedImpl implements Rule
{
    private boolean useBase = true;
    private boolean popup = false;
    private String suffix = null;
    private String prefixes = null;
    private List ignorePrefixes = null; 
        
    public String toString()
    {
        return id;
    }

    public boolean getPopup()
    {
        return popup;
    }

    public String getSuffix()
    {
        return suffix;
    }

    public boolean getUseBase()
    {
        return useBase;
    }

    public void setPopup(boolean b)
    {
        popup = b;
    }

    public void setSuffix(String string)
    {
        suffix = string;
    }

    public void setUseBase(boolean b)
    {
        useBase = b;
    }
                    
    public void setIgnorePrefixes(String prefixes)
    {      
        this.prefixes = prefixes;                          
    }

    public String getIgnorePrefixes()
    {
        return this.prefixes;        
    }
    
    public boolean shouldRewrite(String url)
    {
        if (prefixes == null)
        {
            return true;
        }
        if (ignorePrefixes == null)
        {
            ignorePrefixes = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(prefixes, ",");
            while (tokenizer.hasMoreTokens())
            {
                String token = tokenizer.nextToken();
                ignorePrefixes.add(token);
            }            
            
        }
        
        Iterator list = ignorePrefixes.iterator();
        while (list.hasNext())
        {
            String prefix = (String)list.next();
            if (url.startsWith(prefix))
            {
                return false;
            }
        }
        return true;         
    }
    
        
}
